/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.plugins.tageditor.ac.AutoCompletionListViewer;
import org.openstreetmap.josm.plugins.tageditor.editor.TagEditor;
import org.openstreetmap.josm.plugins.tageditor.editor.TagEditorModel;
import org.openstreetmap.josm.plugins.tageditor.preset.ui.IPresetSelectorListener;
import org.openstreetmap.josm.plugins.tageditor.preset.ui.TabularPresetSelector;
import org.openstreetmap.josm.plugins.tageditor.tagspec.KeyValuePair;
import org.openstreetmap.josm.plugins.tageditor.tagspec.ui.ITagSelectorListener;
import org.openstreetmap.josm.plugins.tageditor.tagspec.ui.TabularTagSelector;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class TagEditorDialog
extends JDialog {
    private static TagEditorDialog instance = null;
    public static final Dimension PREFERRED_SIZE = new Dimension(700, 500);
    private TagEditor tagEditor = null;
    private AutoCompletionListViewer aclViewer = null;
    private AutoCompletionManager autocomplete = null;
    private OKAction okAction = null;
    private CancelAction cancelAction = null;

    public static TagEditorDialog getInstance() {
        if (instance == null) {
            instance = new TagEditorDialog();
        }
        return instance;
    }

    public TagEditorModel getModel() {
        return this.tagEditor.getModel();
    }

    protected JPanel buildButtonRow() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        this.okAction = new OKAction();
        pnl.add(new JButton(this.okAction));
        this.getModel().addPropertyChangeListener(this.okAction);
        this.cancelAction = new CancelAction();
        pnl.add(new JButton(this.cancelAction));
        return pnl;
    }

    protected JPanel buildTagGridPanel() {
        this.tagEditor = new TagEditor();
        AutoCompletionList autoCompletionList = new AutoCompletionList();
        this.aclViewer = new AutoCompletionListViewer(autoCompletionList);
        this.tagEditor.setAutoCompletionList(autoCompletionList);
        this.aclViewer.addAutoCompletionListListener(this.tagEditor);
        this.tagEditor.addComponentNotStoppingCellEditing(this.aclViewer);
        JPanel pnlTagGrid = new JPanel();
        pnlTagGrid.setLayout(new BorderLayout());
        pnlTagGrid.add((Component)this.tagEditor, "Center");
        pnlTagGrid.add((Component)this.aclViewer, "East");
        pnlTagGrid.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JSplitPane splitPane = new JSplitPane(1, this.tagEditor, this.aclViewer);
        splitPane.setOneTouchExpandable(false);
        splitPane.setDividerLocation(600);
        pnlTagGrid.add((Component)splitPane, "Center");
        return pnlTagGrid;
    }

    protected void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setModal(true);
        this.setSize(PREFERRED_SIZE);
        this.setTitle(I18n.tr((String)"JOSM Tag Editor Plugin", (Object[])new Object[0]));
        JPanel pnlTagGrid = this.buildTagGridPanel();
        TabularPresetSelector presetSelector = new TabularPresetSelector();
        presetSelector.addPresetSelectorListener(new IPresetSelectorListener(){

            @Override
            public void itemSelected(TaggingPreset item) {
                TagEditorDialog.this.tagEditor.stopEditing();
                TagEditorDialog.this.tagEditor.getModel().applyPreset(item);
                TagEditorDialog.this.tagEditor.requestFocusInTopLeftCell();
            }
        });
        JPanel pnlPresetSelector = new JPanel();
        pnlPresetSelector.setLayout(new BorderLayout());
        pnlPresetSelector.add((Component)presetSelector, "Center");
        pnlPresetSelector.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        TabularTagSelector tagSelector = new TabularTagSelector();
        tagSelector.addTagSelectorListener(new ITagSelectorListener(){

            @Override
            public void itemSelected(KeyValuePair pair) {
                TagEditorDialog.this.tagEditor.stopEditing();
                TagEditorDialog.this.tagEditor.getModel().applyKeyValuePair(pair);
                TagEditorDialog.this.tagEditor.requestFocusInTopLeftCell();
            }
        });
        JPanel pnlTagSelector = new JPanel();
        pnlTagSelector.setLayout(new BorderLayout());
        pnlTagSelector.add((Component)tagSelector, "Center");
        pnlTagSelector.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add((Component)pnlPresetSelector, I18n.tr((String)"Presets", (Object[])new Object[0]));
        tabbedPane.add((Component)pnlTagSelector, I18n.tr((String)"Tags", (Object[])new Object[0]));
        JSplitPane splitPane = new JSplitPane(0, tabbedPane, pnlTagGrid);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(200);
        Dimension minimumSize = new Dimension(100, 50);
        presetSelector.setMinimumSize(minimumSize);
        pnlTagGrid.setMinimumSize(minimumSize);
        this.getContentPane().add((Component)splitPane, "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TagEditorDialog.this.getModel().ensureOneTag();
                        TagEditorDialog.this.tagEditor.clearSelection();
                        TagEditorDialog.this.tagEditor.requestFocusInTopLeftCell();
                    }
                });
            }
        });
        this.getRootPane().getInputMap(2).put((KeyStroke)this.cancelAction.getValue("AcceleratorKey"), this.okAction.getValue("Name"));
        this.getRootPane().getActionMap().put(this.cancelAction.getValue("Name"), this.cancelAction);
        this.getRootPane().getInputMap(2).put((KeyStroke)this.okAction.getValue("AcceleratorKey"), this.okAction.getValue("Name"));
        this.getRootPane().getActionMap().put(this.okAction.getValue("Name"), this.okAction);
        this.aclViewer.installKeyAction(this.okAction);
        this.aclViewer.installKeyAction(this.cancelAction);
        presetSelector.installKeyAction(this.okAction);
        presetSelector.installKeyAction(this.cancelAction);
    }

    protected TagEditorDialog() {
        this.build();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow((Component)Main.parent, (Dimension)PREFERRED_SIZE)).applySafe((Window)this);
        } else if (this.isShowing()) {
            new WindowGeometry((Window)this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public void startEditSession() {
        this.tagEditor.getModel().clearAppliedPresets();
        this.tagEditor.getModel().initFromJOSMSelection();
        this.autocomplete = Main.getLayerManager().getEditLayer().data.getAutoCompletionManager();
        this.tagEditor.setAutoCompletionManager(this.autocomplete);
        this.getModel().ensureOneTag();
    }

    class OKAction
    extends AbstractAction
    implements PropertyChangeListener {
        public OKAction() {
            this.putValue("Name", I18n.tr((String)"OK", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"ok"));
            this.putValue("ShortDescription", I18n.tr((String)"Apply edited tags and close dialog", (Object[])new Object[0]));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl ENTER"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        public void run() {
            TagEditorDialog.this.tagEditor.stopEditing();
            TagEditorDialog.this.setVisible(false);
            TagEditorDialog.this.tagEditor.getModel().updateJOSMSelection();
            DataSet ds = Main.getLayerManager().getEditDataSet();
            ds.fireSelectionChanged();
            Main.parent.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals(TagEditorModel.PROP_DIRTY)) {
                return;
            }
            if (!evt.getNewValue().getClass().equals(Boolean.class)) {
                return;
            }
            boolean dirty = (Boolean)evt.getNewValue();
            this.setEnabled(dirty);
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr((String)"Cancel", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"cancel"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
            this.putValue("ShortDescription", I18n.tr((String)"Abort tag editing and close dialog", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            TagEditorDialog.this.setVisible(false);
        }
    }
}

