/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.DiffFeatureWriter;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Deprecated
public class TransactionStateDiff
implements Transaction.State {
    AbstractDataStore store;
    Transaction transaction;
    Map<String, Diff> typeNameDiff = new HashMap<String, Diff>();
    public static final SimpleFeature NULL = new SimpleFeature(){

        @Override
        public Object getAttribute(String path) {
            return null;
        }

        @Override
        public Object getAttribute(int index) {
            return null;
        }

        @Override
        public ReferencedEnvelope getBounds() {
            return null;
        }

        public Geometry getDefaultGeometry() {
            return null;
        }

        @Override
        public SimpleFeatureType getFeatureType() {
            return null;
        }

        @Override
        public String getID() {
            return null;
        }

        @Override
        public FeatureId getIdentifier() {
            return null;
        }

        @Override
        public void setAttribute(int position, Object val) {
        }

        @Override
        public void setAttribute(String path, Object attribute) throws IllegalAttributeException {
        }

        @Override
        public Object getAttribute(Name name) {
            return null;
        }

        @Override
        public int getAttributeCount() {
            return 0;
        }

        @Override
        public List<Object> getAttributes() {
            return null;
        }

        @Override
        public SimpleFeatureType getType() {
            return null;
        }

        @Override
        public void setAttribute(Name name, Object value) {
        }

        @Override
        public void setAttributes(List<Object> values) {
        }

        @Override
        public void setAttributes(Object[] values) {
        }

        @Override
        public void setDefaultGeometry(Object geometry) {
        }

        @Override
        public GeometryAttribute getDefaultGeometryProperty() {
            return null;
        }

        @Override
        public void setDefaultGeometryProperty(GeometryAttribute geometryAttribute) {
        }

        @Override
        public Collection<Property> getProperties(Name name) {
            return null;
        }

        @Override
        public Collection<Property> getProperties() {
            return null;
        }

        @Override
        public Collection<Property> getProperties(String name) {
            return null;
        }

        @Override
        public Property getProperty(Name name) {
            return null;
        }

        @Override
        public Property getProperty(String name) {
            return null;
        }

        @Override
        public Collection<? extends Property> getValue() {
            return null;
        }

        @Override
        public void setValue(Collection<Property> values) {
        }

        @Override
        public AttributeDescriptor getDescriptor() {
            return null;
        }

        @Override
        public Name getName() {
            return null;
        }

        @Override
        public Map<Object, Object> getUserData() {
            return null;
        }

        @Override
        public boolean isNillable() {
            return false;
        }

        @Override
        public void setValue(Object newValue) {
        }

        public String toString() {
            return "<NullFeature>";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object arg0) {
            return arg0 == this;
        }

        @Override
        public void validate() {
        }
    };

    public TransactionStateDiff(AbstractDataStore dataStore) {
        this.store = dataStore;
    }

    @Override
    public synchronized void setTransaction(Transaction transaction) {
        if (transaction != null) {
            this.transaction = transaction;
        } else {
            this.transaction = null;
            if (this.typeNameDiff != null) {
                for (Diff diff : this.typeNameDiff.values()) {
                    diff.clear();
                }
                this.typeNameDiff.clear();
            }
            this.store = null;
        }
    }

    public synchronized Diff diff(String typeName) throws IOException {
        if (!this.exists(typeName)) {
            throw new IOException(typeName + " not defined");
        }
        if (this.typeNameDiff.containsKey(typeName)) {
            return this.typeNameDiff.get(typeName);
        }
        Diff diff = new Diff();
        this.typeNameDiff.put(typeName, diff);
        return diff;
    }

    boolean exists(String typeName) {
        Object[] types;
        try {
            types = this.store.getTypeNames();
        }
        catch (IOException e) {
            return false;
        }
        Arrays.sort(types);
        return Arrays.binarySearch(types, typeName) != -1;
    }

    @Override
    public synchronized void addAuthorization(String AuthID) throws IOException {
    }

    @Override
    public synchronized void commit() throws IOException {
        for (Map.Entry<String, Diff> entry : this.typeNameDiff.entrySet()) {
            String typeName = entry.getKey();
            Diff diff = entry.getValue();
            this.applyDiff(typeName, diff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void applyDiff(String typeName, Diff diff) throws IOException {
        if (diff.isEmpty()) {
            return;
        }
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.store.createFeatureWriter(typeName, this.transaction);
        Exception cause = null;
        try {
            while (writer.hasNext()) {
                SimpleFeature feature = writer.next();
                String fid = feature.getID();
                if (!diff.getModified().containsKey(fid)) continue;
                SimpleFeature update = diff.getModified().get(fid);
                if (update == Diff.NULL) {
                    writer.remove();
                    this.store.listenerManager.fireFeaturesRemoved(typeName, this.transaction, ReferencedEnvelope.reference(feature.getBounds()), true);
                    continue;
                }
                try {
                    feature.setAttributes(update.getAttributes());
                    writer.write();
                    ReferencedEnvelope bounds = new ReferencedEnvelope((CoordinateReferenceSystem)null);
                    bounds.include(feature.getBounds());
                    bounds.include(update.getBounds());
                    this.store.listenerManager.fireFeaturesChanged(typeName, this.transaction, bounds, true);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Could update " + fid, e);
                }
            }
            Diff diff2 = diff;
            synchronized (diff2) {
                Iterator<String> i$ = diff.getAddedOrder().iterator();
                while (i$.hasNext()) {
                    String fid = i$.next();
                    SimpleFeature addedFeature = diff.getAdded().get(fid);
                    SimpleFeature nextFeature = writer.next();
                    if (nextFeature == null) {
                        throw new DataSourceException("Could not add " + fid);
                    }
                    try {
                        nextFeature.setAttributes(addedFeature.getAttributes());
                        nextFeature.getUserData().put(Hints.USE_PROVIDED_FID, true);
                        if (addedFeature.getUserData().containsKey(Hints.PROVIDED_FID)) {
                            String providedFid = (String)addedFeature.getUserData().get(Hints.PROVIDED_FID);
                            nextFeature.getUserData().put(Hints.PROVIDED_FID, providedFid);
                        } else {
                            nextFeature.getUserData().put(Hints.PROVIDED_FID, addedFeature.getID());
                        }
                        writer.write();
                        this.store.listenerManager.fireFeaturesAdded(typeName, this.transaction, ReferencedEnvelope.reference(nextFeature.getBounds()), true);
                    }
                    catch (IllegalAttributeException e) {
                        throw new DataSourceException("Could update " + fid, e);
                    }
                }
                return;
            }
        }
        catch (IOException e) {
            cause = e;
            throw e;
        }
        catch (RuntimeException e) {
            cause = e;
            throw e;
        }
        finally {
            try {
                writer.close();
                this.store.listenerManager.fireChanged(typeName, this.transaction, true);
                diff.clear();
            }
            catch (IOException e) {
                if (cause == null) throw e;
                e.initCause(cause);
                throw e;
            }
            catch (RuntimeException e) {
                if (cause == null) throw e;
                e.initCause(cause);
                throw e;
            }
        }
    }

    @Override
    public synchronized void rollback() throws IOException {
        for (Map.Entry<String, Diff> entry : this.typeNameDiff.entrySet()) {
            String typeName = entry.getKey();
            Diff diff = entry.getValue();
            diff.clear();
            this.store.listenerManager.fireChanged(typeName, this.transaction, false);
        }
    }

    public synchronized FeatureReader<SimpleFeatureType, SimpleFeature> reader(String typeName) throws IOException {
        Diff diff = this.diff(typeName);
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.store.getFeatureReader(typeName);
        return new DiffFeatureReader<SimpleFeatureType, SimpleFeature>(reader, diff);
    }

    public synchronized FeatureWriter<SimpleFeatureType, SimpleFeature> writer(final String typeName, Filter filter) throws IOException {
        Diff diff = this.diff(typeName);
        FilteringFeatureReader<SimpleFeatureType, SimpleFeature> reader = new FilteringFeatureReader<SimpleFeatureType, SimpleFeature>(this.store.getFeatureReader(typeName, new Query(typeName, filter)), filter);
        return new DiffFeatureWriter(reader, diff, filter){

            @Override
            public void fireNotification(int eventType, ReferencedEnvelope bounds) {
                switch (eventType) {
                    case 1: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesAdded(typeName, TransactionStateDiff.this.transaction, bounds, false);
                        break;
                    }
                    case 0: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesChanged(typeName, TransactionStateDiff.this.transaction, bounds, false);
                        break;
                    }
                    case -1: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesRemoved(typeName, TransactionStateDiff.this.transaction, bounds, false);
                    }
                }
            }

            public String toString() {
                return "<DiffFeatureWriter>(" + this.reader.toString() + ")";
            }
        };
    }
}

