/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.media.jai.ParameterBlockJAI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.util.NumberRange;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;

public class SubtractConst
extends OperationJAI {
    private static final long serialVersionUID = 279426577290256732L;

    public SubtractConst() {
        super("SubtractConst", SubtractConst.getOperationDescriptor(JAIExt.getOperationName("SubtractConst")));
    }

    @Override
    public String getName() {
        return "SubtractConst";
    }

    @Override
    protected NumberRange deriveRange(NumberRange[] ranges, OperationJAI.Parameters parameters) {
        double[] constants = (double[])parameters.parameters.getObjectParameter("constants");
        if (constants.length == 1) {
            double c = constants[0];
            NumberRange range = ranges[0];
            double min = range.getMinimum() - c;
            double max = range.getMaximum() - c;
            return NumberRange.create(min, max);
        }
        return super.deriveRange(ranges, parameters);
    }

    @Override
    protected void handleJAIEXTParams(ParameterBlockJAI parameters, ParameterValueGroup parameters2) {
        GridCoverage2D source = (GridCoverage2D)parameters2.parameter("source0").getValue();
        if (JAIExt.isJAIExtOperation("operationConst")) {
            parameters.set((Object)AlgebraDescriptor.Operator.SUBTRACT, 1);
        }
        SubtractConst.handleROINoDataInternal(parameters, source, "operationConst", 2, 3);
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        return SubtractConst.handleROINoDataProperties(null, parameters.parameters, sources[0], "operationConst", 2, 3, 4);
    }
}

