/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.equation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ejml.equation.ManagerTempVariables;
import org.ejml.equation.Operation;
import org.ejml.equation.Symbol;
import org.ejml.equation.Variable;

public class ManagerFunctions {
    Map<String, Input1> input1 = new HashMap<String, Input1>();
    Map<String, InputN> inputN = new HashMap<String, InputN>();
    protected ManagerTempVariables managerTemp;

    public ManagerFunctions() {
        this.addBuiltIn();
    }

    public boolean isFunctionName(String s) {
        if (this.input1.containsKey(s)) {
            return true;
        }
        return this.inputN.containsKey(s);
    }

    public Operation.Info create(String name, Variable var0) {
        Input1 func = this.input1.get(name);
        if (func == null) {
            return null;
        }
        return func.create(var0, this.managerTemp);
    }

    public Operation.Info create(String name, List<Variable> vars) {
        InputN func = this.inputN.get(name);
        if (func == null) {
            return null;
        }
        return func.create(vars, this.managerTemp);
    }

    public Operation.Info create(char op, Variable input) {
        switch (op) {
            case '\'': {
                return Operation.transpose(input, this.managerTemp);
            }
        }
        throw new RuntimeException("Unknown operation " + op);
    }

    public Operation.Info create(Symbol op, Variable left, Variable right) {
        switch (op) {
            case PLUS: {
                return Operation.add(left, right, this.managerTemp);
            }
            case MINUS: {
                return Operation.subtract(left, right, this.managerTemp);
            }
            case TIMES: {
                return Operation.multiply(left, right, this.managerTemp);
            }
            case RDIVIDE: {
                return Operation.divide(left, right, this.managerTemp);
            }
            case LDIVIDE: {
                return Operation.divide(right, left, this.managerTemp);
            }
            case POWER: {
                return Operation.pow(left, right, this.managerTemp);
            }
            case ELEMENT_DIVIDE: {
                return Operation.elementDivision(left, right, this.managerTemp);
            }
            case ELEMENT_TIMES: {
                return Operation.elementMult(left, right, this.managerTemp);
            }
            case ELEMENT_POWER: {
                return Operation.elementPow(left, right, this.managerTemp);
            }
        }
        throw new RuntimeException("Unknown operation " + (Object)((Object)op));
    }

    public void setManagerTemp(ManagerTempVariables managerTemp) {
        this.managerTemp = managerTemp;
    }

    public void add(String name, Input1 function) {
        this.input1.put(name, function);
    }

    public void add(String name, InputN function) {
        this.inputN.put(name, function);
    }

    private void addBuiltIn() {
        this.input1.put("inv", new Input1(){

            @Override
            public Operation.Info create(Variable A, ManagerTempVariables manager) {
                return Operation.inv(A, manager);
            }
        });
        this.input1.put("pinv", new Input1(){

            @Override
            public Operation.Info create(Variable A, ManagerTempVariables manager) {
                return Operation.pinv(A, manager);
            }
        });
        this.input1.put("rref", new Input1(){

            @Override
            public Operation.Info create(Variable A, ManagerTempVariables manager) {
                return Operation.rref(A, manager);
            }
        });
        this.input1.put("eye", new Input1(){

            @Override
            public Operation.Info create(Variable A, ManagerTempVariables manager) {
                return Operation.eye(A, manager);
            }
        });
        this.input1.put("det", new Input1(){

            @Override
            public Operation.Info create(Variable A, ManagerTempVariables manager) {
                return Operation.det(A, manager);
            }
        });
        this.input1.put("normF", new Input1(){

            @Override
            public Operation.Info create(Variable A, ManagerTempVariables manager) {
                return Operation.normF(A, manager);
            }
        });
        this.input1.put("trace", new Input1(){

            @Override
            public Operation.Info create(Variable A, ManagerTempVariables manager) {
                return Operation.trace(A, manager);
            }
        });
        this.input1.put("diag", new Input1(){

            @Override
            public Operation.Info create(Variable A, ManagerTempVariables manager) {
                return Operation.diag(A, manager);
            }
        });
        this.input1.put("min", new Input1(){

            @Override
            public Operation.Info create(Variable A, ManagerTempVariables manager) {
                return Operation.min(A, manager);
            }
        });
        this.input1.put("max", new Input1(){

            @Override
            public Operation.Info create(Variable A, ManagerTempVariables manager) {
                return Operation.max(A, manager);
            }
        });
        this.input1.put("abs", new Input1(){

            @Override
            public Operation.Info create(Variable A, ManagerTempVariables manager) {
                return Operation.abs(A, manager);
            }
        });
        this.input1.put("sin", new Input1(){

            @Override
            public Operation.Info create(Variable A, ManagerTempVariables manager) {
                return Operation.sin(A, manager);
            }
        });
        this.input1.put("cos", new Input1(){

            @Override
            public Operation.Info create(Variable A, ManagerTempVariables manager) {
                return Operation.cos(A, manager);
            }
        });
        this.input1.put("atan", new Input1(){

            @Override
            public Operation.Info create(Variable A, ManagerTempVariables manager) {
                return Operation.atan(A, manager);
            }
        });
        this.input1.put("exp", new Input1(){

            @Override
            public Operation.Info create(Variable A, ManagerTempVariables manager) {
                return Operation.exp(A, manager);
            }
        });
        this.input1.put("log", new Input1(){

            @Override
            public Operation.Info create(Variable A, ManagerTempVariables manager) {
                return Operation.log(A, manager);
            }
        });
        this.inputN.put("zeros", new InputN(){

            @Override
            public Operation.Info create(List<Variable> inputs, ManagerTempVariables manager) {
                if (inputs.size() != 2) {
                    throw new RuntimeException("Two inputs expected");
                }
                return Operation.zeros(inputs.get(0), inputs.get(1), manager);
            }
        });
        this.inputN.put("ones", new InputN(){

            @Override
            public Operation.Info create(List<Variable> inputs, ManagerTempVariables manager) {
                if (inputs.size() != 2) {
                    throw new RuntimeException("Two inputs expected");
                }
                return Operation.ones(inputs.get(0), inputs.get(1), manager);
            }
        });
        this.inputN.put("kron", new InputN(){

            @Override
            public Operation.Info create(List<Variable> inputs, ManagerTempVariables manager) {
                if (inputs.size() != 2) {
                    throw new RuntimeException("Two inputs expected");
                }
                return Operation.kron(inputs.get(0), inputs.get(1), manager);
            }
        });
        this.inputN.put("dot", new InputN(){

            @Override
            public Operation.Info create(List<Variable> inputs, ManagerTempVariables manager) {
                if (inputs.size() != 2) {
                    throw new RuntimeException("Two inputs expected");
                }
                return Operation.dot(inputs.get(0), inputs.get(1), manager);
            }
        });
        this.inputN.put("pow", new InputN(){

            @Override
            public Operation.Info create(List<Variable> inputs, ManagerTempVariables manager) {
                if (inputs.size() != 2) {
                    throw new RuntimeException("Two inputs expected");
                }
                return Operation.pow(inputs.get(0), inputs.get(1), manager);
            }
        });
        this.inputN.put("atan2", new InputN(){

            @Override
            public Operation.Info create(List<Variable> inputs, ManagerTempVariables manager) {
                if (inputs.size() != 2) {
                    throw new RuntimeException("Two inputs expected");
                }
                return Operation.atan2(inputs.get(0), inputs.get(1), manager);
            }
        });
        this.inputN.put("solve", new InputN(){

            @Override
            public Operation.Info create(List<Variable> inputs, ManagerTempVariables manager) {
                if (inputs.size() != 2) {
                    throw new RuntimeException("Two inputs expected");
                }
                return Operation.solve(inputs.get(0), inputs.get(1), manager);
            }
        });
        this.inputN.put("extract", new InputN(){

            @Override
            public Operation.Info create(List<Variable> inputs, ManagerTempVariables manager) {
                return Operation.extract(inputs, manager);
            }
        });
    }

    public ManagerTempVariables getManagerTemp() {
        return this.managerTemp;
    }

    public static interface InputN {
        public Operation.Info create(List<Variable> var1, ManagerTempVariables var2);
    }

    public static interface Input1 {
        public Operation.Info create(Variable var1, ManagerTempVariables var2);
    }
}

