/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.preset.ui;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;

public class PresetsTableModel
extends AbstractTableModel {
    private final ArrayList<TableModelListener> listeners = new ArrayList();
    private final ArrayList<TaggingPreset> items = new ArrayList();
    private final ArrayList<TaggingPreset> visibleItems = new ArrayList();

    protected void initModelFromPresets(Collection<TaggingPreset> presets) {
        this.items.clear();
        this.visibleItems.clear();
        this.items.addAll(presets);
        this.visibleItems.addAll(presets);
    }

    public Collection<TaggingPreset> getPresets() {
        return this.items;
    }

    public void setPresets(Collection<TaggingPreset> presets) {
        this.initModelFromPresets(presets);
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTableModelListener(TableModelListener l) {
        ArrayList<TableModelListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (l == null) {
                return;
            }
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.visibleItems.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TaggingPreset item = this.visibleItems.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return item.group;
            }
            case 1: {
                return item;
            }
        }
        return "unknown";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTableModelListener(TableModelListener l) {
        ArrayList<TableModelListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (this.listeners.contains(l)) {
                this.listeners.remove(l);
            }
        }
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }

    public TaggingPreset getVisibleItem(int idx) {
        if (idx < 0 || idx >= this.visibleItems.size()) {
            throw new IndexOutOfBoundsException("index out of bounds. idx=" + idx);
        }
        return this.visibleItems.get(idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(String filter) {
        PresetsTableModel presetsTableModel = this;
        synchronized (presetsTableModel) {
            if (filter == null || filter.trim().equals("")) {
                this.visibleItems.clear();
                for (TaggingPreset item : this.items) {
                    this.visibleItems.add(item);
                }
            } else {
                this.visibleItems.clear();
                filter = filter.toLowerCase();
                for (TaggingPreset item : this.items) {
                    if ((item.getName() == null || !item.getName().toLowerCase().trim().contains(filter)) && (item.group == null || item.group.getName() == null || !item.group.getName().toLowerCase().trim().contains(filter))) continue;
                    this.visibleItems.add(item);
                }
            }
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
        }
    }
}

