/*
 * Decompiled with CFR 0.152.
 */
package s57;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.CRC32;
import s57.S57att;
import s57.S57dat;
import s57.S57map;
import s57.S57obj;
import s57.S57osm;
import s57.S57val;

public class S57enc {
    private static final byte[] header = new byte[]{48, 49, 53, 55, 54, 51, 76, 69, 49, 32, 48, 57, 48, 48, 50, 48, 49, 32, 33, 32, 51, 52, 48, 52, 48, 48, 48, 48, 49, 50, 51, 48, 48, 48, 48, 48, 48, 48, 49, 48, 52, 55, 48, 49, 50, 51, 68, 83, 73, 68, 49, 53, 57, 48, 49, 55, 48, 68, 83, 83, 73, 49, 49, 51, 48, 51, 50, 57, 68, 83, 80, 77, 49, 51, 48, 48, 52, 52, 50, 70, 82, 73, 68, 49, 48, 48, 48, 53, 55, 50, 70, 79, 73, 68, 48, 55, 48, 48, 54, 55, 50, 65, 84, 84, 70, 48, 53, 57, 48, 55, 52, 50, 78, 65, 84, 70, 48, 54, 56, 48, 56, 48, 49, 70, 70, 80, 84, 48, 56, 54, 48, 56, 54, 57, 70, 83, 80, 84, 48, 57, 48, 48, 57, 53, 53, 86, 82, 73, 68, 48, 55, 56, 49, 48, 52, 53, 65, 84, 84, 86, 48, 53, 56, 49, 49, 50, 51, 86, 82, 80, 84, 48, 55, 54, 49, 49, 56, 49, 83, 71, 50, 68, 48, 52, 56, 49, 50, 53, 55, 83, 71, 51, 68, 48, 55, 48, 49, 51, 48, 53, 30, 48, 48, 48, 48, 59, 38, 32, 32, 32, 31, 48, 48, 48, 49, 68, 83, 73, 68, 68, 83, 73, 68, 68, 83, 83, 73, 48, 48, 48, 49, 68, 83, 80, 77, 48, 48, 48, 49, 70, 82, 73, 68, 70, 82, 73, 68, 70, 79, 73, 68, 70, 82, 73, 68, 65, 84, 84, 70, 70, 82, 73, 68, 78, 65, 84, 70, 70, 82, 73, 68, 70, 70, 80, 84, 70, 82, 73, 68, 70, 83, 80, 84, 48, 48, 48, 49, 86, 82, 73, 68, 86, 82, 73, 68, 65, 84, 84, 86, 86, 82, 73, 68, 86, 82, 80, 84, 86, 82, 73, 68, 83, 71, 50, 68, 86, 82, 73, 68, 83, 71, 51, 68, 30, 48, 53, 48, 48, 59, 38, 32, 32, 32, 73, 83, 79, 47, 73, 69, 67, 32, 56, 50, 49, 49, 32, 82, 101, 99, 111, 114, 100, 32, 73, 100, 101, 110, 116, 105, 102, 105, 101, 114, 31, 31, 40, 98, 49, 50, 41, 30, 49, 54, 48, 48, 59, 38, 32, 32, 32, 68, 97, 116, 97, 32, 83, 101, 116, 32, 73, 100, 101, 110, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 31, 82, 67, 78, 77, 33, 82, 67, 73, 68, 33, 69, 88, 80, 80, 33, 73, 78, 84, 85, 33, 68, 83, 78, 77, 33, 69, 68, 84, 78, 33, 85, 80, 68, 78, 33, 85, 65, 68, 84, 33, 73, 83, 68, 84, 33, 83, 84, 69, 68, 33, 80, 82, 83, 80, 33, 80, 83, 68, 78, 33, 80, 82, 69, 68, 33, 80, 82, 79, 70, 33, 65, 71, 69, 78, 33, 67, 79, 77, 84, 31, 40, 98, 49, 49, 44, 98, 49, 52, 44, 50, 98, 49, 49, 44, 51, 65, 44, 50, 65, 40, 56, 41, 44, 82, 40, 52, 41, 44, 98, 49, 49, 44, 50, 65, 44, 98, 49, 49, 44, 98, 49, 50, 44, 65, 41, 30, 49, 54, 48, 48, 59, 38, 32, 32, 32, 68, 97, 116, 97, 32, 115, 101, 116, 32, 115, 116, 114, 117, 99, 116, 117, 114, 101, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 102, 105, 101, 108, 100, 31, 68, 83, 84, 82, 33, 65, 65, 76, 76, 33, 78, 65, 76, 76, 33, 78, 79, 77, 82, 33, 78, 79, 67, 82, 33, 78, 79, 71, 82, 33, 78, 79, 76, 82, 33, 78, 79, 73, 78, 33, 78, 79, 67, 78, 33, 78, 79, 69, 68, 33, 78, 79, 70, 65, 31, 40, 51, 98, 49, 49, 44, 56, 98, 49, 52, 41, 30, 49, 54, 48, 48, 59, 38, 32, 32, 32, 68, 97, 116, 97, 32, 115, 101, 116, 32, 112, 97, 114, 97, 109, 101, 116, 101, 114, 32, 102, 105, 101, 108, 100, 31, 82, 67, 78, 77, 33, 82, 67, 73, 68, 33, 72, 68, 65, 84, 33, 86, 68, 65, 84, 33, 83, 68, 65, 84, 33, 67, 83, 67, 76, 33, 68, 85, 78, 73, 33, 72, 85, 78, 73, 33, 80, 85, 78, 73, 33, 67, 79, 85, 78, 33, 67, 79, 77, 70, 33, 83, 79, 77, 70, 33, 67, 79, 77, 84, 31, 40, 98, 49, 49, 44, 98, 49, 52, 44, 51, 98, 49, 49, 44, 98, 49, 52, 44, 52, 98, 49, 49, 44, 50, 98, 49, 52, 44, 65, 41, 30, 49, 54, 48, 48, 59, 38, 32, 32, 32, 70, 101, 97, 116, 117, 114, 101, 32, 114, 101, 99, 111, 114, 100, 32, 105, 100, 101, 110, 116, 105, 102, 105, 101, 114, 32, 102, 105, 101, 108, 100, 31, 82, 67, 78, 77, 33, 82, 67, 73, 68, 33, 80, 82, 73, 77, 33, 71, 82, 85, 80, 33, 79, 66, 74, 76, 33, 82, 86, 69, 82, 33, 82, 85, 73, 78, 31, 40, 98, 49, 49, 44, 98, 49, 52, 44, 50, 98, 49, 49, 44, 50, 98, 49, 50, 44, 98, 49, 49, 41, 30, 49, 54, 48, 48, 59, 38, 32, 32, 32, 70, 101, 97, 116, 117, 114, 101, 32, 111, 98, 106, 101, 99, 116, 32, 105, 100, 101, 110, 116, 105, 102, 105, 101, 114, 32, 102, 105, 101, 108, 100, 31, 65, 71, 69, 78, 33, 70, 73, 68, 78, 33, 70, 73, 68, 83, 31, 40, 98, 49, 50, 44, 98, 49, 52, 44, 98, 49, 50, 41, 30, 50, 54, 48, 48, 59, 38, 45, 65, 32, 70, 101, 97, 116, 117, 114, 101, 32, 114, 101, 99, 111, 114, 100, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 102, 105, 101, 108, 100, 31, 42, 65, 84, 84, 76, 33, 65, 84, 86, 76, 31, 40, 98, 49, 50, 44, 65, 41, 30, 50, 54, 48, 48, 59, 38, 45, 65, 32, 70, 101, 97, 116, 117, 114, 101, 32, 114, 101, 99, 111, 114, 100, 32, 110, 97, 116, 105, 111, 110, 97, 108, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 102, 105, 101, 108, 100, 31, 42, 65, 84, 84, 76, 33, 65, 84, 86, 76, 31, 40, 98, 49, 50, 44, 65, 41, 30, 50, 54, 48, 48, 59, 38, 32, 32, 32, 70, 101, 97, 116, 117, 114, 101, 32, 114, 101, 99, 111, 114, 100, 32, 116, 111, 32, 102, 101, 97, 116, 117, 114, 101, 32, 111, 98, 106, 101, 99, 116, 32, 112, 111, 105, 110, 116, 101, 114, 32, 102, 105, 101, 108, 100, 31, 42, 76, 78, 65, 77, 33, 82, 73, 78, 68, 33, 67, 79, 77, 84, 31, 40, 66, 40, 54, 52, 41, 44, 98, 49, 49, 44, 65, 41, 30, 50, 54, 48, 48, 59, 38, 32, 32, 32, 70, 101, 97, 116, 117, 114, 101, 32, 114, 101, 99, 111, 114, 100, 32, 116, 111, 32, 115, 112, 97, 116, 105, 97, 108, 32, 114, 101, 99, 111, 114, 100, 32, 112, 111, 105, 110, 116, 101, 114, 32, 102, 105, 101, 108, 100, 31, 42, 78, 65, 77, 69, 33, 79, 82, 78, 84, 33, 85, 83, 65, 71, 33, 77, 65, 83, 75, 31, 40, 66, 40, 52, 48, 41, 44, 51, 98, 49, 49, 41, 30, 49, 54, 48, 48, 59, 38, 32, 32, 32, 86, 101, 99, 116, 111, 114, 32, 114, 101, 99, 111, 114, 100, 32, 105, 100, 101, 110, 116, 105, 102, 105, 101, 114, 32, 102, 105, 101, 108, 100, 31, 82, 67, 78, 77, 33, 82, 67, 73, 68, 33, 82, 86, 69, 82, 33, 82, 85, 73, 78, 31, 40, 98, 49, 49, 44, 98, 49, 52, 44, 98, 49, 50, 44, 98, 49, 49, 41, 30, 50, 54, 48, 48, 59, 38, 32, 32, 32, 86, 101, 99, 116, 111, 114, 32, 114, 101, 99, 111, 114, 100, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 102, 105, 101, 108, 100, 31, 42, 65, 84, 84, 76, 33, 65, 84, 86, 76, 31, 40, 98, 49, 50, 44, 65, 41, 30, 50, 54, 48, 48, 59, 38, 32, 32, 32, 86, 101, 99, 116, 111, 114, 32, 114, 101, 99, 111, 114, 100, 32, 112, 111, 105, 110, 116, 101, 114, 32, 102, 105, 101, 108, 100, 31, 42, 78, 65, 77, 69, 33, 79, 82, 78, 84, 33, 85, 83, 65, 71, 33, 84, 79, 80, 73, 33, 77, 65, 83, 75, 31, 40, 66, 40, 52, 48, 41, 44, 52, 98, 49, 49, 41, 30, 50, 54, 48, 48, 59, 38, 32, 32, 32, 50, 45, 68, 32, 99, 111, 111, 114, 100, 105, 110, 97, 116, 101, 32, 102, 105, 101, 108, 100, 31, 42, 89, 67, 79, 79, 33, 88, 67, 79, 79, 31, 40, 50, 98, 50, 52, 41, 30, 50, 54, 48, 48, 59, 38, 32, 32, 32, 51, 45, 68, 32, 99, 111, 111, 114, 100, 105, 110, 97, 116, 101, 32, 40, 115, 111, 117, 110, 100, 105, 110, 103, 32, 97, 114, 114, 97, 121, 41, 32, 102, 105, 101, 108, 100, 31, 42, 89, 67, 79, 79, 33, 88, 67, 79, 79, 33, 86, 69, 51, 68, 31, 40, 51, 98, 50, 52, 41, 30};
    static final double COMF = 1.0E7;
    static final double SOMF = 10.0;
    static String file = "0S000000.000";
    static int intu = 0;
    static String code = "0S";
    static int agen = 3878;
    static int cscl = 10000;
    static int vdat = 23;
    static int duni = 1;
    static int huni = 1;
    static int idx;
    static int recs;
    static int isols;
    static int conns;
    static int metas;
    static int geos;
    static int edges;

    static long hash(long val) {
        byte[] bval = ByteBuffer.allocate(64).putLong(val).array();
        CRC32 crc = new CRC32();
        crc.update(bval);
        return crc.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public static int encodeChart(S57map map, HashMap<String, String> meta, byte[] buf) throws IndexOutOfBoundsException, UnsupportedEncodingException {
        ArrayList<S57dat.Fparams> fields;
        S57map.Snode node;
        for (Map.Entry<String, String> entry : meta.entrySet()) {
            try {
                switch (entry.getKey()) {
                    case "FILE": {
                        file = entry.getValue();
                        break;
                    }
                    case "INTU": {
                        intu = Integer.parseInt(entry.getValue());
                        break;
                    }
                    case "AGEN": {
                        String[] tokens = entry.getValue().split("/");
                        code = tokens[0];
                        agen = Integer.parseInt(tokens[1]);
                        break;
                    }
                    case "VDAT": {
                        vdat = Integer.parseInt(entry.getValue());
                        break;
                    }
                    case "CSCL": {
                        cscl = Integer.parseInt(entry.getValue());
                        break;
                    }
                    case "DUNI": {
                        duni = Integer.parseInt(entry.getValue());
                        break;
                    }
                    case "HUNI": {
                        huni = Integer.parseInt(entry.getValue());
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Meta data (" + entry.getKey() + "=" + entry.getValue() + "):" + e.getMessage());
                System.exit(-1);
            }
        }
        if (!map.features.containsKey((Object)S57obj.Obj.M_COVR)) {
            S57osm.OSMmeta(map);
        }
        S57dat.S57geoms(map);
        edges = 0;
        geos = 0;
        metas = 0;
        conns = 0;
        isols = 0;
        String date = new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime());
        ArrayList<S57dat.Fparams> ds = new ArrayList<S57dat.Fparams>();
        ds.add(new S57dat.Fparams(S57dat.S57field.DSID, new Object[]{10, 1, 1, intu, file, "1", "0", date, date, "03.1", 1, "ENC", "2.0", 1, agen, "Generated by OpenSeaMap.org"}));
        ds.add(new S57dat.Fparams(S57dat.S57field.DSSI, new Object[]{2, 1, 2, metas, 0, geos, 0, isols, conns, edges, 0}));
        ArrayList<S57dat.Fparams> dp = new ArrayList<S57dat.Fparams>();
        dp.add(new S57dat.Fparams(S57dat.S57field.DSPM, new Object[]{20, 2, 2, vdat, vdat, cscl, duni, huni, 1, 1, 10000000, 10, ""}));
        System.arraycopy(header, 0, buf, 0, header.length);
        idx = header.length;
        byte[] record = S57dat.encRecord(1, ds);
        System.arraycopy(record, 0, buf, idx, record.length);
        idx += record.length;
        record = S57dat.encRecord(2, dp);
        System.arraycopy(record, 0, buf, idx, record.length);
        idx += record.length;
        recs = 3;
        Object[] depths = new Object[]{};
        for (Map.Entry entry : map.nodes.entrySet()) {
            node = (S57map.Snode)entry.getValue();
            if (node.flg != S57map.Nflag.DPTH) continue;
            Object[] dval = new Object[]{Math.toDegrees(node.lat) * 1.0E7, Math.toDegrees(node.lon) * 1.0E7, node.val * 10.0};
            depths = Arrays.copyOf(depths, depths.length + dval.length);
            System.arraycopy(dval, 0, depths, depths.length - dval.length, dval.length);
        }
        if (depths.length > 0) {
            fields = new ArrayList<S57dat.Fparams>();
            fields.add(new S57dat.Fparams(S57dat.S57field.VRID, new Object[]{110, -2, 1, 1}));
            fields.add(new S57dat.Fparams(S57dat.S57field.SG3D, depths));
            record = S57dat.encRecord(recs++, fields);
            System.arraycopy(record, 0, buf, idx, record.length);
            idx += record.length;
            ++isols;
        }
        for (Map.Entry entry : map.nodes.entrySet()) {
            node = (S57map.Snode)entry.getValue();
            if (node.flg != S57map.Nflag.ISOL) continue;
            fields = new ArrayList();
            fields.add(new S57dat.Fparams(S57dat.S57field.VRID, new Object[]{110, S57enc.hash((Long)entry.getKey()), 1, 1}));
            fields.add(new S57dat.Fparams(S57dat.S57field.SG2D, new Object[]{Math.toDegrees(node.lat) * 1.0E7, Math.toDegrees(node.lon) * 1.0E7}));
            record = S57dat.encRecord(recs++, fields);
            System.arraycopy(record, 0, buf, idx, record.length);
            idx += record.length;
            ++isols;
        }
        for (Map.Entry entry : map.nodes.entrySet()) {
            node = (S57map.Snode)entry.getValue();
            if (node.flg != S57map.Nflag.CONN) continue;
            fields = new ArrayList();
            fields.add(new S57dat.Fparams(S57dat.S57field.VRID, new Object[]{120, S57enc.hash((Long)entry.getKey()), 1, 1}));
            fields.add(new S57dat.Fparams(S57dat.S57field.SG2D, new Object[]{Math.toDegrees(node.lat) * 1.0E7, Math.toDegrees(node.lon) * 1.0E7}));
            record = S57dat.encRecord(recs++, fields);
            System.arraycopy(record, 0, buf, idx, record.length);
            idx += record.length;
            ++conns;
        }
        for (Map.Entry entry : map.edges.entrySet()) {
            S57map.Edge edge = (S57map.Edge)entry.getValue();
            fields = new ArrayList();
            fields.add(new S57dat.Fparams(S57dat.S57field.VRID, new Object[]{130, S57enc.hash((Long)entry.getKey()), 1, 1}));
            fields.add(new S57dat.Fparams(S57dat.S57field.VRPT, new Object[]{((S57enc.hash(edge.first) & 0xFFFFFFFFFFFFFFFFL) << 8) + 120L, 255, 255, 1, 255, ((S57enc.hash(edge.last) & 0xFFFFFFFFFFFFFFFFL) << 8) + 120L, 255, 255, 2, 255}));
            Object[] nodes = new Object[]{};
            Iterator<Object> i$ = edge.nodes.iterator();
            while (i$.hasNext()) {
                long ref = (Long)i$.next();
                Object[] nval = new Object[]{Math.toDegrees(((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)ref))).lat) * 1.0E7, Math.toDegrees(((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)ref))).lon) * 1.0E7};
                nodes = Arrays.copyOf(nodes, nodes.length + nval.length);
                System.arraycopy(nval, 0, nodes, nodes.length - nval.length, nval.length);
            }
            if (nodes.length > 0) {
                fields.add(new S57dat.Fparams(S57dat.S57field.SG2D, nodes));
            }
            record = S57dat.encRecord(recs++, fields);
            System.arraycopy(record, 0, buf, idx, record.length);
            idx += record.length;
            ++edges;
        }
        boolean soundings = false;
        for (Map.Entry entry : map.features.entrySet()) {
            S57obj.Obj obj = (S57obj.Obj)((Object)entry.getKey());
            for (S57map.Feature feature : (ArrayList)entry.getValue()) {
                int prim;
                if (obj == S57obj.Obj.SOUNDG) {
                    if (soundings) continue;
                    soundings = true;
                }
                prim = (prim = feature.geom.prim.ordinal()) == 0 ? 255 : prim;
                int grup = obj == S57obj.Obj.DEPARE || obj == S57obj.Obj.DRGARE || obj == S57obj.Obj.FLODOC || obj == S57obj.Obj.HULKES || obj == S57obj.Obj.LNDARE || obj == S57obj.Obj.PONTON || obj == S57obj.Obj.UNSARE ? 1 : 2;
                ArrayList<S57dat.Fparams> geom = new ArrayList<S57dat.Fparams>();
                int outers = 0;
                outers = feature.geom.prim == S57map.Pflag.POINT ? 1 : feature.geom.comps.get((int)0).size;
                for (S57map.Prim elem : feature.geom.elems) {
                    if (feature.geom.prim == S57map.Pflag.POINT) {
                        if (obj == S57obj.Obj.SOUNDG) {
                            geom.add(new S57dat.Fparams(S57dat.S57field.FSPT, new Object[]{-402L, 255, 255, 255}));
                            continue;
                        }
                        geom.add(new S57dat.Fparams(S57dat.S57field.FSPT, new Object[]{(S57enc.hash(elem.id) << 8) + (((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)elem.id))).flg == S57map.Nflag.CONN ? 120L : 110L), 255, 255, 255}));
                        continue;
                    }
                    geom.add(new S57dat.Fparams(S57dat.S57field.FSPT, new Object[]{(S57enc.hash(elem.id) << 8) + 130L, elem.forward ? 1 : 2, outers-- > 0 ? 1 : 2, 2}));
                }
                ArrayList objects = new ArrayList();
                ArrayList<Long> slaves = new ArrayList<Long>();
                long slaveid = feature.id + 0x100000000000000L;
                for (Map.Entry entry2 : feature.objs.entrySet()) {
                    S57obj.Obj objobj = (S57obj.Obj)((Object)entry2.getKey());
                    boolean master = true;
                    for (Map.Entry object : ((S57map.ObjTab)entry2.getValue()).entrySet()) {
                        ArrayList<S57dat.Fparams> objatts = new ArrayList<S57dat.Fparams>();
                        master = feature.type == objobj && ((Integer)object.getKey() == 0 || (Integer)object.getKey() == 1);
                        long id = S57enc.hash(master ? feature.id : slaveid);
                        objatts.add(new S57dat.Fparams(S57dat.S57field.FRID, new Object[]{100, id, prim, grup, S57obj.encodeType(objobj), 1, 1}));
                        objatts.add(new S57dat.Fparams(S57dat.S57field.FOID, new Object[]{agen, id, 1}));
                        Object[] attf = new Object[]{};
                        Object[] natf = new Object[]{};
                        S57map.AttMap atts = new S57map.AttMap(map);
                        atts.putAll((Map)object.getValue());
                        if (master) {
                            atts.putAll(feature.atts);
                        }
                        for (Map.Entry att : atts.entrySet()) {
                            if (obj == S57obj.Obj.SOUNDG && att.getKey() == S57att.Att.VALSOU) continue;
                            long attl = S57att.encodeAttribute((S57att.Att)((Object)att.getKey())).intValue();
                            Object[] next = new Object[]{attl, S57val.encodeValue((S57val.AttVal)att.getValue(), (S57att.Att)((Object)att.getKey()))};
                            if (attl < 300L || attl > 304L) {
                                attf = Arrays.copyOf(attf, attf.length + next.length);
                                System.arraycopy(next, 0, attf, attf.length - next.length, next.length);
                                continue;
                            }
                            natf = Arrays.copyOf(natf, natf.length + next.length);
                            System.arraycopy(next, 0, natf, natf.length - next.length, next.length);
                        }
                        if (attf.length > 0) {
                            objatts.add(new S57dat.Fparams(S57dat.S57field.ATTF, attf));
                        }
                        if (natf.length > 0) {
                            objatts.add(new S57dat.Fparams(S57dat.S57field.NATF, attf));
                        }
                        if (master) {
                            objects.add(objatts);
                            continue;
                        }
                        slaves.add(id);
                        objects.add(0, objatts);
                        slaveid += 0x100000000000000L;
                    }
                }
                if (!slaves.isEmpty()) {
                    void var24_31;
                    ArrayList<S57dat.Fparams> refs = new ArrayList<S57dat.Fparams>();
                    Object[] objectArray = new Object[]{};
                    while (!slaves.isEmpty()) {
                        long id = (Long)slaves.remove(0);
                        Object[] next = new Object[]{((id & 0xFFFFFFFFFFFFFFFFL) + 0x100000000L << 16) + (long)(agen & 0xFFFF), 2, ""};
                        T[] TArray = Arrays.copyOf(var24_31, ((void)var24_31).length + next.length);
                        System.arraycopy(next, 0, TArray, TArray.length - next.length, next.length);
                    }
                    refs.add(new S57dat.Fparams(S57dat.S57field.FFPT, (Object[])var24_31));
                    ((ArrayList)objects.get(objects.size() - 1)).addAll(refs);
                }
                for (ArrayList arrayList : objects) {
                    arrayList.addAll(geom);
                    record = S57dat.encRecord(recs++, (ArrayList<S57dat.Fparams>)arrayList);
                    System.arraycopy(record, 0, buf, idx, record.length);
                    idx += record.length;
                    if (obj == S57obj.Obj.M_COVR || obj == S57obj.Obj.M_NSYS) {
                        ++metas;
                        continue;
                    }
                    ++geos;
                }
            }
        }
        ds = new ArrayList();
        ds.add(new S57dat.Fparams(S57dat.S57field.DSID, new Object[]{10, 1, 1, intu, file, "1", "0", date, date, "03.1", 1, "ENC", "2.0", 1, agen, "Generated by OpenSeaMap.org"}));
        ds.add(new S57dat.Fparams(S57dat.S57field.DSSI, new Object[]{2, 1, 2, metas, 0, geos, 0, isols, conns, edges, 0}));
        record = S57dat.encRecord(1, ds);
        System.arraycopy(record, 0, buf, header.length, record.length);
        return idx;
    }
}

