/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.routes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.routes.RouteLayer;
import org.openstreetmap.josm.plugins.routes.xml.Routes;
import org.openstreetmap.josm.plugins.routes.xml.RoutesXMLLayer;

public class RoutesPlugin
extends Plugin
implements LayerManager.LayerChangeListener {
    private final List<RouteLayer> routeLayers = new ArrayList<RouteLayer>();
    private boolean isShown;

    public RoutesPlugin(PluginInformation info) {
        super(info);
        Main.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
        File routesFile = new File(this.getPluginDir() + File.separator + "routes.xml");
        if (!routesFile.exists()) {
            Main.info((String)"File with route definitions doesn't exist, using default");
            try {
                routesFile.getParentFile().mkdir();
                try (FileOutputStream outputStream = new FileOutputStream(routesFile);
                     InputStream inputStream = Routes.class.getResourceAsStream("routes.xml");){
                    int read;
                    byte[] b = new byte[512];
                    while ((read = inputStream.read(b)) != -1) {
                        ((OutputStream)outputStream).write(b, 0, read);
                    }
                }
            }
            catch (IOException e) {
                Main.error((Throwable)e);
            }
        }
        try {
            JAXBContext context = JAXBContext.newInstance((String)Routes.class.getPackage().getName(), (ClassLoader)Routes.class.getClassLoader());
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Routes routes = (Routes)unmarshaller.unmarshal((InputStream)new FileInputStream(this.getPluginDir() + File.separator + "routes.xml"));
            for (RoutesXMLLayer layer : routes.getLayer()) {
                if (!layer.isEnabled()) continue;
                this.routeLayers.add(new RouteLayer(layer));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    private void checkLayers() {
        if (Main.map != null && Main.map.mapView != null) {
            for (Layer layer : Main.getLayerManager().getLayers()) {
                if (!(layer instanceof OsmDataLayer)) continue;
                if (!this.isShown) {
                    this.isShown = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (RouteLayer routeLayer : RoutesPlugin.this.routeLayers) {
                                Main.getLayerManager().addLayer((Layer)routeLayer);
                            }
                        }
                    });
                }
                return;
            }
            if (this.isShown) {
                this.isShown = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (RouteLayer routeLayer : RoutesPlugin.this.routeLayers) {
                            Main.getLayerManager().removeLayer((Layer)routeLayer);
                        }
                    }
                });
            }
        }
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
        this.checkLayers();
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        this.checkLayers();
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }
}

