/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.plugin.preferences;

import java.awt.Color;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessParameters;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessType;
import org.openstreetmap.josm.plugins.graphview.core.property.VehiclePropertyType;
import org.openstreetmap.josm.plugins.graphview.core.property.VehiclePropertyTypes;
import org.openstreetmap.josm.plugins.graphview.core.visualisation.ColorScheme;
import org.openstreetmap.josm.plugins.graphview.plugin.layer.PreferencesColorScheme;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.GraphViewPreferenceDefaults;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.InternalRuleset;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.PreferenceAccessParameters;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.VehiclePropertyStringParser;
import org.openstreetmap.josm.tools.I18n;

public final class GraphViewPreferences
extends Observable {
    private static GraphViewPreferences instance;
    private boolean useInternalRulesets;
    private File rulesetFolder;
    private File currentRulesetFile;
    private InternalRuleset currentInternalRuleset;
    private String currentParameterBookmarkName;
    private Map<String, PreferenceAccessParameters> parameterBookmarks;
    private ColorScheme currentColorScheme;
    private Color nodeColor;
    private Color segmentColor;
    private Color arrowheadFillColor;
    private boolean separateDirections;
    private double arrowheadPlacement;
    private static final Pattern ACCESS_PARAM_PATTERN;
    private static final Pattern PROPERTY_MAP_ENTRY_PATTERN;
    private static final Map<VehiclePropertyType<?>, String> VEHICLE_PROPERTY_TYPE_NAME_MAP;

    public static GraphViewPreferences getInstance() {
        if (instance == null) {
            instance = new GraphViewPreferences();
        }
        return instance;
    }

    public synchronized boolean getUseInternalRulesets() {
        return this.useInternalRulesets;
    }

    public synchronized void setUseInternalRulesets(boolean useInternalRulesets) {
        this.useInternalRulesets = useInternalRulesets;
    }

    public synchronized File getRulesetFolder() {
        return this.rulesetFolder;
    }

    public synchronized void setRulesetFolder(File rulesetFolder) {
        this.rulesetFolder = rulesetFolder;
    }

    public synchronized File getCurrentRulesetFile() {
        return this.currentRulesetFile;
    }

    public synchronized void setCurrentRulesetFile(File currentRulesetFile) {
        this.currentRulesetFile = currentRulesetFile;
    }

    public synchronized InternalRuleset getCurrentInternalRuleset() {
        return this.currentInternalRuleset;
    }

    public synchronized void setCurrentInternalRuleset(InternalRuleset internalRuleset) {
        this.currentInternalRuleset = internalRuleset;
    }

    public synchronized String getCurrentParameterBookmarkName() {
        assert (this.parameterBookmarks.containsKey(this.currentParameterBookmarkName));
        return this.currentParameterBookmarkName;
    }

    public synchronized AccessParameters getCurrentParameterBookmark() {
        if (this.currentParameterBookmarkName == null) {
            return null;
        }
        assert (this.parameterBookmarks.containsKey(this.currentParameterBookmarkName));
        return this.parameterBookmarks.get(this.currentParameterBookmarkName);
    }

    public synchronized void setCurrentParameterBookmarkName(String parameterBookmarkName) {
        assert (this.parameterBookmarks.containsKey(parameterBookmarkName));
        this.currentParameterBookmarkName = parameterBookmarkName;
    }

    public synchronized Map<String, PreferenceAccessParameters> getParameterBookmarks() {
        return Collections.unmodifiableMap(this.parameterBookmarks);
    }

    public synchronized void setParameterBookmarks(Map<String, PreferenceAccessParameters> parameterBookmarks) {
        assert (parameterBookmarks != null);
        this.parameterBookmarks = new HashMap<String, PreferenceAccessParameters>(parameterBookmarks);
    }

    public synchronized ColorScheme getCurrentColorScheme() {
        return this.currentColorScheme;
    }

    public synchronized void setCurrentColorScheme(ColorScheme currentColorScheme) {
        this.currentColorScheme = currentColorScheme;
    }

    public synchronized Color getNodeColor() {
        return this.nodeColor;
    }

    public synchronized void setNodeColor(Color nodeColor) {
        this.nodeColor = nodeColor;
    }

    public synchronized Color getSegmentColor() {
        return this.segmentColor;
    }

    public synchronized void setSegmentColor(Color segmentColor) {
        this.segmentColor = segmentColor;
    }

    public synchronized Color getArrowheadFillColor() {
        return this.arrowheadFillColor;
    }

    public synchronized void setArrowheadFillColor(Color arrowheadFillColor) {
        this.arrowheadFillColor = arrowheadFillColor;
    }

    public synchronized boolean getSeparateDirections() {
        return this.separateDirections;
    }

    public synchronized void setSeparateDirections(boolean separateDirections) {
        this.separateDirections = separateDirections;
    }

    public synchronized double getArrowheadPlacement() {
        return this.arrowheadPlacement;
    }

    public synchronized void setArrowheadPlacement(double arrowheadPlacement) {
        this.arrowheadPlacement = arrowheadPlacement;
    }

    public void distributeChanges() {
        this.writePreferences();
        this.setChanged();
        this.notifyObservers();
    }

    private GraphViewPreferences() {
        this.fillDefaults();
        this.readPreferences();
        this.writePreferences();
    }

    private void fillDefaults() {
        this.parameterBookmarks = GraphViewPreferenceDefaults.createDefaultAccessParameterBookmarks();
        this.currentParameterBookmarkName = this.parameterBookmarks.size() > 0 ? this.parameterBookmarks.keySet().iterator().next() : null;
        this.useInternalRulesets = true;
        this.rulesetFolder = GraphViewPreferenceDefaults.getDefaultRulesetFolder();
        this.currentRulesetFile = null;
        this.currentInternalRuleset = null;
        this.currentColorScheme = new PreferencesColorScheme(this);
        this.separateDirections = false;
    }

    private void writePreferences() {
        Main.pref.put("graphview.parameterBookmarks", GraphViewPreferences.createAccessParameterBookmarksString(this.parameterBookmarks));
        if (this.currentParameterBookmarkName != null) {
            Main.pref.put("graphview.activeBookmark", this.currentParameterBookmarkName);
        }
        Main.pref.put("graphview.useInternalRulesets", this.useInternalRulesets);
        Main.pref.put("graphview.rulesetFolder", this.rulesetFolder.getPath());
        if (this.currentRulesetFile != null) {
            Main.pref.put("graphview.rulesetFile", this.currentRulesetFile.getPath());
        }
        if (this.currentInternalRuleset != null) {
            Main.pref.put("graphview.rulesetResource", this.currentInternalRuleset.toString());
        }
        Main.pref.putColor(I18n.marktr((String)"graphview default node"), Color.WHITE);
        Main.pref.putColor(I18n.marktr((String)"graphview default segment"), Color.WHITE);
        Main.pref.putColor(I18n.marktr((String)"graphview arrowhead core"), Color.BLACK);
        Main.pref.put("graphview.separateDirections", this.separateDirections);
        Main.pref.putDouble("graphview.arrowheadPlacement", Double.valueOf(this.arrowheadPlacement));
    }

    private void readPreferences() {
        if (!Main.pref.get("graphview.parameterBookmarks").isEmpty()) {
            String bookmarksString = Main.pref.get("graphview.parameterBookmarks");
            this.parameterBookmarks = GraphViewPreferences.parseAccessParameterBookmarksString(bookmarksString);
        }
        if (!Main.pref.get("graphview.activeBookmark").isEmpty()) {
            this.currentParameterBookmarkName = Main.pref.get("graphview.activeBookmark");
        }
        if (!this.parameterBookmarks.containsKey(this.currentParameterBookmarkName)) {
            this.currentParameterBookmarkName = null;
        }
        this.useInternalRulesets = Main.pref.getBoolean("graphview.useInternalRulesets", true);
        if (!Main.pref.get("graphview.rulesetFolder").isEmpty()) {
            String dirString = Main.pref.get("graphview.rulesetFolder");
            this.rulesetFolder = new File(dirString);
        }
        if (!Main.pref.get("graphview.rulesetFile").isEmpty()) {
            String fileString = Main.pref.get("graphview.rulesetFile");
            this.currentRulesetFile = new File(fileString);
        }
        if (!Main.pref.get("graphview.rulesetResource").isEmpty()) {
            String rulesetString = Main.pref.get("graphview.rulesetResource");
            for (InternalRuleset ruleset : InternalRuleset.values()) {
                if (!ruleset.toString().equals(rulesetString)) continue;
                this.currentInternalRuleset = ruleset;
                break;
            }
        }
        this.nodeColor = Main.pref.getColor(I18n.marktr((String)"graphview default node"), Color.WHITE);
        this.segmentColor = Main.pref.getColor(I18n.marktr((String)"graphview default segment"), Color.WHITE);
        this.arrowheadFillColor = Main.pref.getColor(I18n.marktr((String)"graphview arrowhead core"), Color.BLACK);
        this.separateDirections = Main.pref.getBoolean("graphview.separateDirections", false);
        this.arrowheadPlacement = Main.pref.getDouble("graphview.arrowheadPlacement", 1.0);
        if (this.arrowheadPlacement < 0.0 || this.arrowheadPlacement >= 1.0) {
            this.arrowheadPlacement = 1.0;
        }
    }

    private static String createAccessParameterBookmarksString(Map<String, PreferenceAccessParameters> parameterBookmarks) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean firstEntry = true;
        for (String bookmarkName : parameterBookmarks.keySet()) {
            if (!firstEntry) {
                stringBuilder.append("|");
            } else {
                firstEntry = false;
            }
            stringBuilder.append(GraphViewPreferences.createAccessParameterBookmarkString(bookmarkName, parameterBookmarks.get(bookmarkName)));
        }
        return stringBuilder.toString();
    }

    private static String createAccessParameterBookmarkString(String bookmarkName, PreferenceAccessParameters parameters) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(bookmarkName).append(";");
        stringBuilder.append(parameters.getAccessClass());
        stringBuilder.append(";types={");
        for (AccessType accessType : AccessType.values()) {
            if (!parameters.getAccessTypeUsable(accessType)) continue;
            stringBuilder.append((Object)accessType).append(",");
        }
        if (stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append("}");
        stringBuilder.append(";properties={");
        for (VehiclePropertyType<?> vehiclePropertyType : VEHICLE_PROPERTY_TYPE_NAME_MAP.keySet()) {
            String propertyString = parameters.getVehiclePropertyString(vehiclePropertyType);
            if (propertyString == null) continue;
            stringBuilder.append(VEHICLE_PROPERTY_TYPE_NAME_MAP.get(vehiclePropertyType));
            stringBuilder.append("=");
            stringBuilder.append(propertyString);
            stringBuilder.append(",");
        }
        if (stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append("}");
        assert (ACCESS_PARAM_PATTERN.matcher(stringBuilder.toString()).matches());
        return stringBuilder.toString();
    }

    private static Map<String, PreferenceAccessParameters> parseAccessParameterBookmarksString(String string) {
        String[] bookmarkStrings;
        HashMap<String, PreferenceAccessParameters> resultMap = new HashMap<String, PreferenceAccessParameters>();
        for (String bookmarkString : bookmarkStrings = string.split("\\|")) {
            GraphViewPreferences.parseAccessParameterBookmarkString(bookmarkString, resultMap);
        }
        return resultMap;
    }

    private static void parseAccessParameterBookmarkString(String bookmarkString, Map<String, PreferenceAccessParameters> resultMap) {
        Matcher matcher = ACCESS_PARAM_PATTERN.matcher(bookmarkString);
        if (matcher.matches()) {
            String bookmarkName = matcher.group(1);
            String accessClass = matcher.group(2);
            String[] accessTypeStrings = matcher.group(3).split(",");
            LinkedList<AccessType> accessTypes = new LinkedList<AccessType>();
            for (String accessTypeString : accessTypeStrings) {
                AccessType accessType = AccessType.valueOf(accessTypeString);
                if (accessType == null) continue;
                accessTypes.add(accessType);
            }
            String[] vehiclePropertyStrings = matcher.group(4).split(",");
            HashMap vehiclePropertyMap = new HashMap();
            for (String vehiclePropertyString : vehiclePropertyStrings) {
                Matcher entryMatcher = PROPERTY_MAP_ENTRY_PATTERN.matcher(vehiclePropertyString);
                if (!entryMatcher.matches()) continue;
                String propertyTypeString = entryMatcher.group(1);
                String propertyValueString = entryMatcher.group(2);
                for (VehiclePropertyType<?> propertyType : VEHICLE_PROPERTY_TYPE_NAME_MAP.keySet()) {
                    if (!propertyTypeString.equals(VEHICLE_PROPERTY_TYPE_NAME_MAP.get(propertyType))) continue;
                    vehiclePropertyMap.put(propertyType, propertyValueString);
                }
            }
            try {
                PreferenceAccessParameters accessParameters = new PreferenceAccessParameters(accessClass, accessTypes, vehiclePropertyMap);
                resultMap.put(bookmarkName, accessParameters);
            }
            catch (VehiclePropertyStringParser.PropertyValueSyntaxException propertyValueSyntaxException) {
                // empty catch block
            }
        }
    }

    static {
        ACCESS_PARAM_PATTERN = Pattern.compile("^([^;]*);([^;]*);types=\\{([^\\}]*)\\};properties=\\{([^\\}]*)\\}$");
        PROPERTY_MAP_ENTRY_PATTERN = Pattern.compile("^([^=]*)=(.*)$");
        VEHICLE_PROPERTY_TYPE_NAME_MAP = new HashMap();
        VEHICLE_PROPERTY_TYPE_NAME_MAP.put(VehiclePropertyTypes.AXLELOAD, "AXLELOAD");
        VEHICLE_PROPERTY_TYPE_NAME_MAP.put(VehiclePropertyTypes.HEIGHT, "HEIGHT");
        VEHICLE_PROPERTY_TYPE_NAME_MAP.put(VehiclePropertyTypes.LENGTH, "LENGTH");
        VEHICLE_PROPERTY_TYPE_NAME_MAP.put(VehiclePropertyTypes.MAX_INCLINE_DOWN, "MAX_INCLINE_DOWN");
        VEHICLE_PROPERTY_TYPE_NAME_MAP.put(VehiclePropertyTypes.MAX_INCLINE_UP, "MAX_INCLINE_UP");
        VEHICLE_PROPERTY_TYPE_NAME_MAP.put(VehiclePropertyTypes.MAX_TRACKTYPE, "MAX_TRACKTYPE");
        VEHICLE_PROPERTY_TYPE_NAME_MAP.put(VehiclePropertyTypes.SPEED, "SPEED");
        VEHICLE_PROPERTY_TYPE_NAME_MAP.put(VehiclePropertyTypes.SURFACE_BLACKLIST, "SURFACE_BLACKLIST");
        VEHICLE_PROPERTY_TYPE_NAME_MAP.put(VehiclePropertyTypes.WEIGHT, "WEIGHT");
        VEHICLE_PROPERTY_TYPE_NAME_MAP.put(VehiclePropertyTypes.WIDTH, "WIDTH");
    }
}

