/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.hot.sds;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.openstreetmap.hot.sds.SdsApi;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class SdsPluginPreferences
extends DefaultTabPreferenceSetting {
    static final String SDS_SERVER = "sds-server.url";
    static final String SDS_USERNAME = "sds-server.username";
    static final String SDS_PASSWORD = "sds-server.password";
    static final String SDS_PREFIX = "sds-server.tag-prefix";
    private final JTextField server = new JTextField(8);
    private final JTextField username = new JTextField(8);
    private final JPasswordField password = new JPasswordField(8);
    private final JTextField prefix = new JTextField(8);

    public SdsPluginPreferences() {
        super("sds", I18n.tr((String)"Separate Data Store", (Object[])new Object[0]), I18n.tr((String)"Configures access to the Separate Data Store.", (Object[])new Object[0]));
    }

    public void addGui(PreferenceTabbedPane gui) {
        PreferenceTabbedPane.PreferencePanel tab = gui.createPreferenceTab((TabPreferenceSetting)this);
        JPanel access = new JPanel(new GridBagLayout());
        access.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Server", (Object[])new Object[0])));
        this.server.setText(Main.pref.get(SDS_SERVER, "http://datastore.hotosm.org"));
        this.username.setText(Main.pref.get(SDS_USERNAME, ""));
        this.password.setText(Main.pref.get(SDS_PASSWORD, ""));
        this.prefix.setText(Main.pref.get(SDS_PREFIX, "hot:"));
        this.server.setToolTipText(I18n.tr((String)"The URL under which the SDS server can be contacted.", (Object[])new Object[0]));
        this.username.setToolTipText(I18n.tr((String)"The user name at the SDS server. You need to create an account with the SDS admin first.", (Object[])new Object[0]));
        this.password.setToolTipText(I18n.tr((String)"The password at the SDS server. You need to create an account with the SDS admin first.", (Object[])new Object[0]));
        this.prefix.setToolTipText(I18n.tr((String)"Tags beginning with this prefix are never saved to OSM, but to the SDS server only.", (Object[])new Object[0]));
        access.add((Component)new JLabel(I18n.tr((String)"SDS server URL", (Object[])new Object[0])), GBC.std());
        access.add((Component)this.server, GBC.eol().fill(2).insets(5, 0, 0, 5));
        access.add((Component)new JLabel(I18n.tr((String)"SDS username", (Object[])new Object[0])), GBC.std());
        access.add((Component)this.username, GBC.eol().fill(2).insets(5, 0, 0, 5));
        access.add((Component)new JLabel(I18n.tr((String)"SDS password", (Object[])new Object[0])), GBC.std());
        access.add((Component)this.password, GBC.eol().fill(2).insets(5, 0, 0, 5));
        JButton test = new JButton(I18n.tr((String)"Test credentials now", (Object[])new Object[0]));
        access.add((Component)test, GBC.eol().anchor(13).insets(5, 0, 0, 5));
        tab.add((Component)access, GBC.eol().fill(2));
        tab.add((Component)new JLabel(I18n.tr((String)"SDS tag prefix", (Object[])new Object[0])), GBC.std());
        tab.add((Component)this.prefix, GBC.eol().fill(2).insets(5, 0, 0, 5));
        tab.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        test.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SdsApi api = new SdsApi(SdsPluginPreferences.this.server.getText());
                String olduser = Main.pref.get(SdsPluginPreferences.SDS_USERNAME);
                String oldpass = Main.pref.get(SdsPluginPreferences.SDS_PASSWORD);
                Main.pref.put(SdsPluginPreferences.SDS_USERNAME, SdsPluginPreferences.this.username.getText());
                Main.pref.put(SdsPluginPreferences.SDS_PASSWORD, new String(SdsPluginPreferences.this.password.getPassword()));
                try {
                    api.requestShadowsFromSds(Collections.singletonList(new Long(1L)), null, null, null);
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Connection successful.", (Object[])new Object[0]), I18n.tr((String)"Success", (Object[])new Object[0]), -1);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Cannot connect to SDS server: ", (Object[])new Object[0]) + ex.getMessage(), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
                }
                Main.pref.put(SdsPluginPreferences.SDS_USERNAME, olduser);
                Main.pref.put(SdsPluginPreferences.SDS_PASSWORD, oldpass);
            }
        });
    }

    public boolean ok() {
        Main.pref.put(SDS_SERVER, this.server.getText());
        Main.pref.put(SDS_USERNAME, this.username.getText());
        Main.pref.put(SDS_PASSWORD, new String(this.password.getPassword()));
        Main.pref.put(SDS_PREFIX, this.prefix.getText());
        return false;
    }
}

