/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.hot.sds;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.openstreetmap.hot.sds.SdsConnection;
import org.openstreetmap.hot.sds.SdsTransferException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class SdsApi
extends SdsConnection {
    public static final int DEFAULT_MAX_NUM_RETRIES = 5;
    private static HashMap<String, SdsApi> instances = new HashMap();
    private String serverUrl;
    private String version = null;

    public static SdsApi getSdsApi(String serverUrl) {
        SdsApi api = instances.get(serverUrl);
        if (api == null) {
            api = new SdsApi(serverUrl);
            instances.put(serverUrl, api);
        }
        return api;
    }

    public static SdsApi getSdsApi() {
        String serverUrl = Main.pref.get("sds-server.url", "http://datastore.hotosm.org");
        if (serverUrl == null) {
            throw new IllegalStateException(I18n.tr((String)"Preference ''{0}'' missing. Cannot initialize SdsApi.", (Object[])new Object[]{"sds-server.url"}));
        }
        return SdsApi.getSdsApi(serverUrl);
    }

    protected SdsApi(String serverUrl) {
        CheckParameterUtil.ensureParameterNotNull((Object)serverUrl, (String)"serverUrl");
        this.serverUrl = serverUrl;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBaseUrl() {
        int p;
        StringBuffer rv = new StringBuffer(this.serverUrl);
        if (this.version != null) {
            rv.append("/");
            rv.append(this.version);
        }
        rv.append("/");
        while ((p = rv.indexOf("//", 6)) > -1) {
            rv.delete(p, p + 1);
        }
        return rv.toString();
    }

    public String requestShadowsFromSds(List<Long> nodes, List<Long> ways, List<Long> relations, ProgressMonitor pm) throws SdsTransferException {
        StringBuilder request = new StringBuilder();
        String delim = "";
        String comma = "";
        if (nodes != null && !nodes.isEmpty()) {
            request.append(delim);
            delim = "&";
            comma = "";
            request.append("nodes=");
            for (long i : nodes) {
                request.append(comma);
                comma = ",";
                request.append(i);
            }
        }
        if (ways != null && !ways.isEmpty()) {
            request.append(delim);
            delim = "&";
            comma = "";
            request.append("ways=");
            for (long i : ways) {
                request.append(comma);
                comma = ",";
                request.append(i);
            }
        }
        if (relations != null && !relations.isEmpty()) {
            request.append(delim);
            delim = "&";
            comma = "";
            request.append("relations=");
            for (long i : relations) {
                request.append(comma);
                comma = ",";
                request.append(i);
            }
        }
        return this.sendRequest("POST", "collectshadows", request.toString(), pm, true);
    }

    private void sleepAndListen(int retry, ProgressMonitor monitor) throws SdsTransferException {
        System.out.print(I18n.tr((String)"Waiting 10 seconds ... ", (Object[])new Object[0]));
        for (int i = 0; i < 10; ++i) {
            if (monitor != null) {
                monitor.setCustomText(I18n.tr((String)"Starting retry {0} of {1} in {2} seconds ...", (Object[])new Object[]{this.getMaxRetries() - retry, this.getMaxRetries(), 10 - i}));
            }
            if (this.cancel) {
                throw new SdsTransferException();
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.out.println(I18n.tr((String)"OK - trying again.", (Object[])new Object[0]));
    }

    protected int getMaxRetries() {
        int ret = Main.pref.getInteger("osm-server.max-num-retries", 5);
        return Math.max(ret, 0);
    }

    private String sendRequest(String requestMethod, String urlSuffix, String requestBody, ProgressMonitor monitor) throws SdsTransferException {
        return this.sendRequest(requestMethod, urlSuffix, requestBody, monitor, true, false);
    }

    private String sendRequest(String requestMethod, String urlSuffix, String requestBody, ProgressMonitor monitor, boolean doAuth) throws SdsTransferException {
        return this.sendRequest(requestMethod, urlSuffix, requestBody, monitor, doAuth, false);
    }

    public boolean updateSds(String message, ProgressMonitor pm) {
        try {
            this.sendRequest("POST", "createshadows", message, pm);
        }
        catch (SdsTransferException e) {
            e.printStackTrace();
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private String sendRequest(String requestMethod, String urlSuffix, String requestBody, ProgressMonitor monitor, boolean doAuthenticate, boolean fastFail) throws SdsTransferException {
        StringBuffer responseBody = new StringBuffer();
        int retries = this.getMaxRetries();
        while (true) {
            try {
                int retCode;
                while (true) {
                    URL url = new URL(new URL(this.getBaseUrl()), urlSuffix);
                    System.out.print(requestMethod + " " + url + "... ");
                    this.activeConnection = (HttpURLConnection)url.openConnection();
                    this.activeConnection.setConnectTimeout(fastFail ? 1000 : Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
                    this.activeConnection.setRequestMethod(requestMethod);
                    if (doAuthenticate) {
                        this.addAuth(this.activeConnection);
                    }
                    if (requestMethod.equals("PUT") || requestMethod.equals("POST") || requestMethod.equals("DELETE")) {
                        this.activeConnection.setDoOutput(true);
                        this.activeConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                        try (OutputStream out = this.activeConnection.getOutputStream();){
                            if (requestBody != null) {
                                BufferedWriter bwr = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
                                bwr.write(requestBody);
                                bwr.flush();
                            }
                        }
                    }
                    this.activeConnection.connect();
                    System.out.println(this.activeConnection.getResponseMessage());
                    retCode = this.activeConnection.getResponseCode();
                    if (retCode < 500 || retries-- <= 0) break;
                    this.sleepAndListen(retries, monitor);
                    System.out.println(I18n.tr((String)"Starting retry {0} of {1}.", (Object[])new Object[]{this.getMaxRetries() - retries, this.getMaxRetries()}));
                }
                responseBody.setLength(0);
                InputStream i = null;
                try {
                    i = this.activeConnection.getInputStream();
                }
                catch (IOException ioe) {
                    i = this.activeConnection.getErrorStream();
                }
                if (i != null) {
                    String s;
                    BufferedReader in = new BufferedReader(new InputStreamReader(i));
                    while ((s = in.readLine()) != null) {
                        responseBody.append(s);
                        responseBody.append("\n");
                    }
                }
                String errorHeader = null;
                if (this.activeConnection.getHeaderField("Error") != null) {
                    errorHeader = this.activeConnection.getHeaderField("Error");
                    System.err.println("Error header: " + errorHeader);
                } else if (retCode != 200 && responseBody.length() > 0) {
                    System.err.println("Error body: " + responseBody);
                }
                this.activeConnection.disconnect();
                errorHeader = errorHeader == null ? null : errorHeader.trim();
                String errorBody = responseBody.length() == 0 ? null : responseBody.toString().trim();
                switch (retCode) {
                    case 200: {
                        return responseBody.toString();
                    }
                    case 403: {
                        throw new SdsTransferException("FORBIDDEN");
                    }
                }
                throw new SdsTransferException(errorHeader + errorBody);
            }
            catch (UnknownHostException e) {
                throw new SdsTransferException(e);
            }
            catch (SocketTimeoutException e) {
                if (retries-- <= 0) throw new SdsTransferException(e);
                continue;
            }
            catch (ConnectException e) {
                if (retries-- <= 0) throw new SdsTransferException(e);
                continue;
            }
            catch (IOException e) {
                throw new SdsTransferException(e);
            }
            break;
        }
        catch (SdsTransferException e) {
            throw e;
        }
    }

    protected InputStream getInputStream(String urlStr, ProgressMonitor progressMonitor) throws SdsTransferException {
        urlStr = this.getBaseUrl() + urlStr;
        try {
            URL url = null;
            try {
                url = new URL(urlStr.replace(" ", "%20"));
            }
            catch (MalformedURLException e) {
                throw new SdsTransferException(e);
            }
            try {
                this.activeConnection = (HttpURLConnection)url.openConnection();
            }
            catch (Exception e) {
                throw new SdsTransferException(I18n.tr((String)"Failed to open connection to API {0}.", (Object[])new Object[]{url.toExternalForm()}), e);
            }
            if (this.cancel) {
                this.activeConnection.disconnect();
                InputStream e = null;
                return e;
            }
            this.addAuth(this.activeConnection);
            if (this.cancel) {
                throw new SdsTransferException();
            }
            if (Main.pref.getBoolean("osm-server.use-compression", true)) {
                this.activeConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
            }
            this.activeConnection.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
            try {
                System.out.println("GET " + url);
                this.activeConnection.connect();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SdsTransferException(I18n.tr((String)"Could not connect to the OSM server. Please check your internet connection.", (Object[])new Object[0]), e);
            }
            try {
                if (this.activeConnection.getResponseCode() == 401) {
                    throw new OsmApiException(401, null, null);
                }
                if (this.activeConnection.getResponseCode() == 407) {
                    throw new OsmTransferCanceledException(I18n.tr((String)"Proxy Authentication Required", (Object[])new Object[0]));
                }
                String encoding = this.activeConnection.getContentEncoding();
                if (this.activeConnection.getResponseCode() != 200) {
                    String errorHeader = this.activeConnection.getHeaderField("Error");
                    StringBuilder errorBody = new StringBuilder();
                    try {
                        InputStream i = this.FixEncoding(this.activeConnection.getErrorStream(), encoding);
                        if (i != null) {
                            String s;
                            BufferedReader in = new BufferedReader(new InputStreamReader(i));
                            while ((s = in.readLine()) != null) {
                                errorBody.append(s);
                                errorBody.append("\n");
                            }
                        }
                    }
                    catch (Exception e) {
                        errorBody.append(I18n.tr((String)"Reading error text failed.", (Object[])new Object[0]));
                    }
                    throw new OsmApiException(this.activeConnection.getResponseCode(), errorHeader, errorBody.toString());
                }
                InputStream inputStream = this.FixEncoding((InputStream)new ProgressInputStream((URLConnection)this.activeConnection, progressMonitor), encoding);
                return inputStream;
            }
            catch (Exception e) {
                if (e instanceof SdsTransferException) {
                    throw (SdsTransferException)e;
                }
                throw new SdsTransferException(e);
            }
        }
        finally {
            progressMonitor.invalidate();
        }
    }

    private InputStream FixEncoding(InputStream stream, String encoding) throws IOException {
        if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
            stream = new GZIPInputStream(stream);
        } else if (encoding != null && encoding.equalsIgnoreCase("deflate")) {
            stream = new InflaterInputStream(stream, new Inflater(true));
        }
        return stream;
    }
}

