/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.io.download;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryFilterDialog;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryMainDialog;
import org.openstreetmap.josm.plugins.mapillary.io.download.MapillaryImageInfoDownloadThread;
import org.openstreetmap.josm.plugins.mapillary.io.download.MapillarySequenceDownloadThread;
import org.openstreetmap.josm.plugins.mapillary.io.download.MapillaryTrafficSignDownloadThread;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.plugins.mapillary.utils.PluginState;

public class MapillarySquareDownloadManagerThread
extends Thread {
    private final Bounds bounds;
    private final ThreadPoolExecutor downloadExecutor = new ThreadPoolExecutor(3, 5, 25L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));
    private final ThreadPoolExecutor completeExecutor = new ThreadPoolExecutor(3, 5, 25L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));
    private final ThreadPoolExecutor signsExecutor = new ThreadPoolExecutor(3, 5, 25L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));

    public MapillarySquareDownloadManagerThread(Bounds bounds) {
        this.bounds = bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            PluginState.startDownload();
            MapillaryUtils.updateHelpText();
            this.downloadSequences();
            this.completeImages();
            MapillaryMainDialog.getInstance().updateTitle();
            this.downloadSigns();
        }
        catch (InterruptedException e) {
            Main.error((String)"Mapillary download interrupted (probably because of closing the layer).");
        }
        finally {
            PluginState.finishDownload();
        }
        MapillaryUtils.updateHelpText();
        MapillaryData.dataUpdated();
        MapillaryFilterDialog.getInstance().refresh();
        MapillaryMainDialog.getInstance().updateImage();
    }

    private void downloadSequences() throws InterruptedException {
        int page = 0;
        while (!this.downloadExecutor.isShutdown()) {
            this.downloadExecutor.execute(new MapillarySequenceDownloadThread(this.downloadExecutor, this.bounds, page));
            while (this.downloadExecutor.getQueue().remainingCapacity() == 0) {
                Thread.sleep(500L);
            }
            ++page;
        }
        this.downloadExecutor.awaitTermination(15L, TimeUnit.SECONDS);
        MapillaryData.dataUpdated();
    }

    private void completeImages() throws InterruptedException {
        int page = 0;
        while (!this.completeExecutor.isShutdown()) {
            this.completeExecutor.execute(new MapillaryImageInfoDownloadThread(this.completeExecutor, this.bounds, page));
            while (this.completeExecutor.getQueue().remainingCapacity() == 0) {
                Thread.sleep(100L);
            }
            ++page;
        }
        this.completeExecutor.awaitTermination(15L, TimeUnit.SECONDS);
    }

    private void downloadSigns() throws InterruptedException {
        int page = 0;
        while (!this.signsExecutor.isShutdown()) {
            this.signsExecutor.execute(new MapillaryTrafficSignDownloadThread(this.signsExecutor, this.bounds, page));
            while (this.signsExecutor.getQueue().remainingCapacity() == 0) {
                Thread.sleep(100L);
            }
            ++page;
        }
        this.signsExecutor.awaitTermination(15L, TimeUnit.SECONDS);
    }

    @Override
    public void interrupt() {
        super.interrupt();
        this.downloadExecutor.shutdownNow();
        this.completeExecutor.shutdownNow();
        this.signsExecutor.shutdownNow();
        try {
            this.downloadExecutor.awaitTermination(15L, TimeUnit.SECONDS);
            this.completeExecutor.awaitTermination(15L, TimeUnit.SECONDS);
            this.signsExecutor.awaitTermination(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Main.error((Throwable)e);
        }
    }
}

