/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.history.commands;

import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.history.commands.MapillaryCommand;
import org.openstreetmap.josm.plugins.mapillary.history.commands.MapillaryExecutableCommand;
import org.openstreetmap.josm.tools.I18n;

public class CommandImport
extends MapillaryExecutableCommand {
    public CommandImport(Set<MapillaryAbstractImage> images) {
        super(images);
    }

    @Override
    public void execute() {
        MapillaryLayer.getInstance().getData().add(this.images);
    }

    @Override
    public void undo() {
        for (MapillaryAbstractImage img : this.images) {
            MapillaryLayer.getInstance().getData().getImages().remove(img);
        }
        if (Main.main != null) {
            MapillaryData.dataUpdated();
        }
    }

    @Override
    public void redo() {
        this.execute();
    }

    @Override
    public void sum(MapillaryCommand command) {
    }

    @Override
    public String toString() {
        return I18n.trn((String)"Imported {0} image", (String)"Imported {0} images", (long)this.images.size(), (Object[])new Object[]{this.images.size()});
    }
}

