/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.conflict.ConflictAddCommand;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import reverter.ChangesetReverter;
import reverter.RevertChangesetCommand;
import reverter.RevertRedactedChangesetException;

public class RevertChangesetTask
extends PleaseWaitRunnable {
    private final int changesetId;
    private final ChangesetReverter.RevertType revertType;
    private final boolean newLayer;
    private ChangesetReverter rev;
    private boolean downloadConfirmed;

    public RevertChangesetTask(int changesetId, ChangesetReverter.RevertType revertType) {
        this(changesetId, revertType, false);
    }

    public RevertChangesetTask(int changesetId, ChangesetReverter.RevertType revertType, boolean autoConfirmDownload) {
        this(changesetId, revertType, autoConfirmDownload, false);
    }

    public RevertChangesetTask(int changesetId, ChangesetReverter.RevertType revertType, boolean autoConfirmDownload, boolean newLayer) {
        super(I18n.tr((String)"Reverting...", (Object[])new Object[0]));
        this.changesetId = changesetId;
        this.revertType = revertType;
        this.downloadConfirmed = autoConfirmDownload;
        this.newLayer = newLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndDownloadMissing() throws OsmTransferException {
        if (!this.rev.hasMissingObjects()) {
            return true;
        }
        if (!this.downloadConfirmed) {
            Integer selectedOption = (Integer)GuiHelper.runInEDTAndWaitAndReturn((Callable)new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"This changeset has objects that are not present in current dataset.\nIt is needed to download them before reverting. Do you want to continue?", (Object[])new Object[0]), I18n.tr((String)"Confirm", (Object[])new Object[0]), 0);
                }
            });
            boolean bl = this.downloadConfirmed = selectedOption != null && selectedOption == 0;
            if (!this.downloadConfirmed) {
                return false;
            }
        }
        try (PleaseWaitProgressMonitor monitor = new PleaseWaitProgressMonitor(I18n.tr((String)"Fetching missing primitives", (Object[])new Object[0]));){
            this.rev.downloadMissingPrimitives((ProgressMonitor)monitor);
        }
        return !monitor.isCanceled();
    }

    protected void realRun() throws OsmTransferException {
        this.progressMonitor.indeterminateSubTask(I18n.tr((String)"Downloading changeset", (Object[])new Object[0]));
        try {
            this.rev = new ChangesetReverter(this.changesetId, this.revertType, this.newLayer, this.progressMonitor.createSubTaskMonitor(0, true));
        }
        catch (RevertRedactedChangesetException e) {
            GuiHelper.runInEDT((Runnable)new Runnable(){

                @Override
                public void run() {
                    new Notification(e.getMessage() + "<br>" + I18n.tr((String)"See {0}", (Object[])new Object[]{"<a href=\"https://www.openstreetmap.org/redactions\">https://www.openstreetmap.org/redactions</a>"})).setIcon(0).setDuration(Notification.TIME_LONG).show();
                }
            });
            this.progressMonitor.cancel();
        }
        if (this.progressMonitor.isCanceled()) {
            return;
        }
        this.rev.checkMissingCreated();
        this.rev.checkMissingUpdated();
        if (this.rev.hasMissingObjects()) {
            this.rev.checkMissingDeleted();
            if (!this.checkAndDownloadMissing()) {
                return;
            }
        } else {
            this.rev.checkMissingDeleted();
            this.rev.downloadMissingPrimitives(this.progressMonitor.createSubTaskMonitor(0, false));
        }
        if (this.progressMonitor.isCanceled()) {
            return;
        }
        this.rev.downloadObjectsHistory(this.progressMonitor.createSubTaskMonitor(-1, false));
        if (this.progressMonitor.isCanceled()) {
            return;
        }
        if (!this.checkAndDownloadMissing()) {
            return;
        }
        this.rev.fixNodesWithoutCoordinates(this.progressMonitor);
        List<Command> cmds = this.rev.getCommands();
        RevertChangesetCommand cmd = new RevertChangesetCommand(I18n.tr((String)(this.revertType == ChangesetReverter.RevertType.FULL ? "Revert changeset #{0}" : "Partially revert changeset #{0}"), (Object[])new Object[]{this.changesetId}), cmds);
        int n = 0;
        for (Command c : cmds) {
            if (!(c instanceof ConflictAddCommand)) continue;
            ++n;
        }
        int newConflicts = n;
        GuiHelper.runInEDT((Runnable)new Runnable((Command)cmd, newConflicts){
            final /* synthetic */ Command val$cmd;
            final /* synthetic */ int val$newConflicts;
            {
                this.val$cmd = command;
                this.val$newConflicts = n;
            }

            @Override
            public void run() {
                Main.main.undoRedo.add(this.val$cmd);
                if (this.val$newConflicts > 0) {
                    Main.map.conflictDialog.warnNumNewConflicts(this.val$newConflicts);
                }
            }
        });
    }

    protected void cancel() {
    }

    protected void finish() {
    }
}

