/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.geotools.io.TableWriter;
import org.geotools.measure.Angle;
import org.geotools.measure.AngleFormat;
import org.geotools.resources.Arguments;
import org.geotools.resources.Classes;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;

public class ParameterWriter
extends FilterWriter {
    private Locale locale = Locale.getDefault();
    private transient NumberFormat numberFormat;
    private transient DateFormat dateFormat;
    private transient AngleFormat angleFormat;

    public ParameterWriter() {
        this(Arguments.getWriter(System.out));
    }

    public ParameterWriter(Writer out) {
        super(out);
    }

    public static void print(OperationMethod operation) {
        ParameterWriter writer = new ParameterWriter();
        try {
            writer.format(operation);
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public static void print(ParameterDescriptorGroup descriptor) {
        ParameterWriter writer = new ParameterWriter();
        try {
            writer.format(descriptor);
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public static void print(ParameterValueGroup values) {
        ParameterWriter writer = new ParameterWriter();
        try {
            writer.format(values);
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(OperationMethod operation) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.format(operation.getName().getCode(), operation.getParameters(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(ParameterDescriptorGroup descriptor) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.format(descriptor.getName().getCode(), descriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(ParameterValueGroup values) throws IOException {
        ParameterDescriptorGroup descriptor = values.getDescriptor();
        Object object = this.lock;
        synchronized (object) {
            this.format(descriptor.getName().getCode(), descriptor, values);
        }
    }

    private void format(String name, ParameterDescriptorGroup group, ParameterValueGroup values) throws IOException {
        String lineSeparator = System.getProperty("line.separator", "\n");
        this.out.write(32);
        this.out.write(name);
        this.out.write(lineSeparator);
        Collection<GenericName> alias = group.getAlias();
        if (alias != null) {
            boolean first = true;
            for (GenericName a : alias) {
                this.out.write(first ? " alias " : "       ");
                this.out.write(a.toInternationalString().toString(this.locale));
                this.out.write(lineSeparator);
                first = false;
            }
        }
        Vocabulary resources = Vocabulary.getResources(this.locale);
        TableWriter table = new TableWriter(this.out, " \u2502 ");
        table.setMultiLinesCells(true);
        table.writeHorizontalSeparator();
        table.write(resources.getString(146));
        table.nextColumn();
        table.write(resources.getString(18));
        table.nextColumn();
        table.write("Minimum");
        table.nextColumn();
        table.write("Maximum");
        table.nextColumn();
        table.write(resources.getString(values == null ? 43 : 236));
        table.nextColumn();
        table.write("Units");
        table.nextLine();
        table.nextLine('\u2550');
        ArrayList deferredGroups = null;
        Object[] array1 = new Object[1];
        List<Object> elements = values != null ? values.values() : group.descriptors();
        for (Object e : elements) {
            GeneralParameterDescriptor generalDescriptor;
            GeneralParameterValue generalValue;
            if (values != null) {
                generalValue = (GeneralParameterValue)e;
                generalDescriptor = generalValue.getDescriptor();
            } else {
                generalValue = null;
                generalDescriptor = (GeneralParameterDescriptor)e;
            }
            if (generalDescriptor instanceof ParameterDescriptorGroup) {
                if (deferredGroups == null) {
                    deferredGroups = new ArrayList();
                }
                deferredGroups.add(e);
                continue;
            }
            ReferenceIdentifier identifier = generalDescriptor.getName();
            table.write(identifier.getCode());
            alias = generalDescriptor.getAlias();
            if (alias != null) {
                for (GenericName a : alias) {
                    if (identifier.equals(a)) continue;
                    table.write(lineSeparator);
                    table.write(a.tip().toInternationalString().toString(this.locale));
                }
            }
            table.nextColumn();
            if (generalDescriptor instanceof ParameterDescriptor) {
                Object array;
                ParameterDescriptor descriptor = (ParameterDescriptor)generalDescriptor;
                table.write(Classes.getShortName(descriptor.getValueClass()));
                table.nextColumn();
                table.setAlignment(2);
                Object value = descriptor.getMinimumValue();
                if (value != null) {
                    table.write(this.formatValue(value));
                }
                table.nextColumn();
                value = descriptor.getMaximumValue();
                if (value != null) {
                    table.write(this.formatValue(value));
                }
                table.nextColumn();
                value = generalValue != null ? ((ParameterValue)generalValue).getValue() : descriptor.getDefaultValue();
                if (value != null && value.getClass().isArray()) {
                    array = value;
                } else {
                    array = array1;
                    array1[0] = value;
                }
                int length = Array.getLength(array);
                for (int i = 0; i < length; ++i) {
                    value = Array.get(array, i);
                    if (value == null) continue;
                    if (i != 0) {
                        table.write(lineSeparator);
                    }
                    table.write(this.formatValue(value));
                }
                table.nextColumn();
                table.setAlignment(0);
                value = descriptor.getUnit();
                if (value != null) {
                    table.write(value.toString());
                }
            }
            table.writeHorizontalSeparator();
        }
        table.flush();
        if (deferredGroups != null) {
            for (Object e : deferredGroups) {
                ParameterDescriptorGroup descriptor;
                ParameterValueGroup value;
                if (e instanceof ParameterValueGroup) {
                    value = (ParameterValueGroup)e;
                    descriptor = value.getDescriptor();
                } else {
                    value = null;
                    descriptor = (ParameterDescriptorGroup)e;
                }
                this.out.write(lineSeparator);
                this.format(name + '/' + descriptor.getName().getCode(), descriptor, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void summary(Collection<? extends IdentifiedObject> parameters, Set<String> scopes) throws IOException {
        void var8_10;
        LinkedHashMap<Object, Integer> titles = new LinkedHashMap<Object, Integer>();
        ArrayList<String[]> names = new ArrayList<String[]>();
        Locale locale = this.locale;
        String[] descriptions = null;
        titles.put(null, 0);
        for (IdentifiedObject identifiedObject : parameters) {
            InternationalString remarks;
            Collection<GenericName> aliases = identifiedObject.getAlias();
            String[] elementNames = new String[titles.size()];
            elementNames[0] = identifiedObject.getName().getCode();
            if (aliases != null) {
                int count = 0;
                for (GenericName alias : aliases) {
                    int index;
                    Object title;
                    GenericName scope = alias.scope().name();
                    LocalName name = alias.tip();
                    if (scope != null) {
                        if (scopes != null && !scopes.contains(scope.toString())) continue;
                        title = scope.toInternationalString().toString(locale);
                    } else {
                        title = count++;
                    }
                    Integer position = (Integer)titles.get(title);
                    if (position == null) {
                        position = titles.size();
                        titles.put(title, position);
                    }
                    if ((index = position.intValue()) >= elementNames.length) {
                        elementNames = XArray.resize(elementNames, index + 1);
                    }
                    String oldName = elementNames[index];
                    String newName = name.toInternationalString().toString(locale);
                    if (oldName != null && oldName.length() <= newName.length()) continue;
                    elementNames[index] = newName;
                }
            }
            if ((remarks = identifiedObject.getRemarks()) != null) {
                if (descriptions == null) {
                    descriptions = new String[parameters.size()];
                }
                descriptions[names.size()] = remarks.toString(locale);
            }
            names.add(elementNames);
        }
        boolean[] hide = new boolean[titles.size()];
        int n = hide.length;
        block5: while (--var8_10 >= true) {
            for (String[] alias : names) {
                String name;
                if (alias.length <= var8_10 || (name = alias[var8_10]) == null || name.equals(alias[0])) continue;
                continue block5;
            }
            hide[var8_10] = true;
        }
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            TableWriter table = new TableWriter(this.out, " \u2502 ");
            table.setMultiLinesCells(true);
            table.writeHorizontalSeparator();
            for (Object element : titles.keySet()) {
                void var8_12;
                if (hide[++var8_12]) continue;
                String title = element == null ? "Identifier" : (element instanceof String ? (String)element : "Alias " + element);
                table.write(title);
                table.nextColumn();
            }
            if (descriptions != null) {
                table.write("Description");
            }
            table.writeHorizontalSeparator();
            int counter = 0;
            for (String[] aliases : names) {
                String remarks;
                for (int i = 0; i < hide.length; ++i) {
                    String alias;
                    if (hide[i]) continue;
                    if (i < aliases.length && (alias = aliases[i]) != null) {
                        table.write(alias);
                    }
                    table.nextColumn();
                }
                if (descriptions != null && (remarks = descriptions[counter++]) != null) {
                    table.write(remarks);
                }
                table.nextLine();
            }
            table.writeHorizontalSeparator();
            table.flush();
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) {
        Object object = this.lock;
        synchronized (object) {
            this.locale = locale;
            this.numberFormat = null;
            this.dateFormat = null;
            this.angleFormat = null;
        }
    }

    protected String formatValue(Object value) {
        if (value instanceof Number) {
            if (this.numberFormat == null) {
                this.numberFormat = NumberFormat.getNumberInstance(this.locale);
            }
            return this.numberFormat.format(value);
        }
        if (value instanceof Date) {
            if (this.dateFormat == null) {
                this.dateFormat = DateFormat.getDateInstance(2, this.locale);
            }
            return this.dateFormat.format(value);
        }
        if (value instanceof Angle) {
            if (this.angleFormat == null) {
                this.angleFormat = AngleFormat.getInstance(this.locale);
            }
            return this.angleFormat.format(value);
        }
        return String.valueOf(value);
    }
}

