/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.MultiLineString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockFactory;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.FilteringFeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

@Deprecated
public abstract class AbstractDataStoreTest
extends DataTestCase {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.hsql");
    DataStore data;

    public AbstractDataStoreTest(String arg0) {
        super(arg0);
    }

    public abstract DataStore createDataStore() throws Exception;

    public abstract DataStore tearDownDataStore(DataStore var1) throws Exception;

    @Override
    protected void setUp() throws Exception {
        this.dataSetUp();
        try {
            this.data = this.createDataStore();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "exception while making schema", e);
        }
        this.data.createSchema(this.roadType);
        this.data.createSchema(this.riverType);
        SimpleFeatureStore roads = (SimpleFeatureStore)this.data.getFeatureSource(this.roadType.getTypeName());
        roads.addFeatures(DataUtilities.collection(this.roadFeatures));
        SimpleFeatureStore rivers = (SimpleFeatureStore)this.data.getFeatureSource(this.riverType.getTypeName());
        rivers.addFeatures(DataUtilities.collection(this.riverFeatures));
        this.roadFeatures = this.grabArray(roads.getFeatures(), this.roadFeatures.length);
        this.riverFeatures = this.grabArray(rivers.getFeatures(), this.riverFeatures.length);
    }

    SimpleFeature[] grabArray(SimpleFeatureCollection features, int size) {
        SimpleFeature[] array = new SimpleFeature[size];
        array = features.toArray(array);
        AbstractDataStoreTest.assertNotNull((Object)array);
        return array;
    }

    @Override
    protected void tearDown() throws Exception {
        this.tearDownDataStore(this.data);
        this.data = null;
        super.tearDown();
    }

    public void testFeatureEvents() throws Exception {
        SimpleFeatureStore store1 = (SimpleFeatureStore)this.data.getFeatureSource(this.roadFeatures[0].getFeatureType().getTypeName());
        SimpleFeatureStore store2 = (SimpleFeatureStore)this.data.getFeatureSource(this.roadFeatures[0].getFeatureType().getTypeName());
        store1.setTransaction(new DefaultTransaction());
        class Listener
        implements FeatureListener {
            String name;
            List events = new ArrayList();

            public Listener(String name) {
                this.name = name;
            }

            @Override
            public void changed(FeatureEvent featureEvent) {
                this.events.add(featureEvent);
            }

            FeatureEvent getEvent(int i) {
                return (FeatureEvent)this.events.get(i);
            }
        }
        Listener listener1 = new Listener("one");
        Listener listener2 = new Listener("two");
        store1.addFeatureListener(listener1);
        store2.addFeatureListener(listener2);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        SimpleFeature feature = this.roadFeatures[0];
        Id fidFilter = ff.id(Collections.singleton(ff.featureId(feature.getID())));
        store1.removeFeatures(fidFilter);
        AbstractDataStoreTest.assertEquals((int)1, (int)listener1.events.size());
        AbstractDataStoreTest.assertEquals((int)0, (int)listener2.events.size());
        FeatureEvent event = listener1.getEvent(0);
        AbstractDataStoreTest.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        AbstractDataStoreTest.assertEquals((int)-1, (int)event.getEventType());
        listener1.events.clear();
        listener2.events.clear();
        store1.getTransaction().commit();
        AbstractDataStoreTest.assertEquals((int)0, (int)listener1.events.size());
        AbstractDataStoreTest.assertEquals((int)2, (int)listener2.events.size());
        event = listener2.getEvent(0);
        AbstractDataStoreTest.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        AbstractDataStoreTest.assertEquals((int)-1, (int)event.getEventType());
        listener1.events.clear();
        listener2.events.clear();
        store1.addFeatures(DataUtilities.collection(feature));
        AbstractDataStoreTest.assertEquals((int)1, (int)listener1.events.size());
        event = listener1.getEvent(0);
        AbstractDataStoreTest.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        AbstractDataStoreTest.assertEquals((int)1, (int)event.getEventType());
        AbstractDataStoreTest.assertEquals((int)0, (int)listener2.events.size());
        listener1.events.clear();
        listener2.events.clear();
        store1.getTransaction().rollback();
        AbstractDataStoreTest.assertEquals((int)1, (int)listener1.events.size());
        event = listener1.getEvent(0);
        AbstractDataStoreTest.assertNull((Object)event.getBounds());
        AbstractDataStoreTest.assertEquals((int)0, (int)event.getEventType());
        AbstractDataStoreTest.assertEquals((int)0, (int)listener2.events.size());
    }

    public void testFixture() throws Exception {
        SimpleFeatureType type = DataUtilities.createType("namespace.typename", "name:String,id:0,geom:MultiLineString");
        AbstractDataStoreTest.assertEquals((String)"namespace", (String)"namespace", (String)type.getName().getNamespaceURI());
        AbstractDataStoreTest.assertEquals((String)"typename", (String)"typename", (String)type.getTypeName());
        AbstractDataStoreTest.assertEquals((String)"attributes", (int)3, (int)type.getAttributeCount());
        AttributeDescriptor[] a = type.getAttributeDescriptors().toArray(new AttributeDescriptor[type.getAttributeCount()]);
        AbstractDataStoreTest.assertEquals((String)"a1", (String)"name", (String)a[0].getLocalName());
        AbstractDataStoreTest.assertEquals((String)"a1", String.class, a[0].getType().getBinding());
        AbstractDataStoreTest.assertEquals((String)"a2", (String)"id", (String)a[1].getLocalName());
        AbstractDataStoreTest.assertEquals((String)"a2", Integer.class, a[1].getType().getBinding());
        AbstractDataStoreTest.assertEquals((String)"a3", (String)"geom", (String)a[2].getLocalName());
        AbstractDataStoreTest.assertEquals((String)"a3", MultiLineString.class, a[2].getType().getBinding());
    }

    public void testGetFeatureTypes() {
        try {
            Object[] names = this.data.getTypeNames();
            AbstractDataStoreTest.assertEquals((int)2, (int)names.length);
            AbstractDataStoreTest.assertTrue((boolean)this.contains(names, "ROAD"));
            AbstractDataStoreTest.assertTrue((boolean)this.contains(names, "RIVER"));
        }
        catch (IOException e) {
            e.printStackTrace();
            AbstractDataStoreTest.fail((String)"Fail with an IOException trying to getTypeNames()");
        }
    }

    boolean contains(Object[] array, Object expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(expected)) continue;
            return true;
        }
        return false;
    }

    boolean containsFeatureCollection(SimpleFeatureCollection fc, SimpleFeature f) {
        if (fc == null || fc.isEmpty()) {
            return false;
        }
        return this.containsFeature(fc.toArray(), f);
    }

    boolean containsFeature(Object[] array, Object expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!this.isFeatureEqual((SimpleFeature)array[i], (SimpleFeature)expected)) continue;
            return true;
        }
        return false;
    }

    public boolean isFeatureEqual(SimpleFeature feature1, SimpleFeature feature2) {
        if (feature2 == null) {
            return false;
        }
        if (feature2 == feature1) {
            return true;
        }
        if (!feature2.getFeatureType().equals(feature1.getFeatureType())) {
            return false;
        }
        int ii = feature1.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            Object otherAtt = feature2.getAttribute(i);
            if (!(feature1.getAttribute(i) == null ? otherAtt != null : !feature1.getAttribute(i).equals(otherAtt))) continue;
            return false;
        }
        return true;
    }

    boolean containsLax(SimpleFeature[] array, SimpleFeature expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        SimpleFeatureType type = expected.getFeatureType();
        for (int i = 0; i < array.length; ++i) {
            if (!this.match(array[i], expected)) continue;
            return true;
        }
        return false;
    }

    boolean match(SimpleFeature expected, SimpleFeature actual) {
        SimpleFeatureType type = expected.getFeatureType();
        for (int i = 0; i < type.getAttributeCount(); ++i) {
            Object av = actual.getAttribute(i);
            Object ev = expected.getAttribute(i);
            if (av == null && ev != null) {
                return false;
            }
            if (ev == null && av != null) {
                return false;
            }
            if (av.equals(ev)) continue;
            return false;
        }
        return true;
    }

    public void testGetSchema() throws IOException {
        AbstractDataStoreTest.assertEquals((Object)this.roadType, (Object)this.data.getSchema("ROAD"));
        AbstractDataStoreTest.assertEquals((Object)this.riverType, (Object)this.data.getSchema("RIVER"));
    }

    void assertCovers(String msg, SimpleFeatureCollection c1, SimpleFeatureCollection c2) {
        if (c1 == c2) {
            return;
        }
        AbstractDataStoreTest.assertNotNull((String)msg, (Object)c1);
        AbstractDataStoreTest.assertNotNull((String)msg, (Object)c2);
        AbstractDataStoreTest.assertEquals((String)(msg + " size"), (int)c1.size(), (int)c2.size());
        SimpleFeatureIterator i = c1.features();
        while (i.hasNext()) {
            SimpleFeature f = (SimpleFeature)i.next();
            AbstractDataStoreTest.assertTrue((String)(msg + " " + f.getID()), (boolean)this.containsFeatureCollection(c2, f));
        }
    }

    public void testGetFeatureReader() throws IOException, IllegalAttributeException {
        Query query = new Query(this.roadType.getTypeName());
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.data.getFeatureReader(query, Transaction.AUTO_COMMIT);
        this.assertCovered(this.roadFeatures, reader);
        AbstractDataStoreTest.assertEquals((boolean)false, (boolean)reader.hasNext());
    }

    public void testGetFeatureReaderMutability() throws IOException, IllegalAttributeException {
        SimpleFeature feature;
        Query query = new Query(this.roadType.getTypeName());
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.data.getFeatureReader(query, Transaction.AUTO_COMMIT);
        while (reader.hasNext()) {
            feature = reader.next();
            feature.setAttribute("NAME", null);
        }
        reader.close();
        reader = this.data.getFeatureReader(query, Transaction.AUTO_COMMIT);
        while (reader.hasNext()) {
            feature = reader.next();
            AbstractDataStoreTest.assertNotNull((Object)feature.getAttribute("NAME"));
        }
        reader.close();
        try {
            reader.next();
            AbstractDataStoreTest.fail((String)"next should fail with an IOException or NoSuchElementException");
        }
        catch (IOException expected) {
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
    }

    public void testGetFeatureReaderConcurancy() throws NoSuchElementException, IOException, IllegalAttributeException {
        Query query = new Query(this.roadType.getTypeName());
        FeatureReader<SimpleFeatureType, SimpleFeature> reader1 = this.data.getFeatureReader(query, Transaction.AUTO_COMMIT);
        FeatureReader<SimpleFeatureType, SimpleFeature> reader2 = this.data.getFeatureReader(query, Transaction.AUTO_COMMIT);
        query = new Query(this.riverType.getTypeName());
        FeatureReader<SimpleFeatureType, SimpleFeature> reader3 = this.data.getFeatureReader(query, Transaction.AUTO_COMMIT);
        while (reader1.hasNext() || reader2.hasNext() || reader3.hasNext()) {
            AbstractDataStoreTest.assertTrue((boolean)this.containsFeature(this.roadFeatures, reader1.next()));
            AbstractDataStoreTest.assertTrue((boolean)this.containsFeature(this.roadFeatures, reader2.next()));
            if (!reader3.hasNext()) continue;
            AbstractDataStoreTest.assertTrue((boolean)this.containsFeature(this.riverFeatures, reader3.next()));
        }
        try {
            reader1.next();
            AbstractDataStoreTest.fail((String)"next should fail with an IOException or NoSuchElementException");
        }
        catch (IOException expected) {
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        try {
            reader2.next();
            AbstractDataStoreTest.fail((String)"next should fail with an IOException or NoSuchElementException");
        }
        catch (IOException expected) {
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        try {
            reader3.next();
            AbstractDataStoreTest.fail((String)"next should fail with an IOException or NoSuchElementException");
        }
        catch (IOException expected) {
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        reader1.close();
        reader2.close();
        reader3.close();
    }

    public void testGetFeatureReaderFilterAutoCommit() throws NoSuchElementException, IOException, IllegalAttributeException {
        SimpleFeatureType type = this.data.getSchema("ROAD");
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.data.getFeatureReader(new Query("ROAD"), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertFalse((boolean)(reader instanceof FilteringFeatureReader));
        AbstractDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        AbstractDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
        reader = this.data.getFeatureReader(new Query("ROAD", Filter.EXCLUDE), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        AbstractDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        reader = this.data.getFeatureReader(new Query("ROAD", this.rd1Filter), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        AbstractDataStoreTest.assertEquals((int)1, (int)this.count(reader));
    }

    public void testGetFeatureReaderFilterTransaction() throws NoSuchElementException, IOException, IllegalAttributeException {
        DefaultTransaction t = new DefaultTransaction();
        SimpleFeatureType type = this.data.getSchema("ROAD");
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.data.getFeatureReader(new Query("ROAD", Filter.EXCLUDE), t);
        AbstractDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        AbstractDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        reader = this.data.getFeatureReader(new Query("ROAD"), t);
        AbstractDataStoreTest.assertTrue((boolean)(reader instanceof DiffFeatureReader));
        AbstractDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        AbstractDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
        reader = this.data.getFeatureReader(new Query("ROAD", this.rd1Filter), t);
        AbstractDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        AbstractDataStoreTest.assertEquals((int)1, (int)this.count(reader));
        SimpleFeatureStore store = (SimpleFeatureStore)this.data.getFeatureSource("ROAD");
        store.setTransaction(t);
        store.removeFeatures(this.rd1Filter);
        reader = this.data.getFeatureReader(new Query("ROAD", Filter.EXCLUDE), t);
        AbstractDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        reader = this.data.getFeatureReader(new Query("ROAD"), t);
        AbstractDataStoreTest.assertEquals((int)(this.roadFeatures.length - 1), (int)this.count(reader));
        reader = this.data.getFeatureReader(new Query("ROAD", this.rd1Filter), t);
        AbstractDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        t.rollback();
        reader = this.data.getFeatureReader(new Query("ROAD", Filter.EXCLUDE), t);
        AbstractDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        reader = this.data.getFeatureReader(new Query("ROAD"), t);
        AbstractDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
        reader = this.data.getFeatureReader(new Query("ROAD", this.rd1Filter), t);
        AbstractDataStoreTest.assertEquals((int)1, (int)this.count(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertCovered(SimpleFeature[] features, FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        while (reader.hasNext()) {
            AbstractDataStoreTest.assertTrue((boolean)this.containsFeature(features, reader.next()));
            ++count;
        }
        AbstractDataStoreTest.assertEquals((int)features.length, (int)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean covers(SimpleFeatureCollection features, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try (SimpleFeatureIterator i = features.features();){
            while (i.hasNext()) {
                SimpleFeature feature = (SimpleFeature)i.next();
                if (!this.containsFeature(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        return count == array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean covers(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = reader.next();
                AbstractDataStoreTest.assertNotNull((String)"feature", (Object)feature);
                if (!this.containsFeature(array, feature)) {
                    AbstractDataStoreTest.fail((String)("feature " + feature.getID() + " not listed"));
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        AbstractDataStoreTest.assertEquals((String)"covers", (int)count, (int)array.length);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean covers(SimpleFeatureIterator reader, SimpleFeature[] array) throws NoSuchElementException, IOException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                AbstractDataStoreTest.assertNotNull((String)"feature", (Object)feature);
                if (!this.containsFeature(array, feature)) {
                    AbstractDataStoreTest.fail((String)("feature " + feature.getID() + " not listed"));
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        AbstractDataStoreTest.assertEquals((String)"covers", (int)count, (int)array.length);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean coversLax(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = reader.next();
                if (!this.containsLax(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        return count == array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean coversLax(SimpleFeatureIterator reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                if (!this.containsLax(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        return count == array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = reader.next();
                System.out.println(count + " feature:" + feature);
                ++count;
            }
        }
        finally {
            reader.close();
        }
    }

    void dump(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            System.out.println(i + " feature:" + array[i]);
        }
    }

    public void testGetFeatureWriter() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.data.getFeatureWriter("ROAD", Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(writer));
        try {
            writer.hasNext();
            AbstractDataStoreTest.fail((String)"Should not be able to use a closed writer");
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            writer.next();
            AbstractDataStoreTest.fail((String)"Should not be able to use a closed writer");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testGetFeatureWriterRemove() throws IOException, IllegalAttributeException {
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.data.getFeatureWriter("ROAD", Transaction.AUTO_COMMIT);
        while (writer.hasNext()) {
            SimpleFeature feature = writer.next();
            if (!feature.getID().equals(this.roadFeatures[0].getID())) continue;
            writer.remove();
        }
        writer = this.data.getFeatureWriter("ROAD", Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertEquals((int)(this.roadFeatures.length - 1), (int)this.count(writer));
    }

    public void testGetFeaturesWriterAdd() throws IOException, IllegalAttributeException {
        SimpleFeature feature;
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.data.getFeatureWriter("ROAD", Transaction.AUTO_COMMIT);
        while (writer.hasNext()) {
            feature = writer.next();
        }
        AbstractDataStoreTest.assertFalse((boolean)writer.hasNext());
        feature = writer.next();
        feature.setAttributes(this.newRoad.getAttributes());
        writer.write();
        AbstractDataStoreTest.assertFalse((boolean)writer.hasNext());
        writer = this.data.getFeatureWriter("ROAD", Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertEquals((int)(this.roadFeatures.length + 1), (int)this.count(writer));
    }

    public void testGetFeaturesWriterModify() throws IOException, IllegalAttributeException {
        SimpleFeature feature;
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.data.getFeatureWriter("ROAD", Transaction.AUTO_COMMIT);
        while (writer.hasNext()) {
            feature = writer.next();
            if (!feature.getID().equals(this.roadFeatures[0].getID())) continue;
            feature.setAttribute("NAME", (Object)"changed");
            writer.write();
        }
        feature = null;
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.data.getFeatureReader(new Query("ROAD", this.rd1Filter), Transaction.AUTO_COMMIT);
        if (reader.hasNext()) {
            feature = reader.next();
        }
        AbstractDataStoreTest.assertEquals((Object)"changed", (Object)feature.getAttribute("NAME"));
    }

    public void testGetFeatureWriterTypeNameTransaction() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.data.getFeatureWriter("ROAD", Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(writer));
        writer.close();
    }

    public void testGetFeatureWriterAppendTypeNameTransaction() throws Exception {
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.data.getFeatureWriterAppend("ROAD", Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertEquals((int)0, (int)this.count(writer));
        writer.close();
    }

    public void testGetFeatureWriterFilter() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.data.getFeatureWriter("ROAD", Filter.EXCLUDE, Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertFalse((boolean)writer.hasNext());
        AbstractDataStoreTest.assertEquals((int)0, (int)this.count(writer));
        writer = this.data.getFeatureWriter("ROAD", Filter.INCLUDE, Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertFalse((boolean)(writer instanceof FilteringFeatureWriter));
        AbstractDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(writer));
        writer = this.data.getFeatureWriter("ROAD", this.rd1Filter, Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertEquals((int)1, (int)this.count(writer));
    }

    public void testGetFeatureWriterTransaction() throws Exception {
        SimpleFeature feature;
        int i;
        DefaultTransaction t1 = new DefaultTransaction();
        DefaultTransaction t2 = new DefaultTransaction();
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer1 = this.data.getFeatureWriter("ROAD", this.rd1Filter, t1);
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer2 = this.data.getFeatureWriterAppend("ROAD", t2);
        SimpleFeatureType road = this.data.getSchema("ROAD");
        SimpleFeature[] ORIGIONAL = this.roadFeatures;
        SimpleFeature[] REMOVE = new SimpleFeature[ORIGIONAL.length - 1];
        SimpleFeature[] ADD = new SimpleFeature[ORIGIONAL.length + 1];
        SimpleFeature[] FINAL = new SimpleFeature[ORIGIONAL.length];
        int index = 0;
        for (i = 0; i < ORIGIONAL.length; ++i) {
            feature = ORIGIONAL[i];
            if (feature.getID().equals(this.roadFeatures[0].getID())) continue;
            REMOVE[index++] = feature;
        }
        for (i = 0; i < ORIGIONAL.length; ++i) {
            ADD[i] = ORIGIONAL[i];
        }
        ADD[i] = this.newRoad;
        for (i = 0; i < REMOVE.length; ++i) {
            FINAL[i] = REMOVE[i];
        }
        FINAL[i] = this.newRoad;
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.data.getFeatureReader(new Query("ROAD"), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, ORIGIONAL));
        while (writer1.hasNext()) {
            feature = writer1.next();
            AbstractDataStoreTest.assertEquals((String)this.roadFeatures[0].getID(), (String)feature.getID());
            writer1.remove();
        }
        reader = this.data.getFeatureReader(new Query("ROAD"), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, ORIGIONAL));
        reader = this.data.getFeatureReader(new Query("ROAD"), t1);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, REMOVE));
        writer1.close();
        reader = this.data.getFeatureReader(new Query("ROAD"), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, ORIGIONAL));
        reader = this.data.getFeatureReader(new Query("ROAD"), t1);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, REMOVE));
        feature = writer2.next();
        feature.setAttributes(this.newRoad.getAttributes());
        writer2.write();
        reader = this.data.getFeatureReader(new Query("ROAD"), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, ORIGIONAL));
        reader = this.data.getFeatureReader(new Query("ROAD"), t2);
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(reader, ADD));
        writer2.close();
        reader = this.data.getFeatureReader(new Query("ROAD"), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, ORIGIONAL));
        reader = this.data.getFeatureReader(new Query("ROAD"), t2);
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(reader, ADD));
        t1.commit();
        reader = this.data.getFeatureReader(new Query("ROAD"), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, REMOVE));
        reader = this.data.getFeatureReader(new Query("ROAD"), t1);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(reader, REMOVE));
        reader = this.data.getFeatureReader(new Query("ROAD"), t2);
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(reader, FINAL));
        t2.commit();
        reader = this.data.getFeatureReader(new Query("ROAD"), Transaction.AUTO_COMMIT);
        reader = this.data.getFeatureReader(new Query("ROAD"), Transaction.AUTO_COMMIT);
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(reader, FINAL));
        reader = this.data.getFeatureReader(new Query("ROAD"), t1);
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(reader, FINAL));
        reader = this.data.getFeatureReader(new Query("ROAD"), t2);
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(reader, FINAL));
    }

    public void atestGetFeatureSourceRoad() throws IOException {
        SimpleFeatureSource road = this.data.getFeatureSource("ROAD");
        AbstractDataStoreTest.assertEquals((Object)this.roadType, road.getSchema());
        AbstractDataStoreTest.assertEquals((Object)this.data, road.getDataStore());
        AbstractDataStoreTest.assertEquals((int)3, (int)road.getCount(Query.ALL));
        AbstractDataStoreTest.assertEquals((Object)new Envelope(1.0, 5.0, 0.0, 4.0), (Object)road.getFeatures(Query.ALL).getBounds());
        SimpleFeatureCollection all = road.getFeatures();
        AbstractDataStoreTest.assertEquals((int)3, (int)all.size());
        AbstractDataStoreTest.assertEquals((Object)this.roadBounds, (Object)all.getBounds());
        SimpleFeatureCollection expected = DataUtilities.collection(this.roadFeatures);
        this.assertCovers("ALL", expected, all);
        AbstractDataStoreTest.assertEquals((Object)this.roadBounds, (Object)all.getBounds());
        SimpleFeatureCollection some = road.getFeatures(this.rd12Filter);
        AbstractDataStoreTest.assertEquals((int)2, (int)some.size());
        AbstractDataStoreTest.assertEquals((Object)this.rd12Bounds, (Object)some.getBounds());
        AbstractDataStoreTest.assertEquals(some.getSchema(), road.getSchema());
        Query query = new Query("ROAD", this.rd12Filter, new String[]{"NAME"});
        SimpleFeatureCollection half = road.getFeatures(query);
        AbstractDataStoreTest.assertEquals((int)2, (int)half.size());
        AbstractDataStoreTest.assertEquals((int)1, (int)((SimpleFeatureType)half.getSchema()).getAttributeCount());
        SimpleFeatureIterator reader = half.features();
        SimpleFeatureType type = (SimpleFeatureType)half.getSchema();
        reader.close();
        SimpleFeatureType actual = (SimpleFeatureType)half.getSchema();
        AbstractDataStoreTest.assertEquals((String)type.getTypeName(), (String)actual.getTypeName());
        AbstractDataStoreTest.assertEquals((String)type.getName().getNamespaceURI(), (String)actual.getName().getNamespaceURI());
        AbstractDataStoreTest.assertEquals((int)type.getAttributeCount(), (int)actual.getAttributeCount());
        for (int i = 0; i < type.getAttributeCount(); ++i) {
            AbstractDataStoreTest.assertEquals((Object)type.getDescriptor(i), (Object)actual.getDescriptor(i));
        }
        AbstractDataStoreTest.assertNull((Object)type.getGeometryDescriptor());
        AbstractDataStoreTest.assertEquals((Object)type.getGeometryDescriptor(), (Object)actual.getGeometryDescriptor());
        AbstractDataStoreTest.assertEquals((Object)type, (Object)actual);
        ReferencedEnvelope b = half.getBounds();
        AbstractDataStoreTest.assertEquals((Object)new ReferencedEnvelope(1.0, 5.0, 0.0, 4.0, null), (Object)b);
    }

    public void testGetFeatureSourceRiver() throws NoSuchElementException, IOException, IllegalAttributeException {
        SimpleFeatureSource river = this.data.getFeatureSource("RIVER");
        AbstractDataStoreTest.assertEquals((Object)this.riverType, river.getSchema());
        AbstractDataStoreTest.assertEquals((Object)this.data, river.getDataStore());
        SimpleFeatureCollection all = river.getFeatures();
        AbstractDataStoreTest.assertEquals((int)2, (int)all.size());
        AbstractDataStoreTest.assertEquals((Object)this.riverBounds, (Object)all.getBounds());
        AbstractDataStoreTest.assertTrue((String)"RIVERS", (boolean)this.covers(all.features(), this.riverFeatures));
        SimpleFeatureCollection expected = DataUtilities.collection(this.riverFeatures);
        this.assertCovers("ALL", expected, all);
        AbstractDataStoreTest.assertEquals((Object)this.riverBounds, (Object)all.getBounds());
    }

    public void testGetFeatureStoreModifyFeatures1() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("ROAD");
        AttributeDescriptor name = this.roadType.getDescriptor("NAME");
        road.modifyFeatures(name, (Object)"changed", this.rd1Filter);
        SimpleFeatureCollection results = road.getFeatures(this.rd1Filter);
        AbstractDataStoreTest.assertEquals((Object)"changed", (Object)((SimpleFeature)results.features().next()).getAttribute("NAME"));
    }

    public void testGetFeatureStoreModifyFeatures2() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("ROAD");
        AttributeDescriptor name = this.roadType.getDescriptor("NAME");
        road.modifyFeatures(new AttributeDescriptor[]{name}, new Object[]{"changed"}, this.rd1Filter);
        SimpleFeatureCollection results = road.getFeatures(this.rd1Filter);
        AbstractDataStoreTest.assertEquals((Object)"changed", (Object)((SimpleFeature)results.features().next()).getAttribute("NAME"));
    }

    public void testGetFeatureStoreRemoveFeatures() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("ROAD");
        road.removeFeatures(this.rd1Filter);
        AbstractDataStoreTest.assertEquals((int)0, (int)road.getFeatures(this.rd1Filter).size());
        AbstractDataStoreTest.assertEquals((int)(this.roadFeatures.length - 1), (int)road.getFeatures().size());
    }

    public void testGetFeatureStoreAddFeatures() throws IOException {
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = DataUtilities.reader(new SimpleFeature[]{this.newRoad});
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("ROAD");
        road.addFeatures(DataUtilities.collection(reader));
        AbstractDataStoreTest.assertEquals((int)(this.roadFeatures.length + 1), (int)road.getFeatures().size());
    }

    public void testGetFeatureStoreSetFeatures() throws IOException {
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = DataUtilities.reader(new SimpleFeature[]{this.newRoad});
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("ROAD");
        road.setFeatures(reader);
        AbstractDataStoreTest.assertEquals((int)1, (int)road.getFeatures().size());
    }

    public void testGetFeatureStoreTransactionSupport() throws Exception {
        int i;
        DefaultTransaction t1 = new DefaultTransaction();
        DefaultTransaction t2 = new DefaultTransaction();
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("ROAD");
        SimpleFeatureStore road1 = (SimpleFeatureStore)this.data.getFeatureSource("ROAD");
        SimpleFeatureStore road2 = (SimpleFeatureStore)this.data.getFeatureSource("ROAD");
        road1.setTransaction(t1);
        road2.setTransaction(t2);
        SimpleFeature[] ORIGIONAL = this.roadFeatures;
        SimpleFeature[] REMOVE = new SimpleFeature[ORIGIONAL.length - 1];
        SimpleFeature[] ADD = new SimpleFeature[ORIGIONAL.length + 1];
        SimpleFeature[] FINAL = new SimpleFeature[ORIGIONAL.length];
        int index = 0;
        for (i = 0; i < ORIGIONAL.length; ++i) {
            SimpleFeature feature = ORIGIONAL[i];
            if (feature.getID().equals(this.roadFeatures[0].getID())) continue;
            REMOVE[index++] = feature;
        }
        for (i = 0; i < ORIGIONAL.length; ++i) {
            ADD[i] = ORIGIONAL[i];
        }
        ADD[i] = this.newRoad;
        for (i = 0; i < REMOVE.length; ++i) {
            FINAL[i] = REMOVE[i];
        }
        FINAL[i] = this.newRoad;
        AbstractDataStoreTest.assertTrue((boolean)this.covers(road.getFeatures().features(), ORIGIONAL));
        road1.removeFeatures(this.rd1Filter);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(road.getFeatures().features(), ORIGIONAL));
        AbstractDataStoreTest.assertTrue((boolean)this.covers(road1.getFeatures().features(), REMOVE));
        SimpleFeatureCollection collection = DataUtilities.collection(new SimpleFeature[]{this.newRoad});
        road2.addFeatures(collection);
        AbstractDataStoreTest.assertTrue((boolean)this.covers(road.getFeatures().features(), ORIGIONAL));
        AbstractDataStoreTest.assertTrue((boolean)this.covers(road1.getFeatures().features(), REMOVE));
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(road2.getFeatures().features(), ADD));
        t1.commit();
        AbstractDataStoreTest.assertTrue((boolean)this.covers(road.getFeatures().features(), REMOVE));
        AbstractDataStoreTest.assertTrue((boolean)this.covers(road1.getFeatures().features(), REMOVE));
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(road2.getFeatures().features(), FINAL));
        t2.commit();
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(road.getFeatures().features(), FINAL));
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(road1.getFeatures().features(), FINAL));
        AbstractDataStoreTest.assertTrue((boolean)this.coversLax(road2.getFeatures().features(), FINAL));
    }

    boolean isLocked(String typeName, String fid) {
        InProcessLockingManager lockingManager = (InProcessLockingManager)this.data.getLockingManager();
        return lockingManager.isLocked(typeName, fid);
    }

    public void testLockFeatures() throws IOException {
        FeatureLock lock = FeatureLockFactory.generate("test", 3600L);
        FeatureLocking road = (FeatureLocking)((Object)this.data.getFeatureSource("ROAD"));
        road.setFeatureLock(lock);
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
        road.lockFeatures();
        AbstractDataStoreTest.assertTrue((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
    }

    public void testUnLockFeatures() throws IOException {
        FeatureLock lock = FeatureLockFactory.generate("test", 360000L);
        FeatureLocking road = (FeatureLocking)((Object)this.data.getFeatureSource("ROAD"));
        road.setFeatureLock(lock);
        road.lockFeatures();
        try {
            road.unLockFeatures();
            AbstractDataStoreTest.fail((String)"unlock should fail due on AUTO_COMMIT");
        }
        catch (IOException expected) {
            // empty catch block
        }
        DefaultTransaction t = new DefaultTransaction();
        road.setTransaction(t);
        try {
            road.unLockFeatures();
            AbstractDataStoreTest.fail((String)"unlock should fail due lack of authorization");
        }
        catch (IOException expected) {
            // empty catch block
        }
        t.addAuthorization(lock.getAuthorization());
        road.unLockFeatures();
    }

    public void testLockFeatureInteraction() throws IOException {
        FeatureLock lockA = FeatureLockFactory.generate("LockA", 3600L);
        FeatureLock lockB = FeatureLockFactory.generate("LockB", 3600L);
        DefaultTransaction t1 = new DefaultTransaction();
        DefaultTransaction t2 = new DefaultTransaction();
        FeatureLocking road1 = (FeatureLocking)((Object)this.data.getFeatureSource("ROAD"));
        FeatureLocking road2 = (FeatureLocking)((Object)this.data.getFeatureSource("ROAD"));
        road1.setTransaction(t1);
        road2.setTransaction(t2);
        road1.setFeatureLock(lockA);
        road2.setFeatureLock(lockB);
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[1].getID()));
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[2].getID()));
        road1.lockFeatures(this.rd1Filter);
        AbstractDataStoreTest.assertTrue((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[1].getID()));
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[2].getID()));
        road2.lockFeatures(this.rd2Filter);
        AbstractDataStoreTest.assertTrue((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
        AbstractDataStoreTest.assertTrue((boolean)this.isLocked("ROAD", this.roadFeatures[1].getID()));
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[2].getID()));
        try {
            road1.unLockFeatures(this.rd1Filter);
            AbstractDataStoreTest.fail((String)"need authorization");
        }
        catch (IOException expected) {
            // empty catch block
        }
        t1.addAuthorization(lockA.getAuthorization());
        try {
            road1.unLockFeatures(this.rd2Filter);
            AbstractDataStoreTest.fail((String)"need correct authorization");
        }
        catch (IOException expected) {
            // empty catch block
        }
        road1.unLockFeatures(this.rd1Filter);
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
        AbstractDataStoreTest.assertTrue((boolean)this.isLocked("ROAD", this.roadFeatures[1].getID()));
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[2].getID()));
        t2.addAuthorization(lockB.getAuthorization());
        road2.unLockFeatures(this.rd2Filter);
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[1].getID()));
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[2].getID()));
    }

    public void testGetFeatureLockingExpire() throws Exception {
        FeatureLock lock = FeatureLockFactory.generate("Timed", 1L);
        FeatureLocking road = (FeatureLocking)((Object)this.data.getFeatureSource("ROAD"));
        road.setFeatureLock(lock);
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
        road.lockFeatures(this.rd1Filter);
        AbstractDataStoreTest.assertTrue((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
        Thread.sleep(50L);
        AbstractDataStoreTest.assertFalse((boolean)this.isLocked("ROAD", this.roadFeatures[0].getID()));
    }

    public void testCreateSchema() throws Exception {
        String typename = "NewType";
        SimpleFeatureType t = DataUtilities.createType(typename, "*geom:Geometry");
        this.data.createSchema(t);
        String[] names = this.data.getTypeNames();
        boolean foundNewType = false;
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equalsIgnoreCase(typename)) continue;
            foundNewType = true;
        }
        AbstractDataStoreTest.assertTrue((boolean)foundNewType);
    }
}

