/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.Checker;
import org.openstreetmap.josm.tools.I18n;

public class NodeChecker
extends Checker {
    protected NodeChecker(Node node, Test test) {
        super(node, test);
    }

    protected void performSolitaryStopPositionTest() {
        List referrers = this.node.getReferrers();
        for (OsmPrimitive referrer : referrers) {
            Way referrerWay;
            if (!referrer.getType().equals((Object)OsmPrimitiveType.WAY) || !RouteUtils.isWaySuitableForBuses(referrerWay = (Way)referrer) && !referrerWay.hasTag("railway", "tram") && !referrerWay.hasTag("railway", "subway") && !referrerWay.hasTag("raiilway", "subway") && !referrerWay.hasTag("railway", "light_rail") && !referrerWay.hasTag("railway", "construction")) continue;
            return;
        }
        ArrayList<Node> primitives = new ArrayList<Node>(1);
        primitives.add(this.node);
        TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Stop_position is not part of a way", (Object[])new Object[0]), 3751, primitives);
        this.errors.add(e);
    }

    protected void performPlatformPartOfWayTest() {
        List referrers = this.node.getReferrers();
        for (OsmPrimitive referrer : referrers) {
            ArrayList<Node> primitives = new ArrayList<Node>(1);
            primitives.add(this.node);
            if (!referrer.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
            TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Platform should not be part of a way", (Object[])new Object[0]), 3752, primitives);
            this.errors.add(e);
            return;
        }
    }
}

