/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteDataManager;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteSegment;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTWay;
import org.openstreetmap.josm.plugins.pt_assistant.utils.StopToWayAssigner;
import org.openstreetmap.josm.plugins.pt_assistant.validation.Checker;
import org.openstreetmap.josm.tools.I18n;

public class SegmentChecker
extends Checker {
    private static List<PTRouteSegment> correctSegments = new ArrayList<PTRouteSegment>();
    private PTRouteDataManager manager;
    private StopToWayAssigner assigner;

    public SegmentChecker(Relation relation, Test test) {
        super(relation, test);
        this.manager = new PTRouteDataManager(relation);
        for (RelationMember rm : this.manager.getFailedMembers()) {
            ArrayList<Relation> primitives = new ArrayList<Relation>(1);
            primitives.add(relation);
            ArrayList<OsmPrimitive> highlighted = new ArrayList<OsmPrimitive>(1);
            highlighted.add(rm.getMember());
            TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Relation member roles do not match tags", (Object[])new Object[0]), 3743, primitives, highlighted);
            this.errors.add(e);
        }
        this.assigner = new StopToWayAssigner(this.manager.getPTWays());
    }

    public void performFirstStopTest() {
        this.performEndStopTest(this.manager.getFirstStop());
    }

    public void performLastStopTest() {
        this.performEndStopTest(this.manager.getLastStop());
    }

    private void performEndStopTest(PTStop endStop) {
        if (endStop == null) {
            return;
        }
        if (endStop.getStopPosition() == null) {
            ArrayList<Object> highlighted;
            ArrayList<Relation> primitives;
            List<Node> potentialStopPositionList = endStop.findPotentialStopPositions();
            ArrayList<Node> stopPositionsOfThisRoute = new ArrayList<Node>();
            boolean containsAtLeastOneStopPositionAsFirstOrLastNode = false;
            for (Node potentialStopPosition : potentialStopPositionList) {
                int belongsToWay = this.belongsToAWayOfThisRoute(potentialStopPosition);
                if (belongsToWay == 0) {
                    stopPositionsOfThisRoute.add(potentialStopPosition);
                    containsAtLeastOneStopPositionAsFirstOrLastNode = true;
                }
                if (belongsToWay != 1) continue;
                stopPositionsOfThisRoute.add(potentialStopPosition);
            }
            if (stopPositionsOfThisRoute.isEmpty()) {
                primitives = new ArrayList<Relation>(1);
                primitives.add(this.relation);
                highlighted = new ArrayList<Object>(1);
                highlighted.add(endStop.getPlatform());
                TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Route should start and end with a stop_position", (Object[])new Object[0]), 3741, primitives, highlighted);
                this.errors.add(e);
                return;
            }
            if (stopPositionsOfThisRoute.size() == 1) {
                endStop.setStopPosition((Node)stopPositionsOfThisRoute.get(0));
            }
            if (!containsAtLeastOneStopPositionAsFirstOrLastNode) {
                primitives = new ArrayList(1);
                primitives.add(this.relation);
                highlighted = new ArrayList();
                highlighted.addAll(stopPositionsOfThisRoute);
                TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: First or last way needs to be split", (Object[])new Object[0]), 3742, primitives, highlighted);
                this.errors.add(e);
            }
        } else {
            int belongsToWay = this.belongsToAWayOfThisRoute(endStop.getStopPosition());
            if (belongsToWay == 1) {
                ArrayList<Relation> primitives = new ArrayList<Relation>(1);
                primitives.add(this.relation);
                ArrayList<Node> highlighted = new ArrayList<Node>();
                highlighted.add(endStop.getStopPosition());
                TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: First or last way needs to be split", (Object[])new Object[0]), 3742, primitives, highlighted);
                this.errors.add(e);
            }
        }
    }

    private void performSegmentTest() {
    }

    private int belongsToAWayOfThisRoute(Node node) {
        boolean contains = false;
        List<PTWay> ptways = this.manager.getPTWays();
        for (PTWay ptway : ptways) {
            List<Way> ways = ptway.getWays();
            for (Way way : ways) {
                if (!way.containsNode(node)) continue;
                if (way.firstNode().equals((Object)node) || way.lastNode().equals((Object)node)) {
                    return 0;
                }
                contains = true;
            }
        }
        if (contains) {
            return 1;
        }
        return -1;
    }
}

