/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Predicates;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class WikipediaApp {
    public static Pattern WIKIDATA_PATTERN = Pattern.compile("Q\\d+");
    private static final DocumentBuilder DOCUMENT_BUILDER = WikipediaApp.newDocumentBuilder();
    private static final XPath X_PATH = XPathFactory.newInstance().newXPath();

    private WikipediaApp() {
    }

    static String getMediawikiLocale(Locale locale) {
        if (!locale.getCountry().isEmpty()) {
            return locale.getLanguage() + "-" + locale.getCountry().toLowerCase();
        }
        return locale.getLanguage();
    }

    static String getSiteUrl(String wikipediaLang) {
        if ("wikidata".equals(wikipediaLang)) {
            return "https://www.wikidata.org";
        }
        return "https://" + wikipediaLang + ".wikipedia.org";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<WikipediaEntry> getEntriesFromCoordinates(String wikipediaLang, LatLon min, LatLon max) {
        try {
            String url = WikipediaApp.getSiteUrl(wikipediaLang) + "/w/api.php" + "?action=query" + "&list=geosearch" + "&format=xml" + "&gslimit=500" + "&gsbbox=" + max.lat() + "|" + min.lon() + "|" + min.lat() + "|" + max.lon();
            XPathExpression xpathPlacemark = X_PATH.compile("//gs");
            XPathExpression xpathName = X_PATH.compile("@title");
            XPathExpression xpathLat = X_PATH.compile("@lat");
            XPathExpression xpathLon = X_PATH.compile("@lon");
            try (InputStream in = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContent();){
                Document doc = DOCUMENT_BUILDER.parse(in);
                NodeList nodes = (NodeList)xpathPlacemark.evaluate(doc, XPathConstants.NODESET);
                ArrayList<String> names = new ArrayList<String>(nodes.getLength());
                ArrayList<WikipediaEntry> entries = new ArrayList<WikipediaEntry>(nodes.getLength());
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String string = xpathName.evaluate(node);
                    names.add(string);
                    LatLon latLon = new LatLon(((Double)xpathLat.evaluate(node, XPathConstants.NUMBER)).doubleValue(), ((Double)xpathLon.evaluate(node, XPathConstants.NUMBER)).doubleValue());
                    if ("wikidata".equals(wikipediaLang)) {
                        entries.add(new WikidataEntry(string, latLon, null));
                        continue;
                    }
                    entries.add(new WikipediaEntry(string, wikipediaLang, string, latLon));
                }
                if ("wikidata".equals(wikipediaLang)) {
                    HashMap<String, String> labels = new HashMap<String, String>();
                    for (List<String> list : WikipediaApp.partitionList(names, 50)) {
                        labels.putAll(WikipediaApp.getLabelForWikidata(list, Locale.getDefault(), new String[0]));
                    }
                    ArrayList<WikipediaEntry> entriesWithLabel = new ArrayList<WikipediaEntry>(nodes.getLength());
                    Iterator iterator = entries.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            ArrayList<WikipediaEntry> arrayList = entriesWithLabel;
                            return arrayList;
                        }
                        WikipediaEntry entry = (WikipediaEntry)iterator.next();
                        entriesWithLabel.add(new WikidataEntry(entry.wikipediaArticle, entry.coordinate, (String)labels.get(entry.wikipediaArticle)));
                    }
                }
                ArrayList<WikipediaEntry> arrayList = entries;
                return arrayList;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<WikipediaEntry> getEntriesFromCategory(String wikipediaLang, String category, int depth) {
        try {
            String url = "https://tools.wmflabs.org/cats-php/?lang=" + wikipediaLang + "&depth=" + depth + "&cat=" + Utils.encodeUrl((String)category);
            try (Scanner scanner = new Scanner(HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContentReader()).useDelimiter("\n");){
                ArrayList<WikipediaEntry> entries = new ArrayList<WikipediaEntry>();
                while (scanner.hasNext()) {
                    String article = scanner.next().trim().replace("_", " ");
                    entries.add(new WikipediaEntry(article, wikipediaLang, article));
                }
                ArrayList<WikipediaEntry> arrayList = entries;
                return arrayList;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static List<WikipediaEntry> getEntriesFromClipboard(final String wikipediaLang) {
        List<String> clipboardLines = Arrays.asList(Utils.getClipboardContent().split("[\\n\\r]+"));
        return new ArrayList<WikipediaEntry>(Utils.transform(clipboardLines, (Utils.Function)new Utils.Function<String, WikipediaEntry>(){

            public WikipediaEntry apply(String x) {
                return new WikipediaEntry(x, wikipediaLang, x);
            }
        }));
    }

    static void updateWIWOSMStatus(String wikipediaLang, Collection<WikipediaEntry> entries) {
        ArrayList<String> articleNames = new ArrayList<String>();
        for (WikipediaEntry i : entries) {
            articleNames.add(i.wikipediaArticle);
        }
        HashMap<String, Boolean> status = new HashMap<String, Boolean>();
        if (!articleNames.isEmpty()) {
            String url = "https://tools.wmflabs.org/wiwosm/osmjson/getGeoJSON.php?action=check&lang=" + wikipediaLang;
            try {
                String requestBody = "articles=" + Utils.encodeUrl((String)Utils.join((String)",", articleNames));
                try (Scanner scanner = new Scanner(HttpClient.create((URL)new URL(url), (String)"POST").setReasonForRequest("Wikipedia").setHeader("Content-Type", "application/x-www-form-urlencoded").setRequestBody(requestBody.getBytes(StandardCharsets.UTF_8)).connect().getContentReader()).useDelimiter("\n");){
                    while (scanner.hasNext()) {
                        String line = scanner.next();
                        String[] x = line.split("\t");
                        if (x.length == 2) {
                            status.put(x[0], "1".equals(x[1]));
                            continue;
                        }
                        Main.error((String)("Unknown element " + line));
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        for (WikipediaEntry i : entries) {
            i.setWiwosmStatus((Boolean)status.get(i.wikipediaArticle));
        }
    }

    static Collection<String> getWikipediaArticles(final String wikipediaLang, OsmPrimitive p) {
        if ("wikidata".equals(wikipediaLang)) {
            return Utils.filter(Collections.singleton(p.get("wikidata")), (Predicate)Predicates.not((Predicate)Predicates.isNull()));
        }
        TagMap tags = p.getKeys();
        return Utils.transform((Collection)Utils.filter(Arrays.asList(WikipediaLangArticle.parseTag("wikipedia", (String)tags.get("wikipedia")), WikipediaLangArticle.parseTag("wikipedia:" + wikipediaLang, (String)tags.get("wikipedia:" + wikipediaLang))), (Predicate)new Predicate<WikipediaLangArticle>(){

            public boolean evaluate(WikipediaLangArticle wp) {
                return wp != null && wikipediaLang.equals(wp.lang);
            }
        }), (Utils.Function)new Utils.Function<WikipediaLangArticle, String>(){

            public String apply(WikipediaLangArticle wp) {
                return wp.article;
            }
        });
    }

    static Map<String, String> getWikidataForArticles(String wikipediaLang, Collection<String> articles) {
        try {
            String url = "https://www.wikidata.org/w/api.php?action=wbgetentities&props=sitelinks&sites=" + wikipediaLang + "wiki" + "&sitefilter=" + wikipediaLang + "wiki" + "&format=xml" + "&titles=" + Utils.join((String)"|", (Collection)Utils.transform(articles, (Utils.Function)new Utils.Function<String, String>(){

                public String apply(String x) {
                    return Utils.encodeUrl((String)x);
                }
            }));
            TreeMap<String, String> r = new TreeMap<String, String>();
            try (InputStream in = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContent();){
                Document xml = DOCUMENT_BUILDER.parse(in);
                NodeList nodes = (NodeList)X_PATH.compile("//entity").evaluate(xml, XPathConstants.NODESET);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String wikidata = (String)X_PATH.compile("./@id").evaluate(node, XPathConstants.STRING);
                    String wikipedia = (String)X_PATH.compile("./sitelinks/sitelink/@title").evaluate(node, XPathConstants.STRING);
                    r.put(wikipedia, wikidata);
                }
            }
            return r;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static String getLabelForWikidata(String wikidataId, Locale locale, String ... preferredLanguage) {
        return WikipediaApp.getLabelForWikidata(Collections.singleton(wikidataId), locale, preferredLanguage).get(wikidataId);
    }

    static Map<String, String> getLabelForWikidata(Collection<String> wikidataIds, Locale locale, String ... preferredLanguage) {
        try {
            for (String wikidataId : wikidataIds) {
                WikipediaApp.ensureValidWikidataId(wikidataId);
            }
            String url = "https://www.wikidata.org/w/api.php?action=wbgetentities&props=labels&ids=" + Utils.join((String)"|", wikidataIds) + "&format=xml";
            ArrayList<String> languages = new ArrayList<String>();
            if (locale != null) {
                languages.add(WikipediaApp.getMediawikiLocale(locale));
                languages.add(WikipediaApp.getMediawikiLocale(new Locale(locale.getLanguage())));
            }
            languages.addAll(Arrays.asList(preferredLanguage));
            languages.add("en");
            languages.add(null);
            HashMap<String, String> r = new HashMap<String, String>();
            try (InputStream in = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContent();){
                Document xml = DOCUMENT_BUILDER.parse(in);
                block12: for (String wikidataId : wikidataIds) {
                    Node entity = (Node)X_PATH.compile("//entity[@id='" + wikidataId + "']").evaluate(xml, XPathConstants.NODE);
                    for (String language : languages) {
                        String label = (String)X_PATH.compile(language != null ? "./labels/label[@language='" + language + "']/@value" : "./labels/label/@value").evaluate(entity, XPathConstants.STRING);
                        if (label == null || label.isEmpty()) continue;
                        r.put(wikidataId, label);
                        continue block12;
                    }
                }
            }
            return r;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static Collection<WikipediaLangArticle> getInterwikiArticles(String wikipediaLang, String article) {
        try {
            ArrayList<WikipediaLangArticle> r = new ArrayList<WikipediaLangArticle>();
            String url = WikipediaApp.getSiteUrl(wikipediaLang) + "/w/api.php" + "?action=query" + "&prop=langlinks" + "&titles=" + Utils.encodeUrl((String)article) + "&lllimit=500" + "&format=xml";
            try (InputStream in = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContent();){
                Document xml = DOCUMENT_BUILDER.parse(in);
                NodeList nodes = (NodeList)X_PATH.compile("//ll").evaluate(xml, XPathConstants.NODESET);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String lang = nodes.item(i).getAttributes().getNamedItem("lang").getTextContent();
                    String name = nodes.item(i).getTextContent();
                    r.add(new WikipediaLangArticle(lang, name));
                }
            }
            return r;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LatLon getCoordinateForArticle(String wikipediaLang, String article) {
        try {
            String url = WikipediaApp.getSiteUrl(wikipediaLang) + "/w/api.php" + "?action=query" + "&prop=coordinates" + "&titles=" + Utils.encodeUrl((String)article) + "&format=xml";
            try (InputStream in = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContent();){
                Document xml = DOCUMENT_BUILDER.parse(in);
                Node node = (Node)X_PATH.compile("//coordinates/co").evaluate(xml, XPathConstants.NODE);
                if (node == null) {
                    LatLon latLon = null;
                    return latLon;
                }
                double lat = Double.parseDouble(node.getAttributes().getNamedItem("lat").getTextContent());
                double lon = Double.parseDouble(node.getAttributes().getNamedItem("lon").getTextContent());
                LatLon latLon = new LatLon(lat, lon);
                return latLon;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static void ensureValidWikidataId(String id) {
        CheckParameterUtil.ensureThat((boolean)WIKIDATA_PATTERN.matcher(id).matches(), (String)("Invalid Wikidata ID given: " + id));
    }

    public static <T> List<List<T>> partitionList(final List<T> list, final int size) {
        return new AbstractList<List<T>>(){

            @Override
            public List<T> get(int index) {
                int fromIndex = index * size;
                int toIndex = Math.min(fromIndex + size, list.size());
                return list.subList(fromIndex, toIndex);
            }

            @Override
            public int size() {
                return (int)Math.ceil((float)list.size() / (float)size);
            }
        };
    }

    private static DocumentBuilder newDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Main.warn((String)"Cannot create DocumentBuilder");
            Main.warn((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static class WikidataEntry
    extends WikipediaEntry {
        WikidataEntry(String id, LatLon coordinate, String label) {
            super(label, "wikidata", id, coordinate);
            WikipediaApp.ensureValidWikidataId(id);
        }

        @Override
        protected Tag createWikipediaTag() {
            return new Tag("wikidata", this.wikipediaArticle);
        }

        @Override
        public String getLabelText() {
            return WikidataEntry.getLabelText(this.name, this.wikipediaArticle);
        }

        static String getLabelText(String bold, String gray) {
            return Utils.escapeReservedCharactersHTML((String)bold) + " <span color='gray'>" + Utils.escapeReservedCharactersHTML((String)gray) + "</span>";
        }
    }

    static class WikipediaEntry
    implements Comparable<WikipediaEntry> {
        final String name;
        final String wikipediaLang;
        final String wikipediaArticle;
        final LatLon coordinate;
        private Boolean wiwosmStatus;

        public WikipediaEntry(String name, String wikipediaLang, String wikipediaArticle) {
            this(name, wikipediaLang, wikipediaArticle, null);
        }

        public WikipediaEntry(String name, String wikipediaLang, String wikipediaArticle, LatLon coordinate) {
            this.name = name;
            this.wikipediaLang = wikipediaLang;
            this.wikipediaArticle = wikipediaArticle;
            this.coordinate = coordinate;
        }

        protected Tag createWikipediaTag() {
            return new Tag("wikipedia", this.wikipediaLang + ":" + this.wikipediaArticle);
        }

        public void setWiwosmStatus(Boolean wiwosmStatus) {
            this.wiwosmStatus = wiwosmStatus;
        }

        public Boolean getWiwosmStatus() {
            return this.wiwosmStatus;
        }

        public String getBrowserUrl() {
            return WikipediaApp.getSiteUrl(this.wikipediaLang) + "/wiki/" + Utils.encodeUrl((String)this.wikipediaArticle.replace(" ", "_"));
        }

        public String getLabelText() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(WikipediaEntry o) {
            return AlphanumComparator.getInstance().compare(this.name, o.name);
        }
    }

    static class WikipediaLangArticle {
        final String lang;
        final String article;

        public WikipediaLangArticle(String lang, String article) {
            this.lang = lang;
            this.article = article;
        }

        public static WikipediaLangArticle parseFromUrl(String url) {
            if (url == null) {
                return null;
            }
            url = Utils.decodeUrl((String)url);
            Matcher m = Pattern.compile("(https?:)?//(\\w*)\\.wikipedia\\.org/wiki/(.*)").matcher(url);
            if (!m.matches()) {
                return null;
            }
            return new WikipediaLangArticle(m.group(2), m.group(3));
        }

        public static WikipediaLangArticle parseTag(String key, String value) {
            if (value == null) {
                return null;
            }
            if (value.startsWith("http")) {
                return WikipediaLangArticle.parseFromUrl(value);
            }
            if (value.contains(":")) {
                String[] item = Utils.decodeUrl((String)value).split(":", 2);
                String article = item[1].replace("_", " ");
                return new WikipediaLangArticle(item[0], article);
            }
            if (key.startsWith("wikipedia:")) {
                String[] item;
                String lang = key.split(":", 2)[1];
                String article = item[(item = Utils.decodeUrl((String)value).split(":", 2)).length == 2 ? 1 : 0].replace("_", " ");
                return new WikipediaLangArticle(lang, article);
            }
            return null;
        }

        public String toString() {
            return this.lang + ":" + this.article;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WikipediaLangArticle that = (WikipediaLangArticle)o;
            return Objects.equals(this.lang, that.lang) && Objects.equals(this.article, that.article);
        }

        public int hashCode() {
            return Objects.hash(this.lang, this.article);
        }
    }
}

