/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanestagging.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.plugins.turnlanestagging.editor.TagEditorModel;
import org.openstreetmap.josm.plugins.turnlanestagging.editor.preset.AdvancedTag;
import org.openstreetmap.josm.tools.I18n;

public class TagTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BG_COLOR_HIGHLIGHTED = new Color(255, 255, 204);
    private Font fontStandard = this.getFont();
    private Font fontItalic = this.fontStandard.deriveFont(2);

    public TagTableCellRenderer() {
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    protected void renderTagName(TagModel tag) {
        this.setText(tag.getName());
    }

    protected void renderTagValue(TagModel tag) {
        if (tag.getValueCount() == 0) {
            this.setText("");
        } else if (tag.getValueCount() == 1) {
            this.setText((String)tag.getValues().get(0));
        } else if (tag.getValueCount() > 1) {
            this.setText(I18n.tr((String)"multiple", (Object[])new Object[0]));
            this.setFont(this.fontItalic);
        }
    }

    protected void resetRenderer() {
        this.setText("");
        this.setIcon(null);
        this.setFont(this.fontStandard);
    }

    protected TagEditorModel getModel(JTable table) {
        return (TagEditorModel)((Object)table.getModel());
    }

    protected boolean belongsToSelectedPreset(TagModel tagModel, TagEditorModel model) {
        if (tagModel.getName().trim().equals("") && tagModel.getValue().equals("")) {
            return false;
        }
        TaggingPreset item = (TaggingPreset)model.getAppliedPresetsModel().getSelectedItem();
        if (item == null) {
            return false;
        }
        for (AdvancedTag tag : AdvancedTag.forTaggingPreset(item)) {
            if (!(tag.getValue() == null ? tagModel.getName().equals(tag.getKey()) : tagModel.getName().equals(tag.getKey()) && tagModel.getValue().equals(tag.getValue()))) continue;
            return true;
        }
        return false;
    }

    protected void renderColor(TagModel tagModel, TagEditorModel model, boolean isSelected, boolean isvalTag) {
        if (isvalTag) {
            if (isSelected) {
                this.setBackground(new Color(247, 246, 225));
            } else {
                this.setBackground(new Color(247, 246, 225));
            }
        } else if (isSelected) {
            this.setBackground(UIManager.getColor("Table.selectionBackground"));
            this.setForeground(UIManager.getColor("Table.selectionForeground"));
        } else {
            this.setBackground(UIManager.getColor("Table.background"));
            this.setForeground(UIManager.getColor("Table.foreground"));
        }
        if (this.belongsToSelectedPreset(tagModel, model)) {
            this.setBackground(BG_COLOR_HIGHLIGHTED);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        this.resetRenderer();
        TagModel tagModel = (TagModel)value;
        switch (vColIndex) {
            case 0: {
                this.renderTagName(tagModel);
                break;
            }
            case 1: {
                this.renderTagValue(tagModel);
            }
        }
        String[] val_tags = new String[]{"lanes:backward", "turn:lanes:backward", "lanes:both_ways", "turn:lanes:both_ways", "lanes:forward", "turn:lanes:forward", "lanes", "turn:lanes"};
        if (Arrays.asList(val_tags).indexOf(tagModel.getName()) > -1) {
            this.renderColor(tagModel, (TagEditorModel)((Object)table.getModel()), isSelected, true);
            if (hasFocus && isSelected && table.getSelectedColumnCount() == 1 && table.getSelectedRowCount() == 1 && table.getEditorComponent() != null) {
                table.getEditorComponent().requestFocusInWindow();
            }
        } else {
            this.renderColor(tagModel, (TagEditorModel)((Object)table.getModel()), isSelected, false);
            if (hasFocus && isSelected && table.getSelectedColumnCount() == 1 && table.getSelectedRowCount() == 1 && table.getEditorComponent() != null) {
                table.getEditorComponent().requestFocusInWindow();
            }
        }
        return this;
    }
}

