/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml.elements;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLUtil;
import junit.extensions.xml.elements.AbstractTagHandler;
import org.w3c.dom.Element;

public class SaveTagHandler
extends AbstractTagHandler {
    public SaveTagHandler(Element element, IXMLTestCase testCase) {
        super(element, testCase);
    }

    public void processElement() throws XMLException {
        this.validateElement();
        File f = new File(this.getFileName());
        f.delete();
        try {
            f.createNewFile();
            FileOutputStream out = new FileOutputStream(f);
            XMLUtil.writeFile(this.getEncoding(), out, this.getElement().getOwnerDocument());
        }
        catch (IOException ex) {
            throw new XMLException("Could not write to file:" + f.getAbsolutePath(), (Throwable)ex, this.getElement(), this.getXMLTestCase().getPropertyCache());
        }
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkRequiredAttribute("file");
    }

    private String getEncoding() {
        String encoding = this.getString("encoding");
        if (encoding == null || encoding.trim().length() == 0) {
            return "UTF-8";
        }
        return encoding;
    }

    private String getFileName() {
        String file = this.getString("file").trim();
        if (file == null || file.length() == 0) {
            return null;
        }
        return file;
    }
}

