/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.swing.AbstractListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import junit.extensions.jfcunit.eventdata.JListMouseEventData;
import junit.extensions.jfcunit.eventdata.MouseEventData;
import junit.extensions.jfcunit.finder.ComponentFinder;
import org.w3c.dom.Element;

public class JComboBoxMouseEventData
extends AbstractMouseEventData {
    private JComboBox m_comboBox;
    private JList m_listView;
    private int m_elementIndex;
    static /* synthetic */ Class class$javax$swing$JButton;
    static /* synthetic */ Class class$javax$swing$event$ListDataListener;

    public JComboBoxMouseEventData() {
        this.setValid(false);
    }

    public JComboBoxMouseEventData(JFCTestCase testCase, JComboBox comboBox, Object element, int numberOfClicks) {
        this(testCase, comboBox, element, numberOfClicks, 300L);
    }

    public JComboBoxMouseEventData(JFCTestCase testCase, JComboBox comboBox, Object element, int numberOfClicks, long sleepTime) {
        this(testCase, comboBox, element, numberOfClicks, 16, false, sleepTime);
    }

    public JComboBoxMouseEventData(JFCTestCase testCase, JComboBox comboBox, Object element, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime) {
        this(testCase, comboBox, element, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 0, null);
    }

    public JComboBoxMouseEventData(JFCTestCase testCase, JComboBox comboBox, Object element, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, Point referencePoint) {
        this(testCase, comboBox, element, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 12, referencePoint);
    }

    public JComboBoxMouseEventData(JFCTestCase testCase, JComboBox comboBox, Object element, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position) {
        this(testCase, comboBox, element, numberOfClicks, modifiers, isPopupTrigger, sleepTime, position, null);
    }

    public JComboBoxMouseEventData(JFCTestCase testCase, JComboBox comboBox, Object element, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position, Point referencePoint) {
        this(testCase, comboBox, JComboBoxMouseEventData.getIndexOf(comboBox, element), numberOfClicks, modifiers, isPopupTrigger, sleepTime, position, referencePoint);
    }

    public JComboBoxMouseEventData(JFCTestCase testCase, JComboBox comboBox, int elementIndex, int numberOfClicks) {
        this(testCase, comboBox, elementIndex, numberOfClicks, 300L);
    }

    public JComboBoxMouseEventData(JFCTestCase testCase, JComboBox comboBox, int elementIndex, int numberOfClicks, long sleepTime) {
        this(testCase, comboBox, elementIndex, numberOfClicks, 16, false, sleepTime);
    }

    public JComboBoxMouseEventData(JFCTestCase testCase, JComboBox comboBox, int elementIndex, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime) {
        this(testCase, comboBox, elementIndex, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 0, (Point)null);
    }

    public JComboBoxMouseEventData(JFCTestCase testCase, JComboBox comboBox, int elementIndex, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, Point referencePoint) {
        this(testCase, comboBox, elementIndex, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 12, referencePoint);
    }

    public JComboBoxMouseEventData(JFCTestCase testCase, JComboBox comboBox, int elementIndex, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position) {
        this(testCase, comboBox, elementIndex, numberOfClicks, modifiers, isPopupTrigger, sleepTime, position, (Point)null);
    }

    public JComboBoxMouseEventData(JFCTestCase testCase, JComboBox comboBox, int elementIndex, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position, Point referencePoint) {
        this.setTestCase(testCase);
        this.setSource(comboBox);
        this.setNumberOfClicks(numberOfClicks);
        this.setModifiers(modifiers);
        this.setPopupTrigger(isPopupTrigger);
        this.setElementIndex(elementIndex);
        this.setSleepTime(sleepTime);
        this.setPosition(position);
        this.setReferencePoint(referencePoint);
        this.setValid(true);
    }

    public final void setSource(JComboBox comboBox) {
        this.m_comboBox = comboBox;
    }

    public final JComboBox getSource() {
        return this.m_comboBox;
    }

    public Component getComponent() {
        if (this.m_listView == null) {
            return this.getSource();
        }
        return this.m_listView;
    }

    public final void setElementIndex(int elementIndex) {
        this.m_elementIndex = elementIndex;
    }

    public int getElementIndex() {
        return this.m_elementIndex;
    }

    public boolean canConsume(AWTEvent ae) {
        JList source;
        int index;
        if (!super.canConsume(ae) || !(ae.getSource() instanceof JList)) {
            return false;
        }
        if (this.isValid() && (index = (source = (JList)ae.getSource()).locationToIndex(new Point(((MouseEvent)ae).getX(), ((MouseEvent)ae).getY()))) != this.getElementIndex()) {
            return false;
        }
        return this.isComboBox((JList)ae.getSource());
    }

    public boolean consume(AWTEvent ae) {
        if (super.consume(ae)) {
            return true;
        }
        MouseEvent me = (MouseEvent)ae;
        JList source = (JList)me.getSource();
        this.setSource(this.getParentComboBox(source));
        this.setModifiers(me.getModifiers());
        this.setNumberOfClicks(me.getClickCount());
        this.setPopupTrigger(me.isPopupTrigger());
        Point p = new Point(me.getX(), me.getY());
        Point screen = source.getLocationOnScreen();
        screen.translate(p.x, p.y);
        this.setLocationOnScreen(screen);
        this.setSleepTime(this.getDefaultSleepTime());
        int index = source.locationToIndex(new Point(me.getX(), me.getY()));
        this.setElementIndex(index);
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setValid(true);
        return true;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        JComboBoxMouseEventData data = (JComboBoxMouseEventData)o;
        return data.getSource() == this.getSource() && data.getElementIndex() == this.getElementIndex();
    }

    public int hashCode() {
        return super.hashCode() + this.m_elementIndex;
    }

    public void populate(Element e) {
        super.populate(e);
        e.setAttribute("type", "JComboBoxMouseEventData");
        e.setAttribute("index", "" + this.getElementIndex());
    }

    public boolean prepareComponent() {
        if (!this.isValidForProcessing(this.getSource())) {
            return false;
        }
        JFCTestCase testCase = this.getTestCase();
        if (testCase != null) {
            testCase.flushAWT();
        }
        JComboBox toClick = this.m_comboBox;
        int clicks = 1;
        if (this.m_comboBox.isEditable()) {
            ComponentFinder f = new ComponentFinder(class$javax$swing$JButton == null ? (class$javax$swing$JButton = JComboBoxMouseEventData.class$("javax.swing.JButton")) : class$javax$swing$JButton);
            f.setWait(0);
            Component comp = f.find(this.m_comboBox, 0);
            if (comp != null) {
                MouseEventData data = new MouseEventData(testCase, comp);
                testCase.getHelper().enterClickAndLeave(data);
            } else {
                Rectangle e = this.m_comboBox.getEditor().getEditorComponent().getBounds();
                Rectangle cb = this.m_comboBox.getBounds();
                Rectangle button = this.calcButtonArea(e, cb);
                Point p = new Point((int)button.getCenterX(), (int)button.getCenterY());
                MouseEventData data = new MouseEventData(testCase, toClick);
                data.setPosition(12);
                data.setReferencePoint(p);
                testCase.getHelper().enterClickAndLeave(data);
            }
        } else {
            testCase.getHelper().enterClickAndLeave(new MouseEventData(testCase, (Component)toClick, clicks));
        }
        if (!this.m_comboBox.isPopupVisible()) {
            return false;
        }
        if (testCase != null) {
            testCase.flushAWT();
        }
        BasicComboPopup bcp = (BasicComboPopup)this.m_comboBox.getAccessibleContext().getAccessibleChild(0);
        if (testCase != null) {
            testCase.flushAWT();
        }
        this.m_listView = bcp.getList();
        testCase.getHelper().enterClickAndLeave(new JListMouseEventData(testCase, this.m_listView, this.m_elementIndex, 1));
        return false;
    }

    private Rectangle calcButtonArea(Rectangle comboBox, Rectangle editor) {
        return new Rectangle(editor.x + editor.width, editor.y, comboBox.width - editor.width, editor.height);
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString();
        }
        StringBuffer buf = new StringBuffer(1000);
        buf.append(super.toString());
        buf.append(" index: " + this.getElementIndex());
        return buf.toString();
    }

    private boolean isComboBox(JList list) {
        Accessible ap = list.getAccessibleContext().getAccessibleParent();
        while (ap != null) {
            if (ap instanceof ComboBoxUI || ap instanceof JComboBox || ap.getClass().getName().indexOf("ComboBoxUI") != -1) {
                return true;
            }
            ap = ap.getAccessibleContext().getAccessibleParent();
        }
        return false;
    }

    private static int getIndexOf(JComboBox comboBox, Object element) {
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            if (comboBox.getItemAt(i) == null || !comboBox.getItemAt(i).equals(element)) continue;
            return i;
        }
        return -1;
    }

    private JComboBox getParentComboBox(JList list) {
        ListModel ldm = list.getModel();
        if (ldm instanceof AbstractListModel) {
            AbstractListModel cbm = (AbstractListModel)ldm;
            EventListener[] listeners = cbm.getListeners(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = JComboBoxMouseEventData.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener);
            for (int i = 0; i < listeners.length; ++i) {
                if (!(listeners[i] instanceof JComboBox)) continue;
                return (JComboBox)listeners[i];
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

