/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml.elements;

import javax.swing.JTable;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import junit.framework.Assert;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.w3c.dom.Element;

public class AssertTableContainsTagHandler
extends AbstractTagHandler {
    public AssertTableContainsTagHandler(Element element, IXMLTestCase testcase) {
        super(element, testcase);
    }

    public int getColumn(JTable table) {
        String col = this.getString("column");
        try {
            int i = Integer.parseInt(col);
            return i;
        }
        catch (NumberFormatException e) {
            return this.getColumnIndex(col, table);
        }
    }

    public void processElement() throws XMLException {
        this.validateElement();
        String id = this.getString("id");
        Object o = ((IXMLTestCase)this.getTestCase()).getProperty(id);
        if (o == null) {
            Assert.fail((String)("Error: Unable to locate object id:" + id));
        } else if (o instanceof JTable) {
            boolean useRegExp;
            String expectedval = this.getString("value");
            JTable table = (JTable)o;
            int row = this.getInt("row", -1);
            Assert.assertTrue((row != -1 ? 1 : 0) != 0);
            Assert.assertTrue((row < table.getRowCount() ? 1 : 0) != 0);
            int col = this.getColumn(table);
            Assert.assertTrue((col != -1 ? 1 : 0) != 0);
            Assert.assertTrue((row < table.getRowCount() ? 1 : 0) != 0);
            String tableval = table.getValueAt(row, col).toString();
            String msg = "table contains[" + row + "," + col + "] Component: " + id + " Expected: " + expectedval + " Retrieved: " + tableval;
            if (this.getXMLTestCase().getDebug()) {
                System.out.println("msg: " + msg);
            }
            if (useRegExp = this.getBoolean("useRE")) {
                RE regexp = null;
                try {
                    regexp = new RE(expectedval);
                }
                catch (RESyntaxException ex) {
                    throw new XMLException("Could not create regular expression:" + expectedval, (Throwable)ex, this.getElement(), this.getXMLTestCase().getPropertyCache());
                }
                Assert.assertTrue((String)msg, (boolean)regexp.match(tableval));
            } else {
                if (!tableval.equals(expectedval)) {
                    System.out.println("Assertion failed: " + msg);
                }
                Assert.assertEquals((String)expectedval, (String)tableval);
            }
        }
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkRequiredAttribute("id");
        this.checkRequiredAttribute("row");
        this.checkRequiredAttribute("column");
        this.checkRequiredAttribute("value");
    }

    private int getColumnIndex(String columnName, JTable table) {
        int count = table.getColumnCount();
        for (int index = 0; index < count; ++index) {
            if (!columnName.equals(table.getColumnName(index))) continue;
            return index;
        }
        return -1;
    }
}

