/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.util.StringTokenizer;
import javax.swing.JComponent;
import junit.extensions.jfcunit.eventdata.BaseEventDataTagHandler;
import junit.extensions.jfcunit.eventdata.JMenuMouseEventData;
import junit.extensions.jfcunit.eventdata.PathData;
import junit.extensions.jfcunit.eventdata.PathTagHandler;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import org.w3c.dom.Element;

public class JMenuMouseEventDataTagHandler
extends BaseEventDataTagHandler {
    public JMenuMouseEventDataTagHandler(Element element, IXMLTestCase testCase) {
        super(element, testCase);
    }

    public void processElement() throws XMLException {
        this.validateElement();
        JComponent mb = (JComponent)this.getComponent();
        int[] indexes = this.getIndexes();
        if (indexes == null) {
            String path = this.getPath();
            if (path != null) {
                PathTagHandler pdth = new PathTagHandler(this.getElement(), this.getXMLTestCase());
                PathData pd = pdth.getPathData();
                indexes = pd.getIndexes(mb);
            } else {
                String pathName = this.getPathRefid();
                PathData pd = (PathData)this.getXMLTestCase().getProperty(pathName);
                indexes = pd.getIndexes(mb);
            }
        }
        this.setEventData(new JMenuMouseEventData(this.getJFCTestCase(), mb, indexes, this.getClicks(), this.getModifiers(), this.getPopupTrigger(), this.getSleepTime()));
    }

    public void validateElement() throws XMLException {
        super.validateElement();
    }

    private int[] getIndexes() {
        String data = this.getString("indexes");
        if (data == null) {
            return null;
        }
        String delimiter = this.getString("delimiter");
        if (delimiter == null) {
            delimiter = ",";
        }
        StringTokenizer tok = new StringTokenizer(data, delimiter);
        int[] indexes = new int[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            indexes[i++] = Integer.parseInt(token);
        }
        return indexes;
    }

    private String getPath() {
        return this.getString("path");
    }

    private String getPathRefid() {
        return this.getString("pathrefid");
    }
}

