/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;

public abstract class Checker {
    protected final Test test;
    protected Relation relation;
    protected ArrayList<TestError> errors = new ArrayList();

    protected Checker(Relation relation, Test test) {
        this.relation = relation;
        this.test = test;
    }

    public List<TestError> getErrors() {
        return this.errors;
    }

    protected static List<RelationMember> listStopMembers(Relation r) {
        ArrayList<RelationMember> resultList = new ArrayList<RelationMember>();
        for (RelationMember rm : r.getMembers()) {
            RelationMember newMember;
            if (!RouteUtils.isPTStop(rm)) continue;
            if (rm.getMember().hasTag("public_transport", "stop_position")) {
                if (!(rm.hasRole(new String[]{"stop"}) || rm.hasRole(new String[]{"stop_entry_only"}) || rm.hasRole(new String[]{"stop_exit_only"}))) {
                    newMember = new RelationMember("stop", rm.getMember());
                    resultList.add(newMember);
                    continue;
                }
                resultList.add(rm);
                continue;
            }
            if (!(rm.hasRole(new String[]{"platform"}) || rm.hasRole(new String[]{"platform_entry_only"}) || rm.hasRole(new String[]{"platform_exit_only"}))) {
                newMember = new RelationMember("platform", rm.getMember());
                resultList.add(newMember);
                continue;
            }
            resultList.add(rm);
        }
        return resultList;
    }

    protected static List<RelationMember> listNotStopMembers(Relation r) {
        ArrayList<RelationMember> resultList = new ArrayList<RelationMember>();
        for (RelationMember rm : r.getMembers()) {
            if (RouteUtils.isPTStop(rm)) continue;
            if (rm.hasRole(new String[]{"forward"}) || rm.hasRole(new String[]{"backward"})) {
                RelationMember newMember = new RelationMember("", rm.getMember());
                resultList.add(newMember);
                continue;
            }
            resultList.add(rm);
        }
        return resultList;
    }
}

