/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SelectCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.Checker;
import org.openstreetmap.josm.tools.I18n;

public class WayChecker
extends Checker {
    public WayChecker(Relation relation, Test test) {
        super(relation, test);
    }

    protected void performRoadTypeTest() {
        if (!(this.relation.hasTag("route", "bus") || this.relation.hasTag("route", "trolleybus") || this.relation.hasTag("route", "share_taxi"))) {
            return;
        }
        for (RelationMember rm : this.relation.getMembers()) {
            TestError e;
            ArrayList<Way> highlighted;
            ArrayList<Relation> primitives;
            if (!RouteUtils.isPTWay(rm) || !rm.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
            Way way = rm.getWay();
            boolean isCorrectRoadType = true;
            boolean isUnderConstruction = false;
            if (this.relation.hasTag("route", "bus") || this.relation.hasTag("route", "share_taxi")) {
                if (!this.isWaySuitableForBuses(way)) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("highway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "trolleybus")) {
                if (!this.isWaySuitableForBuses(way) || !way.hasTag("trolley_wire", "yes")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("highway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "tram")) {
                if (!way.hasTag("railway", "tram")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "subway")) {
                if (!this.relation.hasTag("railway", "subway")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "light_rail")) {
                if (!this.relation.hasTag("raiilway", "subway")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "light_rail")) {
                if (!this.relation.hasTag("railway", "light_rail")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "train")) {
                if (!this.relation.hasTag("railway", "train")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            }
            if (!isCorrectRoadType && !isUnderConstruction) {
                primitives = new ArrayList<Relation>(1);
                primitives.add(this.relation);
                highlighted = new ArrayList<Way>(1);
                highlighted.add(way);
                e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Route type does not match the type of the road it passes on", (Object[])new Object[0]), 3721, primitives, highlighted);
                this.errors.add(e);
            }
            if (!isUnderConstruction) continue;
            primitives = new ArrayList(1);
            primitives.add(this.relation);
            highlighted = new ArrayList(1);
            highlighted.add(way);
            e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Road is under construction", (Object[])new Object[0]), 3722, primitives, highlighted);
            this.errors.add(e);
        }
    }

    protected void performDirectionTest() {
        ArrayList<Way> waysToCheck = new ArrayList<Way>();
        for (RelationMember rm : this.relation.getMembers()) {
            if (!RouteUtils.isPTWay(rm)) continue;
            if (rm.isWay()) {
                waysToCheck.add(rm.getWay());
                continue;
            }
            Relation nestedRelation = rm.getRelation();
            for (RelationMember nestedRelationMember : nestedRelation.getMembers()) {
                waysToCheck.add(nestedRelationMember.getWay());
            }
        }
        if (waysToCheck.size() <= 1) {
            return;
        }
        ArrayList<Way> problematicWays = new ArrayList<Way>();
        for (int i = 0; i < waysToCheck.size(); ++i) {
            Way next;
            Way prev;
            Way curr = (Way)waysToCheck.get(i);
            if (i == 0) {
                Way next2 = (Way)waysToCheck.get(i + 1);
                if (this.touchCorrectly(null, curr, next2)) continue;
                problematicWays.add(curr);
                continue;
            }
            if (i == waysToCheck.size() - 1) {
                prev = (Way)waysToCheck.get(i - 1);
                if (this.touchCorrectly(prev, curr, null)) continue;
                problematicWays.add(curr);
                continue;
            }
            prev = (Way)waysToCheck.get(i - 1);
            if (this.touchCorrectly(prev, curr, next = (Way)waysToCheck.get(i + 1))) continue;
            problematicWays.add(curr);
        }
        for (Way problematicWay : problematicWays) {
            ArrayList<Relation> primitives = new ArrayList<Relation>(1);
            primitives.add(this.relation);
            ArrayList<Way> highlighted = new ArrayList<Way>(1);
            highlighted.add(problematicWay);
            TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Route passes a oneway road in the wrong direction", (Object[])new Object[0]), 3731, primitives, highlighted);
            this.errors.add(e);
        }
    }

    private boolean isWaySuitableForBuses(Way way) {
        if (way.hasTag("highway", "motorway") || way.hasTag("highway", "trunk") || way.hasTag("highway", "primary") || way.hasTag("highway", "secondary") || way.hasTag("highway", "tertiary") || way.hasTag("highway", "unclassified") || way.hasTag("highway", "road") || way.hasTag("highway", "residential") || way.hasTag("highway", "service") || way.hasTag("highway", "motorway_link") || way.hasTag("highway", "trunk_link") || way.hasTag("highway", "primary_link") || way.hasTag("highway", "secondary_link") || way.hasTag("highway", "tertiary_link") || way.hasTag("highway", "living_street") || way.hasTag("highway", "bus_guideway") || way.hasTag("highway", "road") || way.hasTag("cycleway", "share_busway") || way.hasTag("cycleway", "shared_lane")) {
            return true;
        }
        return way.hasTag("highway", "pedestrian") && (way.hasTag("bus", "yes") || way.hasTag("psv", "yes") || way.hasTag("bus", "designated") || way.hasTag("psv", "designated"));
    }

    protected static Command fixErrorByRemovingWay(TestError testError) {
        if (testError.getCode() != 3721 && testError.getCode() != 3731) {
            return null;
        }
        Collection primitives = testError.getPrimitives();
        Relation originalRelation = (Relation)primitives.iterator().next();
        Collection highlighted = testError.getHighlighted();
        Way wayToRemove = (Way)highlighted.iterator().next();
        Relation modifiedRelation = new Relation(originalRelation);
        ArrayList<RelationMember> modifiedRelationMembers = new ArrayList<RelationMember>(originalRelation.getMembersCount() - 1);
        for (RelationMember rm : originalRelation.getMembers()) {
            if (!RouteUtils.isPTStop(rm)) continue;
            if (rm.getRole().equals("stop_position")) {
                RelationMember newMember;
                if (rm.getType().equals((Object)OsmPrimitiveType.NODE)) {
                    newMember = new RelationMember("stop", (OsmPrimitive)rm.getNode());
                    modifiedRelationMembers.add(newMember);
                    continue;
                }
                newMember = new RelationMember("stop", (OsmPrimitive)rm.getWay());
                modifiedRelationMembers.add(newMember);
                continue;
            }
            modifiedRelationMembers.add(rm);
        }
        for (RelationMember rm : originalRelation.getMembers()) {
            Way wayToCheck;
            if (!RouteUtils.isPTWay(rm) || (wayToCheck = rm.getWay()) == wayToRemove) continue;
            if (rm.getRole().equals("forward") || rm.getRole().equals("backward")) {
                RelationMember modifiedMember = new RelationMember("", (OsmPrimitive)wayToCheck);
                modifiedRelationMembers.add(modifiedMember);
                continue;
            }
            modifiedRelationMembers.add(rm);
        }
        modifiedRelation.setMembers(modifiedRelationMembers);
        ChangeCommand changeCommand = new ChangeCommand((OsmPrimitive)originalRelation, (OsmPrimitive)modifiedRelation);
        return changeCommand;
    }

    protected static Command fixErrorByZooming(TestError testError) {
        if (testError.getCode() != 3731) {
            return null;
        }
        ArrayList<SelectCommand> commands = new ArrayList<SelectCommand>();
        Collection primitives = testError.getPrimitives();
        Relation originalRelation = (Relation)primitives.iterator().next();
        ArrayList<Relation> primitivesToSelect = new ArrayList<Relation>(1);
        primitivesToSelect.add(originalRelation);
        Collection highlighted = testError.getHighlighted();
        Way wayToHighlight = (Way)highlighted.iterator().next();
        ArrayList<OsmPrimitive> primitivesToZoom = new ArrayList<OsmPrimitive>(1);
        primitivesToZoom.add((OsmPrimitive)wayToHighlight);
        SelectCommand command1 = new SelectCommand(primitivesToSelect);
        commands.add(command1);
        SelectCommand command2 = new SelectCommand(primitivesToZoom);
        commands.add(command2);
        List listOfLayers = Main.getLayerManager().getLayersOfType(OsmDataLayer.class);
        for (OsmDataLayer osmDataLayer : listOfLayers) {
            if (osmDataLayer.data != originalRelation.getDataSet()) continue;
            final OsmDataLayer layerParameter = osmDataLayer;
            final Relation relationParameter = originalRelation;
            final ArrayList<OsmPrimitive> zoomParameter = primitivesToZoom;
            if (SwingUtilities.isEventDispatchThread()) {
                WayChecker.showRelationEditorAndZoom(layerParameter, relationParameter, zoomParameter);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WayChecker.showRelationEditorAndZoom(layerParameter, relationParameter, zoomParameter);
                    }
                });
            }
            return new SequenceCommand(null, commands);
        }
        return null;
    }

    private static void showRelationEditorAndZoom(OsmDataLayer layer, Relation r, Collection<OsmPrimitive> primitives) {
        AutoScaleAction.zoomTo(primitives);
        GenericRelationEditor editor = (GenericRelationEditor)RelationEditor.getEditor((OsmDataLayer)layer, (Relation)r, (Collection)r.getMembersFor(primitives));
        List<RelationMember> sortedRelationMembers = WayChecker.listStopMembers(r);
        sortedRelationMembers.addAll(WayChecker.listNotStopMembers(r));
        r.setMembers(sortedRelationMembers);
        editor.reloadDataFromRelation();
        editor.setVisible(true);
    }

    private boolean touchCorrectly(Way prev, Way curr, Way next) {
        Node nodeInQuestion;
        if (RouteUtils.isOnewayForPublicTransport(curr) == 0) {
            return true;
        }
        if (prev != null && RouteUtils.waysTouch(curr, prev) && (nodeInQuestion = RouteUtils.isOnewayForPublicTransport(curr) == 1 ? curr.firstNode() : curr.lastNode()) != prev.firstNode() && nodeInQuestion != prev.lastNode()) {
            return false;
        }
        return next == null || !RouteUtils.waysTouch(curr, next) || (nodeInQuestion = RouteUtils.isOnewayForPublicTransport(curr) == 1 ? curr.lastNode() : curr.firstNode()) == next.firstNode() || nodeInQuestion == next.lastNode();
    }
}

