/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class AddStopPositionAction
extends JosmAction {
    private static final long serialVersionUID = -5140181388906670207L;

    public AddStopPositionAction() {
        super(I18n.tr((String)"Add stop position", (Object[])new Object[0]), new ImageProvider("presets", "bus.png"), I18n.tr((String)"Add stop position", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Add stop position", (String)I18n.tr((String)"Add stop position", (Object[])new Object[0]), (int)84, (int)5000), false, "addStopPosition", false);
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled() || !Main.isDisplayingMapView()) {
            return;
        }
        Main.map.mapView.addMouseListener((MouseListener)new MouseAdapter(){
            LatLon clickPosition;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.clickPosition == null) {
                    this.clickPosition = Main.map.mapView.getLatLon(e.getX(), e.getY());
                    Layer activeLayer = Main.getLayerManager().getActiveLayer();
                    if (activeLayer instanceof OsmDataLayer) {
                        OsmDataLayer osmDataLayer = (OsmDataLayer)activeLayer;
                        Node newNode = new Node(this.clickPosition);
                        newNode.put("bus", "yes");
                        newNode.put("public_transport", "stop_position");
                        osmDataLayer.data.addPrimitive((OsmPrimitive)newNode);
                        osmDataLayer.data.setSelected(new PrimitiveId[]{newNode});
                        Main.map.mapView.repaint();
                    }
                    Main.map.mapView.removeMouseListener((MouseListener)this);
                    Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this);
                }
            }
        });
    }
}

