/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.utils;

import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;

public class RouteUtils {
    private RouteUtils() {
    }

    public static boolean isTwoDirectionRoute(Relation r) {
        if (!r.hasKey("route") || !r.hasTag("public_transport:version", "2")) {
            return false;
        }
        return (r.hasTag("route", "bus") || r.hasTag("route", "trolleybus") || r.hasTag("route", "share_taxi") || r.hasTag("route", "tram") || r.hasTag("route", "light_rail") || r.hasTag("route", "subway") || r.hasTag("route", "train")) && !r.hasTag("bus", "on_demand");
    }

    public static boolean isPTStop(RelationMember rm) {
        if (rm.hasRole(new String[]{"stop"}) || rm.hasRole(new String[]{"stop_entry_only"}) || rm.hasRole(new String[]{"stop_exit_only"}) || rm.hasRole(new String[]{"platform"}) || rm.hasRole(new String[]{"platform_entry_only"}) || rm.hasRole(new String[]{"platform_exit_only"})) {
            if (rm.getType().equals((Object)OsmPrimitiveType.NODE) && (rm.getNode().hasTag("public_transport", "stop_position") || rm.getNode().hasTag("highway", "bus_stop") || rm.getNode().hasTag("public_transport", "platform") || rm.getNode().hasTag("highway", "platform") || rm.getNode().hasTag("railway", "platform"))) {
                return true;
            }
            if (rm.getType().equals((Object)OsmPrimitiveType.WAY) && (rm.getWay().hasTag("public_transport", "platform") || rm.getWay().hasTag("highway", "platform") || rm.getWay().hasTag("railway", "platform"))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPTWay(RelationMember rm) {
        if (rm.getType().equals((Object)OsmPrimitiveType.NODE)) {
            return false;
        }
        if (rm.getType().equals((Object)OsmPrimitiveType.WAY)) {
            return !rm.getWay().hasTag("public_transport", "platform") && !rm.getWay().hasTag("highway", "platform") && !rm.getWay().hasTag("railway", "platform");
        }
        Relation nestedRelation = rm.getRelation();
        for (RelationMember nestedRelationMember : nestedRelation.getMembers()) {
            if (nestedRelationMember.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
            return false;
        }
        return true;
    }
}

