/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanestagging.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.gui.tagging.TagTable;
import org.openstreetmap.josm.plugins.turnlanestagging.editor.TagEditorModel;
import org.openstreetmap.josm.plugins.turnlanestagging.editor.TagTableCellRenderer;

public class TagEditor
extends JPanel {
    private static final Logger logger = Logger.getLogger(TagEditor.class.getName());
    private TagEditorModel tagEditorModel;
    private TagTable tblTagEditor;

    protected JPanel buildButtonsPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BoxLayout(pnl, 1));
        JButton btn = new JButton((Action)this.tblTagEditor.getAddAction());
        pnl.add(btn);
        btn.setMargin(new Insets(0, 0, 0, 0));
        this.tblTagEditor.addComponentNotStoppingCellEditing((Component)btn);
        btn = new JButton((Action)this.tblTagEditor.getDeleteAction());
        pnl.add(btn);
        btn.setMargin(new Insets(0, 0, 0, 0));
        this.tblTagEditor.addComponentNotStoppingCellEditing((Component)btn);
        return pnl;
    }

    public void addComponentNotStoppingCellEditing(Component c) {
        this.tblTagEditor.addComponentNotStoppingCellEditing(c);
    }

    protected JPanel buildTagEditorPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        DefaultListSelectionModel rowSelectionModel = new DefaultListSelectionModel();
        DefaultListSelectionModel colSelectionModel = new DefaultListSelectionModel();
        this.tagEditorModel = new TagEditorModel(rowSelectionModel, colSelectionModel);
        this.tblTagEditor = new TagTable((org.openstreetmap.josm.gui.tagging.TagEditorModel)this.tagEditorModel, 0);
        TagTableCellRenderer renderer = new TagTableCellRenderer();
        this.tblTagEditor.getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.tblTagEditor.getColumnModel().getColumn(1).setCellRenderer(renderer);
        JScrollPane scrollPane = new JScrollPane((Component)this.tblTagEditor);
        JPanel pnlTagTable = new JPanel(new BorderLayout());
        pnlTagTable.add((Component)scrollPane, "Center");
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 3;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        gc.anchor = 18;
        pnl.add((Component)this.buildButtonsPanel(), gc);
        gc.gridx = 1;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.anchor = 10;
        pnl.add((Component)pnlTagTable, gc);
        return pnl;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildTagEditorPanel(), "Center");
    }

    public TagEditor() {
        this.build();
    }

    public TagEditorModel getTagEditorModel() {
        return this.tagEditorModel;
    }

    public void clearSelection() {
        this.tblTagEditor.getSelectionModel().clearSelection();
    }

    public void stopEditing() {
        TableCellEditor editor = this.tblTagEditor.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    public void requestFocusInTopLeftCell() {
        this.tblTagEditor.requestFocusInCell(0, 0);
    }

    public TagEditorModel getModel() {
        return this.tagEditorModel;
    }
}

