/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.tools.I18n;

public class RoadTypeTest
extends Test {
    public static final int ERROR_CODE_ROAD_TYPE = 3721;
    public static final int ERROR_CODE_CONSTRUCTION = 3722;

    public RoadTypeTest() {
        super(I18n.tr((String)"Road Type Test", (Object[])new Object[0]), I18n.tr((String)"Checks if the course of the route relation is compatible with the type of the road it passes on.", (Object[])new Object[0]));
    }

    public void visit(Relation r) {
        if (!RouteUtils.isTwoDirectionRoute(r)) {
            return;
        }
        if (RouteUtils.hasIncompleteMembers(r)) {
            return;
        }
        List members = r.getMembers();
        for (RelationMember rm : members) {
            ArrayList<Way> highlighted;
            ArrayList<Relation> primitives;
            if (!RouteUtils.isPTWay(rm) || !rm.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
            Way way = rm.getWay();
            boolean isCorrectRoadType = true;
            boolean isUnderConstruction = false;
            if (r.hasTag("route", "bus") || r.hasTag("route", "share_taxi")) {
                if (!RouteUtils.isWaySuitableForBuses(way)) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("highway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (r.hasTag("route", "trolleybus")) {
                if (!RouteUtils.isWaySuitableForBuses(way) || !way.hasTag("trolley_wire", "yes")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("highway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (r.hasTag("route", "tram")) {
                if (!way.hasTag("railway", "tram")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (r.hasTag("route", "subway")) {
                if (!r.hasTag("railway", "subway")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (r.hasTag("route", "light_rail")) {
                if (!r.hasTag("raiilway", "subway")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (r.hasTag("route", "light_rail")) {
                if (!r.hasTag("railway", "light_rail")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (r.hasTag("route", "train")) {
                if (!r.hasTag("railway", "train")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            }
            if (!isCorrectRoadType && !isUnderConstruction) {
                primitives = new ArrayList<Relation>(1);
                primitives.add(r);
                highlighted = new ArrayList<Way>(1);
                highlighted.add(way);
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"PT: Route type does not match the type of the road it passes on", (Object[])new Object[0]), 3721, primitives, highlighted));
            }
            if (!isUnderConstruction) continue;
            primitives = new ArrayList(1);
            primitives.add(r);
            highlighted = new ArrayList(1);
            highlighted.add(way);
            TestError e = new TestError((Test)this, Severity.WARNING, I18n.tr((String)"PT: Road is under construction", (Object[])new Object[0]), 3722, primitives, highlighted);
            this.errors.add(e);
        }
    }

    public Command fixError(TestError testError) {
        ArrayList<ChangeCommand> commands = new ArrayList<ChangeCommand>(50);
        if (testError.getTester().getClass().equals(RoadTypeTest.class) && testError.isFixable()) {
            Collection primitives = testError.getPrimitives();
            Relation originalRelation = (Relation)primitives.iterator().next();
            Collection highlighted = testError.getHighlighted();
            Way wayToRemove = (Way)highlighted.iterator().next();
            Relation modifiedRelation = new Relation(originalRelation);
            ArrayList<RelationMember> modifiedRelationMembers = new ArrayList<RelationMember>(originalRelation.getMembersCount() - 1);
            for (RelationMember rm : originalRelation.getMembers()) {
                if (!RouteUtils.isPTStop(rm)) continue;
                if (rm.getRole().equals("stop_position")) {
                    RelationMember newMember;
                    if (rm.getType().equals((Object)OsmPrimitiveType.NODE)) {
                        newMember = new RelationMember("stop", (OsmPrimitive)rm.getNode());
                        modifiedRelationMembers.add(newMember);
                        continue;
                    }
                    newMember = new RelationMember("stop", (OsmPrimitive)rm.getWay());
                    modifiedRelationMembers.add(newMember);
                    continue;
                }
                modifiedRelationMembers.add(rm);
            }
            for (RelationMember rm : originalRelation.getMembers()) {
                Way wayToCheck;
                if (!RouteUtils.isPTWay(rm) || (wayToCheck = rm.getWay()) == wayToRemove) continue;
                if (rm.getRole().equals("forward") || rm.getRole().equals("backward")) {
                    RelationMember modifiedMember = new RelationMember("", (OsmPrimitive)wayToCheck);
                    modifiedRelationMembers.add(modifiedMember);
                    continue;
                }
                modifiedRelationMembers.add(rm);
            }
            modifiedRelation.setMembers(modifiedRelationMembers);
            ChangeCommand changeCommand = new ChangeCommand((OsmPrimitive)originalRelation, (OsmPrimitive)modifiedRelation);
            commands.add(changeCommand);
        }
        if (commands.isEmpty()) {
            return null;
        }
        if (commands.size() == 1) {
            return (Command)commands.get(0);
        }
        return new SequenceCommand(I18n.tr((String)"Remove way from route if it does not match the route type", (Object[])new Object[0]), commands);
    }

    public boolean isFixable(TestError testError) {
        return testError.getCode() == 3721 || testError.getCode() == 3722;
    }
}

