/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.gui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.LayerPositionStrategy;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.pt_assistant.gui.PTAssistantPaintVisitor;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.tools.ImageProvider;

public class PTAssistantLayer
extends Layer
implements SelectionChangedListener,
PropertyChangeListener,
LayerManager.LayerChangeListener {
    private List<OsmPrimitive> primitives = new ArrayList<OsmPrimitive>();
    private PTAssistantPaintVisitor paintVisitor;

    public PTAssistantLayer() {
        super("pt_assistant layer");
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this);
        Main.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
    }

    public void addPrimitive(OsmPrimitive primitive) {
        this.primitives.add(primitive);
    }

    public void clear() {
        this.primitives.clear();
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        this.paintVisitor = new PTAssistantPaintVisitor(g, mv);
        for (OsmPrimitive primitive : this.primitives) {
            this.paintVisitor.visit(primitive);
        }
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"osmdata_small");
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(null, (Layer)this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public String getToolTipText() {
        return "pt_assistant layer";
    }

    public boolean isMergable(Layer arg0) {
        return false;
    }

    public void mergeFrom(Layer arg0) {
    }

    public void visitBoundingBox(BoundingXYVisitor arg0) {
    }

    public LayerPositionStrategy getDefaultLayerPosition() {
        return LayerPositionStrategy.IN_FRONT;
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        ArrayList<Relation> routes = new ArrayList<Relation>();
        for (OsmPrimitive osmPrimitive : newSelection) {
            Relation relation;
            if (!osmPrimitive.getType().equals((Object)OsmPrimitiveType.RELATION) || !RouteUtils.isTwoDirectionRoute(relation = (Relation)osmPrimitive)) continue;
            routes.add(relation);
        }
        if (!routes.isEmpty()) {
            this.primitives.clear();
            this.primitives.addAll(routes);
            if (!Main.getLayerManager().containsLayer((Layer)this)) {
                Main.getLayerManager().addLayer((Layer)this);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("focusedWindow".equals(evt.getPropertyName())) {
            GenericRelationEditor editor;
            Relation relation;
            if (evt.getNewValue() == null) {
                return;
            }
            if (evt.getNewValue().getClass().equals(GenericRelationEditor.class) && RouteUtils.isTwoDirectionRoute(relation = (editor = (GenericRelationEditor)evt.getNewValue()).getRelation())) {
                this.primitives.clear();
                this.primitives.add((OsmPrimitive)relation);
                if (!Main.getLayerManager().containsLayer((Layer)this)) {
                    Main.getLayerManager().addLayer((Layer)this);
                }
                if (this.paintVisitor == null) {
                    Graphics g = Main.map.mapView.getGraphics();
                    MapView mv = Main.map.mapView;
                    this.paintVisitor = new PTAssistantPaintVisitor(g, mv);
                }
                for (OsmPrimitive primitive : this.primitives) {
                    this.paintVisitor.visit(primitive);
                }
                Main.map.repaint();
            }
        }
    }

    public void layerAdded(LayerManager.LayerAddEvent arg0) {
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent arg0) {
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent event) {
        if (event.getRemovedLayer() instanceof OsmDataLayer) {
            this.primitives.clear();
            Main.map.repaint();
        }
    }
}

