/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.hot.sds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.openstreetmap.hot.sds.SeparateDataStorePlugin;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

public class DetermineSdsModificationsUploadHook
implements UploadHook {
    private SeparateDataStorePlugin plugin;

    DetermineSdsModificationsUploadHook(SeparateDataStorePlugin plugin) {
        this.plugin = plugin;
    }

    public boolean checkUpload(APIDataSet apiDataSet) {
        ArrayList<OsmPrimitive> droplist = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive del : apiDataSet.getPrimitivesToDelete()) {
            IPrimitive old = this.plugin.getOriginalPrimitive((IPrimitive)del);
            if (!this.hasSpecialTags(old)) continue;
            this.plugin.enqueueForUpload((IPrimitive)del, new HashMap<String, String>(), false);
        }
        for (OsmPrimitive upd : apiDataSet.getPrimitivesToUpdate()) {
            HashSet<String> allKeys = new HashSet<String>();
            boolean specialTags = false;
            for (String key : upd.keySet()) {
                allKeys.add(key);
                if (specialTags || !this.isSpecialKey(key)) continue;
                specialTags = true;
            }
            IPrimitive old = this.plugin.getOriginalPrimitive((IPrimitive)upd);
            for (String key : old.keySet()) {
                allKeys.add(key);
                if (specialTags || !this.isSpecialKey(key)) continue;
                specialTags = true;
            }
            if (!specialTags) continue;
            boolean changeInSpecialTags = false;
            boolean changeInOtherTags = false;
            for (String key : allKeys) {
                if (old.get(key) != null && upd.get(key) != null && old.get(key).equals(upd.get(key))) continue;
                if (this.isSpecialKey(key)) {
                    changeInSpecialTags = true;
                } else {
                    changeInOtherTags = true;
                }
                if (!changeInSpecialTags || !changeInOtherTags) continue;
                break;
            }
            if (!changeInSpecialTags) continue;
            HashMap<String, String> newSpecialTags = new HashMap<String, String>();
            for (String key : upd.keySet()) {
                if (!this.isSpecialKey(key)) continue;
                newSpecialTags.put(key, upd.get(key));
            }
            boolean uploadToOsm = changeInOtherTags;
            if (!changeInOtherTags) {
                block0 : switch (old.getType()) {
                    case NODE: {
                        INode nold = (INode)old;
                        INode nupd = (INode)upd;
                        uploadToOsm = !nold.getCoor().equals((Object)nupd.getCoor());
                        break;
                    }
                    case WAY: {
                        IWay wold = (IWay)old;
                        IWay wupd = (IWay)upd;
                        if (wold.getNodesCount() != wupd.getNodesCount()) {
                            uploadToOsm = true;
                            break;
                        }
                        for (int i = 0; i < wold.getNodesCount(); ++i) {
                            if (wold.getNodeId(i) == wupd.getNodeId(i)) continue;
                            uploadToOsm = true;
                            break block0;
                        }
                        break;
                    }
                    case RELATION: {
                        IRelation rold = (IRelation)old;
                        IRelation rupd = (IRelation)upd;
                        if (rold.getMembersCount() != rupd.getMembersCount()) {
                            uploadToOsm = true;
                            break;
                        }
                        for (int i = 0; i < rold.getMembersCount(); ++i) {
                            if (rold.getMemberType(i) == rupd.getMemberType(i) && rold.getMemberId(i) == rupd.getMemberId(i)) continue;
                            uploadToOsm = true;
                            break block0;
                        }
                        break;
                    }
                }
            }
            this.plugin.enqueueForUpload((IPrimitive)upd, newSpecialTags, !uploadToOsm);
            if (uploadToOsm) continue;
            droplist.add(upd);
        }
        apiDataSet.getPrimitivesToUpdate().removeAll(droplist);
        for (OsmPrimitive add : apiDataSet.getPrimitivesToAdd()) {
            HashMap<String, String> newSpecialTags = new HashMap<String, String>();
            for (String key : add.keySet()) {
                if (!this.isSpecialKey(key)) continue;
                newSpecialTags.put(key, add.get(key));
            }
            if (newSpecialTags.isEmpty()) continue;
            this.plugin.enqueueForUpload((IPrimitive)add, newSpecialTags, false);
        }
        return true;
    }

    boolean hasSpecialTags(IPrimitive p) {
        for (String key : p.keySet()) {
            if (!this.isSpecialKey(key)) continue;
            return true;
        }
        return false;
    }

    boolean isSpecialKey(String key) {
        return key.startsWith(this.plugin.getIgnorePrefix());
    }
}

