/*
 * Decompiled with CFR 0.152.
 */
package MichiganLeft;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MichiganLeft
extends Plugin {
    JMenuItem MichiganLeft;

    public MichiganLeft(PluginInformation info) {
        super(info);
        this.MichiganLeft = MainMenu.add((JMenu)Main.main.menu.dataMenu, (JosmAction)new MichiganLeftAction());
    }

    private class MichiganLeftAction
    extends JosmAction {
        private LinkedList<Command> cmds;

        public MichiganLeftAction() {
            super(I18n.tr((String)"Michigan Left", (Object[])new Object[0]), "michigan_left", I18n.tr((String)"Adds no left turn for sets of 4 or 5 ways.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:michigan_left", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Michigan Left", (Object[])new Object[0])}), (int)78, (int)5007), true);
            this.cmds = new LinkedList();
        }

        public void actionPerformed(ActionEvent e) {
            Hashtable<Node, Integer> extremNodes;
            Collection mainSelection = Main.main.getCurrentDataSet().getSelected();
            ArrayList<OsmPrimitive> selection = new ArrayList<OsmPrimitive>();
            for (OsmPrimitive prim : mainSelection) {
                selection.add(prim);
            }
            int ways = 0;
            for (OsmPrimitive prim : selection) {
                if (!(prim instanceof Way)) continue;
                ++ways;
            }
            if (ways != 4 && ways != 5) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select 4 or 5 ways to assign no left turns.", (Object[])new Object[0]));
                return;
            }
            if (ways == 4) {
                extremNodes = new Hashtable<Node, Integer>();
                for (OsmPrimitive prim : selection) {
                    if (!(prim instanceof Way)) continue;
                    Way way = (Way)prim;
                    this.incrementHashtable(extremNodes, way.firstNode());
                    this.incrementHashtable(extremNodes, way.lastNode());
                }
                if (extremNodes.size() != 4) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select 4 ways that form a closed relation.", (Object[])new Object[0]));
                    return;
                }
                ArrayList<Way> orderedWays = new ArrayList<Way>();
                Way currentWay = (Way)selection.iterator().next();
                orderedWays.add(currentWay);
                selection.remove(currentWay);
                while (selection.size() > 0) {
                    boolean found = false;
                    Node nextNode = currentWay.lastNode();
                    for (OsmPrimitive prim : selection) {
                        Way tmpWay = (Way)prim;
                        if (tmpWay.firstNode() != nextNode) continue;
                        orderedWays.add(tmpWay);
                        selection.remove(prim);
                        currentWay = tmpWay;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unable to order the ways. Please verify their directions", (Object[])new Object[0]));
                    return;
                }
                for (int index = 0; index < 4; ++index) {
                    Way firstWay = (Way)orderedWays.get(index);
                    Way lastWay = (Way)orderedWays.get((index + 1) % 4);
                    Node lastNode = firstWay.lastNode();
                    this.buildRelation(firstWay, lastWay, lastNode);
                }
                SequenceCommand c = new SequenceCommand(I18n.tr((String)"Create Michigan left turn restriction", (Object[])new Object[0]), this.cmds);
                Main.main.undoRedo.add((Command)c);
                this.cmds.clear();
            }
            if (ways == 5) {
                Node last;
                Node first;
                Way way;
                extremNodes = new Hashtable();
                for (OsmPrimitive prim : selection) {
                    if (!(prim instanceof Way)) continue;
                    Way way2 = (Way)prim;
                    this.incrementHashtable(extremNodes, way2.firstNode());
                    this.incrementHashtable(extremNodes, way2.lastNode());
                }
                ArrayList<Node> viaNodes = new ArrayList<Node>();
                Enumeration enumKey = extremNodes.keys();
                while (enumKey.hasMoreElements()) {
                    Node extrem = (Node)enumKey.nextElement();
                    Integer nb = extremNodes.get(extrem);
                    if (nb != 3) continue;
                    viaNodes.add(extrem);
                }
                if (viaNodes.size() != 2) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unable to find via nodes. Please check your selection", (Object[])new Object[0]));
                    return;
                }
                Node viaFirst = (Node)viaNodes.get(0);
                Node viaLast = (Node)viaNodes.get(1);
                Way middle = null;
                for (OsmPrimitive prim : selection) {
                    if (!(prim instanceof Way)) continue;
                    way = (Way)prim;
                    first = way.firstNode();
                    last = way.lastNode();
                    if ((!first.equals((Object)viaFirst) || !last.equals((Object)viaLast)) && (!first.equals((Object)viaLast) || !last.equals((Object)viaFirst))) continue;
                    middle = way;
                }
                for (OsmPrimitive prim : selection) {
                    if (!(prim instanceof Way) || (way = (Way)prim) == middle) continue;
                    first = way.firstNode();
                    last = way.lastNode();
                    if (first == viaFirst) {
                        this.buildRelation(middle, way, (Node)viaNodes.get(0));
                        continue;
                    }
                    if (first == viaLast) {
                        this.buildRelation(middle, way, (Node)viaNodes.get(1));
                        continue;
                    }
                    if (last == viaFirst) {
                        this.buildRelation(way, middle, (Node)viaNodes.get(0));
                        continue;
                    }
                    if (last != viaLast) continue;
                    this.buildRelation(way, middle, (Node)viaNodes.get(1));
                }
                SequenceCommand c = new SequenceCommand(I18n.tr((String)"Create Michigan left turn restriction", (Object[])new Object[0]), this.cmds);
                Main.main.undoRedo.add((Command)c);
                this.cmds.clear();
            }
        }

        public void incrementHashtable(Hashtable<Node, Integer> hash, Node node) {
            if (hash.containsKey(node)) {
                Integer nb = hash.get(node);
                hash.put(node, new Integer(nb + 1));
            } else {
                hash.put(node, new Integer(1));
            }
        }

        public void buildRelation(Way fromWay, Way toWay, Node viaNode) {
            Relation relation = new Relation();
            RelationMember from = new RelationMember("from", (OsmPrimitive)fromWay);
            relation.addMember(from);
            RelationMember to = new RelationMember("to", (OsmPrimitive)toWay);
            relation.addMember(to);
            RelationMember via = new RelationMember("via", (OsmPrimitive)viaNode);
            relation.addMember(via);
            relation.put("type", "restriction");
            relation.put("restriction", "no_left_turn");
            this.cmds.add((Command)new AddCommand((OsmPrimitive)relation));
        }

        protected void updateEnabledState() {
            this.setEnabled(MichiganLeftAction.getEditLayer() != null);
        }

        protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        }
    }
}

