/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.slider;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;
import org.openstreetmap.josm.plugins.mapdust.gui.component.slider.RelevanceChangeListener;
import org.openstreetmap.josm.plugins.mapdust.gui.component.slider.RelevanceSlider;
import org.openstreetmap.josm.tools.ImageProvider;

public class RelevanceSliderUI
extends BasicSliderUI {
    private Rectangle upperRect;
    private boolean isUpperSelected;
    private transient boolean isLowerDragging;
    private transient boolean isUpperDragging;
    private final Icon sliderIcon = ImageProvider.get((String)"slider/thumb.png");

    public RelevanceSliderUI(RelevanceSlider relevanceSlider) {
        super(relevanceSlider);
    }

    @Override
    public void installUI(JComponent component) {
        this.upperRect = new Rectangle();
        super.installUI(component);
    }

    public void changeSliderState() {
        if (!this.isLowerDragging && !this.isUpperDragging) {
            this.calculateThumbLocation();
            this.slider.repaint();
        } else if (this.isUpperSelected) {
            this.calculateThumbLocation();
            this.slider.repaint();
        }
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new RangeTrackListener();
    }

    @Override
    protected ChangeListener createChangeListener(JSlider slider) {
        return new RelevanceChangeListener(this);
    }

    @Override
    protected void calculateThumbSize() {
        super.calculateThumbSize();
        this.upperRect.setSize(this.sliderIcon.getIconWidth(), this.sliderIcon.getIconHeight());
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        if (this.getSlider().getSnapToTicks()) {
            int upperValue;
            int snappedValue = upperValue = this.getSlider().getUpperValue();
            int majorTickSpacing = this.getSlider().getMajorTickSpacing();
            int minorTickSpacing = this.getSlider().getMinorTickSpacing();
            int tickSpacing = 0;
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0) {
                int min = this.getSlider().getMinimum();
                if ((upperValue - min) % tickSpacing != 0) {
                    float temp = upperValue - min;
                    int whichTick = Math.round(temp /= (float)tickSpacing);
                    snappedValue = min + whichTick * tickSpacing;
                }
                if (snappedValue != upperValue) {
                    int extent = snappedValue - this.getSlider().getLowerValue();
                    this.getSlider().setExtent(extent);
                }
            }
        }
        int value = this.getSlider().getLowerValue() + this.getSlider().getExtent();
        int upperPosition = this.xPositionForValue(value);
        this.upperRect.x = upperPosition - this.upperRect.width / 2;
        this.upperRect.y = this.trackRect.y;
    }

    @Override
    protected Dimension getThumbSize() {
        return new Dimension(this.sliderIcon.getIconWidth(), this.sliderIcon.getIconHeight());
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Rectangle clipRect = g.getClipBounds();
        if (this.isUpperSelected) {
            if (clipRect.intersects(this.thumbRect)) {
                this.sliderIcon.paintIcon(this.getSlider(), g, this.thumbRect.x, this.thumbRect.y);
            }
            if (clipRect.intersects(this.upperRect)) {
                this.sliderIcon.paintIcon(this.getSlider(), g, this.upperRect.x, this.upperRect.y);
            }
        } else {
            if (clipRect.intersects(this.upperRect)) {
                this.sliderIcon.paintIcon(this.getSlider(), g, this.upperRect.x, this.upperRect.y);
            }
            if (clipRect.intersects(this.thumbRect)) {
                this.sliderIcon.paintIcon(this.getSlider(), g, this.thumbRect.x, this.thumbRect.y);
            }
        }
    }

    @Override
    public void paintThumb(Graphics g) {
    }

    @Override
    public void paintTrack(Graphics g) {
        super.paintTrack(g);
        Rectangle trackBounds = this.trackRect;
        int lowerX = this.thumbRect.x + this.thumbRect.width / 2;
        int upperX = this.upperRect.x + this.upperRect.width / 2;
        int cy = trackBounds.height / 2 - 2;
        Color oldColor = g.getColor();
        g.translate(trackBounds.x, trackBounds.y + cy);
        g.setColor(Color.orange);
        for (int y = 0; y <= 3; ++y) {
            g.drawLine(lowerX - trackBounds.x, y, upperX - trackBounds.x, y);
        }
        g.translate(-trackBounds.x, -(trackBounds.y + cy));
        g.setColor(oldColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByBlock(int direction) {
        RelevanceSlider relevanceSlider = this.getSlider();
        synchronized (relevanceSlider) {
            int min = this.getSlider().getMinimum();
            int max = this.getSlider().getMaximum();
            int incr = (max - min) / 10;
            if (incr <= 0 && max > min) {
                incr = 1;
            }
            int delta = incr * (direction > 0 ? 1 : -1);
            if (this.isUpperSelected) {
                int oldValue = this.getSlider().getUpperValue();
                this.getSlider().setUpperValue(oldValue + delta);
            } else {
                int oldValue = this.getSlider().getLowerValue();
                this.getSlider().setLowerValue(oldValue + delta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByUnit(int direction) {
        RelevanceSlider relevanceSlider = this.getSlider();
        synchronized (relevanceSlider) {
            int delta = 1 * (direction > 0 ? 1 : -1);
            if (this.isUpperSelected) {
                int oldValue = this.getSlider().getUpperValue();
                this.getSlider().setUpperValue(oldValue + delta);
            } else {
                int oldValue = this.getSlider().getLowerValue();
                this.getSlider().setLowerValue(oldValue + delta);
            }
        }
    }

    protected RelevanceSlider getSlider() {
        return (RelevanceSlider)this.slider;
    }

    protected Rectangle getThumbRect() {
        return this.thumbRect;
    }

    protected Rectangle getTrackRect() {
        return this.trackRect;
    }

    public Rectangle getUpperRect() {
        return this.upperRect;
    }

    @Override
    protected boolean drawInverted() {
        return super.drawInverted();
    }

    @Override
    protected int xPositionForValue(int value) {
        return super.xPositionForValue(value);
    }

    public boolean getIsUpperSelected() {
        return this.isUpperSelected;
    }

    public void setIsUpperSelected(boolean isUpperSelected) {
        this.isUpperSelected = isUpperSelected;
    }

    public boolean getIsLowerDragging() {
        return this.isLowerDragging;
    }

    public void setIsLowerDragging(boolean isLowerDragging) {
        this.isLowerDragging = isLowerDragging;
    }

    public boolean getIsUpperDragging() {
        return this.isUpperDragging;
    }

    public void setIsUpperDragging(boolean isUpperDragging) {
        this.isUpperDragging = isUpperDragging;
    }

    class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        RangeTrackListener() {
            super(RelevanceSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (!RelevanceSliderUI.this.getSlider().isEnabled()) {
                return;
            }
            this.currentMouseX = event.getX();
            this.currentMouseY = event.getY();
            if (RelevanceSliderUI.this.getSlider().isRequestFocusEnabled()) {
                RelevanceSliderUI.this.getSlider().requestFocus();
            }
            boolean lowerPressed = false;
            boolean upperPressed = false;
            if (RelevanceSliderUI.this.getIsUpperSelected()) {
                if (RelevanceSliderUI.this.getUpperRect().contains(this.currentMouseX, this.currentMouseY)) {
                    upperPressed = true;
                } else if (RelevanceSliderUI.this.getThumbRect().contains(this.currentMouseX, this.currentMouseY)) {
                    lowerPressed = true;
                }
            } else if (RelevanceSliderUI.this.getThumbRect().contains(this.currentMouseX, this.currentMouseY)) {
                lowerPressed = true;
            } else if (RelevanceSliderUI.this.getUpperRect().contains(this.currentMouseX, this.currentMouseY)) {
                upperPressed = true;
            }
            if (lowerPressed) {
                this.offset = this.currentMouseX - RelevanceSliderUI.this.getThumbRect().x;
                RelevanceSliderUI.this.setIsUpperSelected(false);
                RelevanceSliderUI.this.setIsLowerDragging(true);
                return;
            }
            RelevanceSliderUI.this.setIsLowerDragging(false);
            if (upperPressed) {
                this.offset = this.currentMouseX - RelevanceSliderUI.this.getUpperRect().x;
                RelevanceSliderUI.this.setIsUpperSelected(true);
                RelevanceSliderUI.this.setIsUpperDragging(true);
                return;
            }
            RelevanceSliderUI.this.setIsUpperDragging(false);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            RelevanceSliderUI.this.setIsLowerDragging(false);
            RelevanceSliderUI.this.setIsUpperDragging(false);
            RelevanceSliderUI.this.getSlider().setValueIsAdjusting(false);
            super.mouseReleased(event);
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (!RelevanceSliderUI.this.getSlider().isEnabled()) {
                return;
            }
            this.currentMouseX = event.getX();
            this.currentMouseY = event.getY();
            if (RelevanceSliderUI.this.getIsLowerDragging()) {
                RelevanceSliderUI.this.getSlider().setValueIsAdjusting(true);
                this.moveLowerThumb(event);
            } else if (RelevanceSliderUI.this.getIsUpperDragging()) {
                RelevanceSliderUI.this.getSlider().setValueIsAdjusting(true);
                this.moveUpperThumb(event);
            }
        }

        @Override
        public boolean shouldScroll(int direction) {
            return false;
        }

        private void moveLowerThumb(MouseEvent event) {
            int halfThumbWidth = RelevanceSliderUI.this.getThumbRect().width / 2;
            int thumbLeft = this.currentMouseX - this.offset;
            int trackLeft = RelevanceSliderUI.this.getTrackRect().x;
            int trackRight = RelevanceSliderUI.this.getTrackRect().x + (RelevanceSliderUI.this.getTrackRect().width - 1);
            int hMax = RelevanceSliderUI.this.xPositionForValue(RelevanceSliderUI.this.getSlider().getLowerValue() + RelevanceSliderUI.this.getSlider().getExtent());
            if (RelevanceSliderUI.this.drawInverted()) {
                trackLeft = hMax;
            } else {
                trackRight = hMax;
            }
            thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
            thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
            RelevanceSliderUI.this.setThumbLocation(thumbLeft, RelevanceSliderUI.this.getThumbRect().y);
            RelevanceSliderUI.this.getSlider().setLowerValue(this.getSnappedValue(event));
        }

        private void moveUpperThumb(MouseEvent event) {
            int halfThumbWidth = RelevanceSliderUI.this.getThumbRect().width / 2;
            int thumbLeft = this.currentMouseX - this.offset;
            int trackLeft = RelevanceSliderUI.this.getTrackRect().x;
            int trackRight = RelevanceSliderUI.this.getTrackRect().x + (RelevanceSliderUI.this.getTrackRect().width - 1);
            int hMin = RelevanceSliderUI.this.xPositionForValue(RelevanceSliderUI.this.getSlider().getLowerValue());
            if (RelevanceSliderUI.this.drawInverted()) {
                trackRight = hMin;
            } else {
                trackLeft = hMin;
            }
            thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
            thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
            Rectangle upperUnionRect = new Rectangle();
            upperUnionRect.setBounds(RelevanceSliderUI.this.getUpperRect());
            RelevanceSliderUI.this.getUpperRect().setLocation(thumbLeft, RelevanceSliderUI.this.getThumbRect().y);
            SwingUtilities.computeUnion(RelevanceSliderUI.this.getUpperRect().x, RelevanceSliderUI.this.getUpperRect().y, RelevanceSliderUI.this.getUpperRect().width, RelevanceSliderUI.this.getUpperRect().height, upperUnionRect);
            RelevanceSliderUI.this.getSlider().repaint(upperUnionRect.x, upperUnionRect.y, upperUnionRect.width, upperUnionRect.height);
            RelevanceSliderUI.this.getSlider().setUpperValue(this.getSnappedValue(event));
        }

        private int getSnappedValue(MouseEvent evt) {
            int value;
            int pozX = RelevanceSliderUI.this.valueForXPosition(evt.getX());
            int pozY = RelevanceSliderUI.this.valueForYPosition(evt.getY());
            int snappedValue = value = RelevanceSliderUI.this.getSlider().getOrientation() == 0 ? pozX : pozY;
            int tickSpacing = 0;
            int majorTickSpacing = RelevanceSliderUI.this.getSlider().getMajorTickSpacing();
            int minorTickSpacing = RelevanceSliderUI.this.getSlider().getMinorTickSpacing();
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0 && (value - RelevanceSliderUI.this.getSlider().getMinimum()) % tickSpacing != 0) {
                float temp = (float)(value - RelevanceSliderUI.this.getSlider().getMinimum()) / (float)tickSpacing;
                snappedValue = RelevanceSliderUI.this.getSlider().getMinimum() + Math.round(temp) * tickSpacing;
            }
            return snappedValue;
        }
    }
}

