/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.mapdust.MapdustLayer;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustGUI;
import org.openstreetmap.josm.plugins.mapdust.gui.component.dialog.CreateBugDialog;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustUpdateObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustPluginState;
import org.openstreetmap.josm.plugins.mapdust.service.MapdustServiceHandler;
import org.openstreetmap.josm.plugins.mapdust.service.MapdustServiceHandlerException;
import org.openstreetmap.josm.plugins.mapdust.service.value.BoundingBox;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBugFilter;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustRelevance;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapdustPlugin
extends Plugin
implements MapView.LayerChangeListener,
NavigatableComponent.ZoomChangeListener,
Preferences.PreferenceChangedListener,
MouseListener,
MapdustUpdateObserver,
MapdustBugObserver {
    private MapdustGUI mapdustGUI;
    private MapdustLayer mapdustLayer;
    private CreateBugDialog dialog;
    private List<MapdustBug> mapdustBugList;
    private BoundingBox bBox = null;
    private Shortcut shortcut;
    private MapdustBugFilter filter = null;
    protected boolean wasError = false;

    public MapdustPlugin(PluginInformation info) {
        super(info);
        this.initializePlugin();
    }

    private void initializePlugin() {
        this.shortcut = Shortcut.registerShortcut((String)"MapDust", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Open MapDust", (Object[])new Object[0])}), (int)48, (int)5007);
        Main.pref.put("mapdust.pluginState", MapdustPluginState.ONLINE.getValue());
        Main.pref.put("mapdust.nickname", "");
        Main.pref.put("mapdust.showError", true);
        Main.pref.put("mapdust.version", this.getPluginInformation().version);
        Main.pref.put("mapdust.localVersion", this.getPluginInformation().localversion);
        Main.pref.addPreferenceChangeListener((Preferences.PreferenceChangedListener)this);
    }

    public void mapFrameInitialized(MapFrame oldMapFrame, MapFrame newMapFrame) {
        if (newMapFrame != null) {
            this.mapdustGUI = new MapdustGUI(I18n.tr((String)"MapDust bug reports", (Object[])new Object[0]), "mapdust_icon.png", I18n.tr((String)"Activates the MapDust bug reporter plugin", (Object[])new Object[0]), this.shortcut, 150, this);
            this.mapdustGUI.setBounds(newMapFrame.getBounds());
            this.mapdustGUI.addObserver(this);
            newMapFrame.addToggleDialog((ToggleDialog)this.mapdustGUI);
            NavigatableComponent.addZoomChangeListener((NavigatableComponent.ZoomChangeListener)this);
            MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
            newMapFrame.mapView.addMouseListener((MouseListener)this);
            Main.pref.put("mapdust.josmUserName", JosmUserIdentityManager.getInstance().getUserName());
        } else {
            oldMapFrame.mapView.removeMouseListener((MouseListener)this);
            MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
            NavigatableComponent.removeZoomChangeListener((NavigatableComponent.ZoomChangeListener)this);
            this.mapdustGUI.removeObserver(this);
            this.mapdustGUI = null;
        }
    }

    public void preferenceChanged(Preferences.PreferenceChangeEvent event) {
        if (this.mapdustGUI != null && this.mapdustGUI.isShowing() && !this.wasError && this.mapdustLayer != null && this.mapdustLayer.isVisible() && event.getKey().equals("osm-server.username")) {
            String newUserName = JosmUserIdentityManager.getInstance().getUserName();
            String oldUserName = Main.pref.get("mapdust.josmUserName");
            String nickname = Main.pref.get("mapdust.nickname");
            if (nickname.isEmpty()) {
                Main.pref.put("mapdust.josmUserName", newUserName);
                Main.pref.put("mapdust.nickname", newUserName);
            } else if (nickname.equals(oldUserName)) {
                Main.pref.put("mapdust.josmUserName", newUserName);
                Main.pref.put("mapdust.nickname", newUserName);
            } else {
                Main.pref.put("mapdust.josmUserName", newUserName);
            }
        }
    }

    @Override
    public synchronized void changedData(MapdustBug mapdustBug) {
        if (this.mapdustBugList == null) {
            this.mapdustBugList = new ArrayList<MapdustBug>();
        }
        if (this.getMapdustGUI().isDialogShowing() && Main.map != null && Main.map.mapView != null) {
            MapdustBug oldBug = null;
            for (MapdustBug bug : this.mapdustBugList) {
                if (!bug.getId().equals(mapdustBug.getId())) continue;
                oldBug = bug;
            }
            boolean showBug = this.shouldDisplay(mapdustBug);
            if (oldBug != null) {
                if (showBug) {
                    this.mapdustBugList.remove(oldBug);
                    this.mapdustBugList.add(0, mapdustBug);
                } else {
                    this.mapdustBugList.remove(oldBug);
                }
            } else if (showBug) {
                this.mapdustBugList.add(0, mapdustBug);
            }
            this.mapdustGUI.update(this.mapdustBugList, this);
            this.mapdustLayer.setMapdustGUI(this.mapdustGUI);
            if (showBug) {
                this.mapdustGUI.setSelectedBug(this.mapdustBugList.get(0));
            } else {
                this.mapdustLayer.setBugSelected(null);
                this.mapdustGUI.enableBtnPanel(true);
                Main.map.mapView.repaint();
                String title = "MapDust";
                String message = "The operation was successful.";
                JOptionPane.showMessageDialog(Main.parent, message, title, 1);
            }
        }
    }

    private boolean shouldDisplay(MapdustBug mapdustBug) {
        boolean result = true;
        if (this.filter != null) {
            boolean containsStatus = false;
            if (this.filter.getStatuses() != null && !this.filter.getStatuses().isEmpty()) {
                Integer statusKey = mapdustBug.getStatus().getKey();
                if (this.filter.getStatuses().contains(statusKey)) {
                    containsStatus = true;
                }
            } else {
                containsStatus = true;
            }
            boolean containsType = false;
            if (this.filter.getTypes() != null && !this.filter.getTypes().isEmpty()) {
                String typeKey = mapdustBug.getType().getKey();
                if (this.filter.getTypes().contains(typeKey)) {
                    containsType = true;
                }
            } else {
                containsType = true;
            }
            result = this.filter.getDescr() != null && this.filter.getDescr().booleanValue() ? (mapdustBug.getIsDefaultDescription() ? false : containsStatus && containsType) : containsStatus && containsType;
            boolean containsMinRelevance = false;
            if (this.filter.getMinRelevance() != null) {
                MapdustRelevance bugRel;
                MapdustRelevance minRel = this.filter.getMinRelevance();
                if (minRel.equals(bugRel = mapdustBug.getRelevance())) {
                    containsMinRelevance = true;
                } else if (bugRel.compareTo(minRel) == 1) {
                    containsMinRelevance = true;
                }
            }
            boolean containsMaxRelevance = false;
            if (this.filter.getMaxRelevance() != null) {
                MapdustRelevance bugRel;
                MapdustRelevance maxRel = this.filter.getMaxRelevance();
                if (maxRel.equals(bugRel = mapdustBug.getRelevance())) {
                    containsMaxRelevance = true;
                } else if (bugRel.compareTo(maxRel) == -1) {
                    containsMaxRelevance = true;
                }
                result = result && containsMinRelevance && containsMaxRelevance;
            }
        }
        return result;
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.mapdustLayer != null && this.mapdustLayer.isVisible() && event.getButton() == 1) {
            if (event.getClickCount() == 2 && !event.isConsumed() && Main.getLayerManager().getActiveLayer() == this.getMapdustLayer()) {
                MapdustBug bug = this.mapdustGUI.getSelectedBug();
                if (bug != null) {
                    Main.pref.put("selectedBug.status", bug.getStatus().getValue());
                } else {
                    Main.pref.put("selectedBug.status", "create");
                }
                this.mapdustGUI.getPanel().disableBtnPanel();
                this.dialog = new CreateBugDialog(event.getPoint(), this);
                this.dialog.showDialog();
                event.consume();
                return;
            }
            if (event.getClickCount() == 1 && !event.isConsumed()) {
                Point p = event.getPoint();
                MapdustBug nearestBug = this.getNearestBug(p);
                if (nearestBug != null) {
                    this.mapdustLayer.setBugSelected(nearestBug);
                    this.mapdustGUI.setSelectedBug(nearestBug);
                    Main.map.mapView.repaint();
                }
                return;
            }
        }
    }

    private MapdustBug getNearestBug(Point p) {
        double snapDistance = 10.0;
        double minDistanceSq = Double.MAX_VALUE;
        MapdustBug nearestBug = null;
        for (MapdustBug bug : this.mapdustBugList) {
            Point sp = Main.map.mapView.getPoint(bug.getLatLon());
            double dist = p.distanceSq(sp);
            if (minDistanceSq > dist && p.distance(sp) < snapDistance) {
                minDistanceSq = p.distanceSq(sp);
                nearestBug = bug;
                continue;
            }
            if (minDistanceSq != dist) continue;
            nearestBug = bug;
        }
        return nearestBug;
    }

    public void activeLayerChange(Layer arg0, Layer arg1) {
    }

    public void layerAdded(Layer layer) {
    }

    public void layerRemoved(Layer layer) {
        if (layer instanceof MapdustLayer) {
            Main.pref.put("mapdust.pluginState", MapdustPluginState.ONLINE.getValue());
            NavigatableComponent.removeZoomChangeListener((NavigatableComponent.ZoomChangeListener)this);
            Main.main.removeLayer(layer);
            if (this.mapdustGUI != null) {
                Main.map.remove((Component)((Object)this.mapdustGUI));
                this.mapdustGUI.destroy();
            }
            this.mapdustLayer = null;
            this.filter = null;
            this.mapdustBugList = null;
        }
    }

    public void zoomChanged() {
        if (this.mapdustGUI != null && this.mapdustGUI.isShowing() && !this.wasError) {
            boolean download = true;
            BoundingBox curentBBox = this.getBBox();
            if (this.bBox != null && this.bBox.equals(curentBBox)) {
                download = false;
            }
            this.bBox = curentBBox;
            if (download) {
                this.updatePluginData();
            }
        }
    }

    @Override
    public void update(MapdustBugFilter filter, boolean initialUpdate) {
        this.bBox = this.getBBox();
        if (initialUpdate) {
            this.updatePluginData();
        } else {
            if (filter != null) {
                this.filter = filter;
            }
            if (this.mapdustGUI != null && this.mapdustGUI.isShowing() && !this.wasError) {
                this.updatePluginData();
            }
        }
    }

    private BoundingBox getBBox() {
        MapView mapView = Main.map.mapView;
        Bounds bounds = new Bounds(mapView.getLatLon(0, mapView.getHeight()), mapView.getLatLon(mapView.getWidth(), 0));
        return new BoundingBox(bounds.getMin().lon(), bounds.getMin().lat(), bounds.getMax().lon(), bounds.getMax().lat());
    }

    private void updatePluginData() {
        Main.worker.execute(new Runnable(){

            @Override
            public void run() {
                MapdustPlugin.this.updateMapdustData();
            }
        });
    }

    protected synchronized void updateMapdustData() {
        if (Main.map != null && Main.map.mapView != null) {
            try {
                MapdustServiceHandler handler = new MapdustServiceHandler();
                this.mapdustBugList = handler.getBugs(this.bBox, this.filter);
                this.wasError = false;
            }
            catch (MapdustServiceHandlerException e) {
                this.wasError = true;
                this.mapdustBugList = new ArrayList<MapdustBug>();
            }
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        MapdustPlugin.this.updateView();
                        if (MapdustPlugin.this.wasError) {
                            MapdustPlugin.this.handleError();
                        }
                    }
                }
            });
        }
    }

    protected void updateView() {
        if (Main.map != null && Main.map.mapView != null) {
            boolean needRepaint = false;
            if (!this.containsMapdustLayer()) {
                if (this.mapdustGUI.isDownloaded()) {
                    this.mapdustGUI.update(this.mapdustBugList, this);
                    this.mapdustLayer = new MapdustLayer("MapDust", this.mapdustGUI, this.mapdustBugList);
                    Main.main.addLayer((Layer)this.mapdustLayer);
                    Main.map.mapView.moveLayer((Layer)this.mapdustLayer, 0);
                    Main.map.mapView.addMouseListener((MouseListener)this);
                    NavigatableComponent.addZoomChangeListener((NavigatableComponent.ZoomChangeListener)this);
                    needRepaint = true;
                }
            } else if (this.mapdustLayer != null) {
                this.mapdustGUI.update(this.mapdustBugList, this);
                this.mapdustLayer.destroy();
                this.mapdustLayer.update(this.mapdustGUI, this.mapdustBugList);
                needRepaint = true;
            }
            if (needRepaint) {
                this.mapdustGUI.revalidate();
                Main.map.mapView.revalidate();
                Main.map.repaint();
            }
        }
    }

    private boolean containsMapdustLayer() {
        return this.mapdustLayer != null && Main.getLayerManager().containsLayer((Layer)this.mapdustLayer);
    }

    protected void handleError() {
        String showMessage = Main.pref.get("mapdust.showError");
        Boolean showErrorMessage = Boolean.parseBoolean(showMessage);
        if (showErrorMessage.booleanValue()) {
            Main.pref.put("mapdust.showError", false);
            String errorMessage = "There was a Mapdust service error.";
            errorMessage = errorMessage + " Please try later.";
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)errorMessage, (Object[])new Object[0]));
        }
    }

    public MapdustGUI getMapdustGUI() {
        return this.mapdustGUI;
    }

    public void setMapdustGUI(MapdustGUI mapdustGUI) {
        this.mapdustGUI = mapdustGUI;
    }

    public MapdustLayer getMapdustLayer() {
        return this.mapdustLayer;
    }

    public void setMapdustLayer(MapdustLayer mapdustLayer) {
        this.mapdustLayer = mapdustLayer;
    }

    public List<MapdustBug> getMapdustBugList() {
        return this.mapdustBugList;
    }

    public MapdustBugFilter getFilter() {
        return this.filter;
    }
}

