/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tracer2.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.tracer2.preferences.ServerParam;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ServerParamDialog
extends ExtendedDialog {
    private static final long serialVersionUID = -3229680217088662218L;
    private String[] m_astrTileSize = new String[]{"0.0001", "0.0002", "0.0004", "0.0008", "0.001", "0.002", "0.004", "0.008", "0.01"};
    private String[] m_astrResolution = new String[]{"512", "1024", "2048", "4096"};
    private String[] m_astrMode = new String[]{"boundary", "match color"};
    private String[] m_astrPointsPerCircle = new String[]{"0", "8", "12", "16", "20", "24", "32"};
    private ServerParam m_oParam;
    private JPanel m_oPanel = new JPanel(new GridBagLayout());
    private JTextField m_oName = new JTextField();
    private JTextField m_oDescription = new JTextField();
    private JTextArea m_oUrl = new JTextArea(5, 5);
    private JComboBox<String> m_oTileSize;
    private JComboBox<String> m_oResolution;
    private JComboBox<String> m_oMode;
    private JTextField m_oThreshold = new JTextField();
    private JComboBox<String> m_oPointsPerCircle;
    private JTextField m_oTag = new JTextField();
    private JTextField m_oPreferredValues = new JTextField();
    private JScrollPane m_oScrollpaneUrl;

    public ServerParam getServerParam() {
        return this.m_oParam;
    }

    private void addLabelled(String str, Component c) {
        JLabel label = new JLabel(str);
        this.m_oPanel.add((Component)label, GBC.std());
        label.setLabelFor(c);
        this.m_oPanel.add(c, GBC.eol().fill(2));
    }

    private void addGap() {
        JPanel p = new JPanel();
        p.setMinimumSize(new Dimension(10, 0));
        this.m_oPanel.add((Component)p, GBC.eol().fill(2));
    }

    private void load() {
        this.m_oName.setText(this.m_oParam.getName());
        this.m_oDescription.setText(this.m_oParam.getDescription());
        this.m_oUrl.setText(this.m_oParam.getUrl());
        this.loadComboBox(this.m_oTileSize, this.m_oParam.getTileSize(), this.m_astrTileSize);
        this.loadComboBox(this.m_oResolution, this.m_oParam.getResolution(), this.m_astrResolution);
        this.loadComboBox(this.m_oMode, this.m_oParam.getMode(), this.m_astrMode);
        this.m_oThreshold.setText(this.m_oParam.getThreshold());
        this.loadComboBox(this.m_oPointsPerCircle, this.m_oParam.getPointsPerCircle(), this.m_astrPointsPerCircle);
        this.m_oTag.setText(this.m_oParam.getTag());
        this.m_oPreferredValues.setText(this.m_oParam.getPreferredValues());
    }

    private void save() {
        this.m_oParam.setName(this.m_oName.getText());
        this.m_oParam.setDescription(this.m_oDescription.getText());
        this.m_oParam.setUrl(this.m_oUrl.getText());
        this.m_oParam.setTileSize(this.saveComboBox(this.m_oTileSize, this.m_astrTileSize));
        this.m_oParam.setResolution(this.saveComboBox(this.m_oResolution, this.m_astrResolution));
        this.m_oParam.setMode(this.saveComboBox(this.m_oMode, this.m_astrMode));
        this.m_oParam.setThreshold(this.m_oThreshold.getText());
        this.m_oParam.setPointsPerCircle(this.saveComboBox(this.m_oPointsPerCircle, this.m_astrPointsPerCircle));
        this.m_oParam.setTag(this.m_oTag.getText());
        this.m_oParam.setPreferredValues(this.m_oPreferredValues.getText());
    }

    private void loadComboBox(JComboBox<?> c, String strValue, String[] astrValues) {
        int pos = 0;
        for (String str : astrValues) {
            if (strValue.equals(str)) {
                c.setSelectedIndex(pos);
                return;
            }
            ++pos;
        }
    }

    private String saveComboBox(JComboBox<?> c, String[] astrValues) {
        return astrValues[c.getSelectedIndex()];
    }

    public ServerParamDialog(ServerParam param) {
        super(Main.parent, I18n.tr((String)"Tracer2", (Object[])new Object[0]) + " - " + I18n.tr((String)"Parameter for server request", (Object[])new Object[0]), new String[]{I18n.tr((String)"OK", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, true);
        this.m_oParam = param == null ? new ServerParam() : param;
        this.contentInsets = new Insets(15, 15, 5, 15);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.m_oTileSize = new JComboBox<String>(this.m_astrTileSize);
        this.m_oResolution = new JComboBox<String>(this.m_astrResolution);
        this.m_oMode = new JComboBox<String>(this.m_astrMode);
        this.m_oPointsPerCircle = new JComboBox<String>(this.m_astrPointsPerCircle);
        this.load();
        this.addLabelled(I18n.tr((String)"Name:", (Object[])new Object[0]), this.m_oName);
        this.addLabelled(I18n.tr((String)"Description:", (Object[])new Object[0]), this.m_oDescription);
        this.addGap();
        this.m_oUrl.setLineWrap(true);
        this.m_oScrollpaneUrl = new JScrollPane(this.m_oUrl);
        this.addLabelled(I18n.tr((String)"URL:", (Object[])new Object[0]), this.m_oScrollpaneUrl);
        this.addGap();
        this.addLabelled(I18n.tr((String)"Tile size:", (Object[])new Object[0]), this.m_oTileSize);
        this.addLabelled(I18n.tr((String)"Resolution:", (Object[])new Object[0]), this.m_oResolution);
        this.addGap();
        this.addLabelled(I18n.tr((String)"Mode:", (Object[])new Object[0]), this.m_oMode);
        this.addLabelled(I18n.tr((String)"Threshold:", (Object[])new Object[0]), this.m_oThreshold);
        this.addGap();
        this.addLabelled(I18n.tr((String)"Points per circle:", (Object[])new Object[0]), this.m_oPointsPerCircle);
        this.addGap();
        this.addLabelled(I18n.tr((String)"Tag:", (Object[])new Object[0]), this.m_oTag);
        this.addLabelled(I18n.tr((String)"Preferred values:", (Object[])new Object[0]), this.m_oPreferredValues);
        this.setMinimumSize(new Dimension(500, 0));
        this.setContent(this.m_oPanel);
        this.setupDialog();
    }

    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        if (evt.getActionCommand().equals(I18n.tr((String)"OK", (Object[])new Object[0]))) {
            this.save();
        } else {
            this.m_oParam = null;
        }
        super.buttonAction(buttonIndex, evt);
    }
}

