/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.extractor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.container.OSMNode;
import org.openstreetmap.josm.plugins.container.OSMRelation;
import org.openstreetmap.josm.plugins.container.OSMWay;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FrequenceExtractor
extends DefaultHandler {
    private final List<OSMNode> nodeList;
    private final List<OSMRelation> relationList;
    private final Map<String, OSMNode> nodesWithIDs;
    private final List<OSMWay> wayList;
    private final String osmXmlFileName;
    private OSMNode nodeTmp;
    private OSMWay wayTmp;
    private OSMRelation relationTmp;
    private boolean inWay = false;
    private boolean inNode = false;
    private boolean inRelation = false;
    private Map<String, Integer> frequency;

    public FrequenceExtractor(String osmXmlFileName) {
        this.osmXmlFileName = osmXmlFileName;
        this.nodeList = new ArrayList<OSMNode>();
        this.wayList = new ArrayList<OSMWay>();
        this.relationList = new ArrayList<OSMRelation>();
        this.nodesWithIDs = new HashMap<String, OSMNode>();
        this.frequency = new HashMap<String, Integer>();
        for (int i = 0; i < 100; ++i) {
            this.frequency.put("", 0);
        }
    }

    public void parseDocument() {
        Main.info((String)"extracting frequencies...");
        try {
            Utils.newSafeSAXParser().parse(this.osmXmlFileName, (DefaultHandler)this);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Main.error((Throwable)e);
        }
    }

    @Override
    public void startElement(String s, String s1, String elementName, Attributes attributes) throws SAXException {
        if (elementName.equalsIgnoreCase("node")) {
            this.nodeTmp = new OSMNode();
            this.inNode = true;
            this.inWay = false;
            this.inRelation = false;
        } else if (elementName.equalsIgnoreCase("way")) {
            this.wayTmp = new OSMWay();
            this.inWay = true;
            this.inNode = false;
            this.inRelation = false;
        } else if (elementName.equalsIgnoreCase("relation")) {
            this.relationTmp = new OSMRelation();
            this.inRelation = true;
            this.inWay = false;
            this.inNode = false;
        } else if (!elementName.equalsIgnoreCase("nd")) {
            if (elementName.equalsIgnoreCase("tag")) {
                if (this.inNode) {
                    this.nodeTmp.setTagKeyValue(attributes.getValue("k"), attributes.getValue("v"));
                } else if (this.inWay) {
                    this.wayTmp.setTagKeyValue(attributes.getValue("k"), attributes.getValue("v"));
                } else if (this.inRelation) {
                    this.relationTmp.setTagKeyValue(attributes.getValue("k"), attributes.getValue("v"));
                }
            } else if (elementName.equalsIgnoreCase("member")) {
                // empty if block
            }
        }
    }

    @Override
    public void endElement(String s, String s1, String element) throws SAXException {
        int k;
        String[] SplitName;
        String name;
        Map<String, String> tags;
        if (element.equalsIgnoreCase("node") && (tags = this.nodeTmp.getTagKeyValue()).keySet().contains("name")) {
            for (Map.Entry<String, String> tag : tags.entrySet()) {
                if (!tag.getKey().equals("name")) continue;
                name = tag.getValue();
                for (String split : SplitName = name.split("\\s+")) {
                    if (this.frequency.get(split) != null) {
                        k = this.frequency.get(split) + 1;
                        this.frequency.put(split, k);
                        continue;
                    }
                    this.frequency.put(split, 1);
                }
            }
        }
        if (element.equalsIgnoreCase("way") && (tags = this.wayTmp.getTagKeyValue()).keySet().contains("name")) {
            for (Map.Entry<String, String> tag : tags.entrySet()) {
                if (!tag.getKey().equals("name")) continue;
                name = tag.getValue();
                for (String split : SplitName = name.split("\\s+")) {
                    if (this.frequency.get(split) != null) {
                        k = this.frequency.get(split) + 1;
                        this.frequency.put(split, k);
                        continue;
                    }
                    this.frequency.put(split, 1);
                }
            }
        }
        if (element.equalsIgnoreCase("relation") && (tags = this.relationTmp.getTagKeyValue()).keySet().contains("name")) {
            for (Map.Entry<String, String> tag : tags.entrySet()) {
                if (!tag.getKey().equals("name")) continue;
                name = tag.getValue();
                for (String split : SplitName = name.split("\\s+")) {
                    if (this.frequency.get(split) != null) {
                        k = this.frequency.get(split) + 1;
                        this.frequency.put(split, k);
                        continue;
                    }
                    this.frequency.put(split, 1);
                }
            }
        }
    }

    public List<OSMNode> getNodeList() {
        return this.nodeList;
    }

    public List<OSMWay> getWayList() {
        return this.wayList;
    }

    public List<OSMRelation> getRelationList() {
        return this.relationList;
    }

    public Map<String, OSMNode> getNodesWithIDs() {
        return this.nodesWithIDs;
    }

    public Map<String, Integer> getFrequency() {
        return this.frequency;
    }
}

