/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.directdownload;

import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.directdownload.DownloadDataGui;
import org.openstreetmap.josm.plugins.directdownload.GpxServerReader;
import org.openstreetmap.josm.plugins.directdownload.UserTrack;
import org.openstreetmap.josm.tools.I18n;

public class DirectDownload
extends Plugin {
    private DownloadAction openaction = new DownloadAction();

    public DirectDownload(PluginInformation info) {
        super(info);
        MainMenu.add((JMenu)Main.main.menu.gpsMenu, (JosmAction)this.openaction);
    }

    class DownloadAction
    extends JosmAction {
        public DownloadAction() {
            super(I18n.tr((String)"Download Track ...", (Object[])new Object[0]), "DownloadAction", I18n.tr((String)"Download GPX track from openstreetmap.org", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent event) {
            DownloadDataGui go = new DownloadDataGui();
            go.setVisible(true);
            UserTrack track = go.getSelectedUserTrack();
            if (go.getValue() != 1 || track == null) {
                return;
            }
            GpxData data = new GpxServerReader().loadGpx(Long.parseLong(track.id));
            if (data == null) {
                return;
            }
            GpxLayer gpxLayer = new GpxLayer(data);
            if (data.hasRoutePoints() || data.hasTrackPoints()) {
                Main.main.addLayer((Layer)gpxLayer);
            }
            if (Main.pref.getBoolean("marker.makeautomarkers", true) && !data.waypoints.isEmpty()) {
                MarkerLayer ml = new MarkerLayer(data, I18n.tr((String)"Markers from {0}", (Object[])new Object[]{track.filename}), null, gpxLayer);
                if (ml.data.size() > 0) {
                    Main.main.addLayer((Layer)ml);
                }
            }
        }
    }
}

