/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.PropertyGeneratorImpl;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.operator.ConstantDescriptor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.operation.ExtendedRandomIter;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.referencing.CRS;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.util.Utilities;
import org.jaitools.imageutils.ImageLayout2;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class GridCoverage2DRIA
extends GeometricOpImage {
    private static final Logger LOGGER = Logger.getLogger(GridCoverage2DRIA.class.getName());
    private final GridCoverage2D src;
    private final GridGeometry2D dst;
    private final MathTransform g2wd;
    private final MathTransform g2ws;
    private final MathTransform w2gd;
    private final MathTransform w2gs;
    private final MathTransform src2dstCRSTransform;
    private final MathTransform dst2srcCRSTransform;
    private byte[][] ctable = null;
    private ROI roi;
    private boolean hasROI;
    private Rectangle roiBounds;
    private PlanarImage roiImage;

    public static GridCoverage2DRIA create(GridCoverage2D src, GridGeometry2D dst, double[] nodata) {
        return GridCoverage2DRIA.create(src, dst, nodata, null, null);
    }

    public static GridCoverage2DRIA create(GridCoverage2D src, GridCoverage2D dst, double[] nodata) {
        return GridCoverage2DRIA.create(src, dst, nodata, null, null);
    }

    public static GridCoverage2DRIA create(GridCoverage2D src, GridGeometry2D dst, double[] nodata, Hints hints) {
        return GridCoverage2DRIA.create(src, dst, nodata, hints, null);
    }

    public static GridCoverage2DRIA create(GridCoverage2D src, GridGeometry2D dst, double[] nodata, Hints hints, ROI roi) {
        ImageLayout l;
        Utilities.ensureNonNull("dst", dst);
        GridEnvelope2D destinationRasterDimension = dst.getGridRange2D();
        ImageLayout imageLayout = new ImageLayout();
        imageLayout.setMinX(destinationRasterDimension.x).setMinY(destinationRasterDimension.y);
        imageLayout.setWidth(destinationRasterDimension.width).setHeight(destinationRasterDimension.height);
        imageLayout.setColorModel(src.getRenderedImage().getColorModel());
        imageLayout.setSampleModel(src.getRenderedImage().getSampleModel());
        if (hints != null && hints.containsKey(JAI.KEY_IMAGE_LAYOUT) && (l = (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT)).isValid(128) && l.isValid(64)) {
            imageLayout.setTileHeight(Math.min(imageLayout.getHeight(null), l.getTileHeight(null)));
            imageLayout.setTileWidth(Math.min(imageLayout.getWidth(null), l.getTileWidth(null)));
        }
        BorderExtenderConstant extender = new BorderExtenderConstant(new double[]{nodata != null ? nodata[0] : 0.0});
        ROI property = CoverageUtilities.getROIProperty(src);
        if (property != null) {
            roi = roi != null ? roi.intersect(property) : property;
        }
        return new GridCoverage2DRIA(src, dst, GridCoverage2DRIA.vectorize(src.getRenderedImage()), imageLayout, null, false, extender, Interpolation.getInstance(0), nodata, roi, hints);
    }

    public static GridCoverage2DRIA create(GridCoverage2D src, GridCoverage2D dst, double[] nodata, Hints hints, ROI roi) {
        ImageLayout imageLayout = new ImageLayout(dst.getRenderedImage());
        imageLayout.setColorModel(src.getRenderedImage().getColorModel());
        imageLayout.setSampleModel(src.getRenderedImage().getSampleModel());
        BorderExtenderConstant extender = new BorderExtenderConstant(new double[]{nodata != null ? nodata[0] : 0.0});
        ROI property = CoverageUtilities.getROIProperty(src);
        if (property != null) {
            roi = roi != null ? roi.intersect(property) : property;
        }
        return new GridCoverage2DRIA(src, dst.getGridGeometry(), GridCoverage2DRIA.vectorize(src.getRenderedImage()), imageLayout, null, false, extender, Interpolation.getInstance(0), nodata, roi, hints);
    }

    protected GridCoverage2DRIA(GridCoverage2D src, GridGeometry2D dst, Vector sources, ImageLayout layout, Map configuration, boolean cobbleSources, BorderExtender extender, Interpolation interp, double[] nodata, ROI roi, Hints hints) {
        super(sources, layout, configuration, cobbleSources, extender, interp, nodata);
        this.src = src;
        this.dst = dst;
        this.g2wd = dst.getGridToCRS2D(PixelOrientation.UPPER_LEFT);
        try {
            this.w2gd = this.g2wd.inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("Can't compute destination W2G", e);
        }
        this.g2ws = src.getGridGeometry().getGridToCRS2D(PixelOrientation.UPPER_LEFT);
        try {
            this.w2gs = this.g2ws.inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("Can't compute source W2G", e);
        }
        try {
            CoordinateReferenceSystem sourceCRS = src.getCoordinateReferenceSystem2D();
            CoordinateReferenceSystem targetCRS = dst.getCoordinateReferenceSystem2D();
            this.src2dstCRSTransform = CRS.findMathTransform(sourceCRS, targetCRS, true);
            this.dst2srcCRSTransform = this.src2dstCRSTransform.inverse();
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException("Can't create a transform between CRS", e);
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("Can't create a transform between CRS", e);
        }
        this.roi = roi;
        boolean bl = this.hasROI = roi != null;
        if (this.hasROI) {
            this.roiBounds = roi.getBounds();
            this.setProperty("roi", roi);
        }
        if (hints != null) {
            TileCache tc = (TileCache)hints.get(JAI.KEY_TILE_CACHE);
            if (tc != null) {
                this.setTileCache(tc);
            } else {
                this.setTileCache(JAI.getDefaultInstance().getTileCache());
            }
        }
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        return super.getTile(tileX, tileY);
    }

    @Override
    public Point2D mapSourcePoint(Point2D srcPt, int sourceIndex) {
        if (srcPt == null) {
            throw new IllegalArgumentException("Bad dest pt");
        }
        if (sourceIndex < 0 || sourceIndex >= this.getNumSources()) {
            throw new IndexOutOfBoundsException("Bad src");
        }
        double[] coords = new double[]{srcPt.getX(), srcPt.getY()};
        try {
            this.mapSrcPoint(coords);
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, "Error transforming coords", e);
            return null;
        }
        Point2D ret = (Point2D)srcPt.clone();
        ret.setLocation(coords[0], coords[1]);
        if (GridCoverage2DRIA.inside(ret, this.src.getRenderedImage())) {
            return ret;
        }
        LOGGER.log(Level.WARNING, "{0} mapped to {1} lies outside {2},{3}+{4}x{5}", new Object[]{srcPt, ret, this.src.getRenderedImage().getMinX(), this.src.getRenderedImage().getMinX(), this.src.getRenderedImage().getWidth(), this.src.getRenderedImage().getHeight()});
        return null;
    }

    private static boolean inside(Point2D point, RenderedImage ri) {
        double x = point.getX();
        double y = point.getY();
        return x >= (double)ri.getMinX() && x <= (double)(ri.getMinX() + ri.getWidth()) && y >= (double)ri.getMinY() && y <= (double)(ri.getMinY() + ri.getHeight());
    }

    @Override
    protected Rectangle forwardMapRect(Rectangle pxRect, int i) {
        float[] pts = GridCoverage2DRIA.rect2PointArr(pxRect);
        try {
            this.g2wd.transform(pts, 0, pts, 0, 4);
            this.dst2srcCRSTransform.transform(pts, 0, pts, 0, 4);
            this.w2gs.transform(pts, 0, pts, 0, 4);
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, "Error transforming coords", e);
            return null;
        }
        Rectangle srcRect = this.pointArr2Rect(pts);
        return srcRect;
    }

    @Override
    public Point2D mapDestPoint(Point2D destPt, int sourceIndex) {
        if (destPt == null) {
            throw new IllegalArgumentException("Bad dest pt");
        }
        if (sourceIndex < 0 || sourceIndex >= this.getNumSources()) {
            throw new IndexOutOfBoundsException("Bad src");
        }
        double[] coords = new double[]{destPt.getX(), destPt.getY()};
        try {
            this.mapDestPoint(coords);
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, "Error transforming coords", e);
            return null;
        }
        Point2D ret = (Point2D)destPt.clone();
        ret.setLocation(coords[0], coords[1]);
        if (this.dst.getEnvelope2D().contains(ret)) {
            return ret;
        }
        return null;
    }

    private void mapDestPoint(double[] coords) throws TransformException {
        int npoints = coords.length / 2;
        this.g2ws.transform(coords, 0, coords, 0, npoints);
        this.src2dstCRSTransform.transform(coords, 0, coords, 0, npoints);
        this.w2gd.transform(coords, 0, coords, 0, npoints);
    }

    private void mapSrcPoint(double[] coords) throws TransformException {
        int npoints = coords.length / 2;
        this.g2wd.transform(coords, 0, coords, 0, npoints);
        this.dst2srcCRSTransform.transform(coords, 0, coords, 0, npoints);
        this.w2gs.transform(coords, 0, coords, 0, npoints);
    }

    @Override
    protected Rectangle backwardMapRect(Rectangle destRect, int sourceIndex) {
        float[] pts = GridCoverage2DRIA.rect2PointArr(destRect);
        try {
            this.g2ws.transform(pts, 0, pts, 0, 4);
            this.src2dstCRSTransform.transform(pts, 0, pts, 0, 4);
            this.w2gd.transform(pts, 0, pts, 0, 4);
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, "Error transforming coords", e);
            return null;
        }
        Rectangle pxRect = this.pointArr2Rect(pts);
        return pxRect;
    }

    private static float[] rect2PointArr(Rectangle rect) {
        float dx0 = rect.x;
        float dy0 = rect.y;
        float dw = rect.width;
        float dh = rect.height;
        return new float[]{dx0, dy0, dx0 + dw, dy0, dx0 + dw, dy0 + dh, dx0, dy0 + dh};
    }

    private Rectangle pointArr2Rect(float[] points) {
        float f_sx0 = Float.MAX_VALUE;
        float f_sy0 = Float.MAX_VALUE;
        float f_sx1 = -3.4028235E38f;
        float f_sy1 = -3.4028235E38f;
        for (int i = 0; i < 4; ++i) {
            float px = points[i * 2];
            float py = points[i * 2 + 1];
            f_sx0 = Math.min(f_sx0, px);
            f_sy0 = Math.min(f_sy0, py);
            f_sx1 = Math.max(f_sx1, px);
            f_sy1 = Math.max(f_sy1, py);
        }
        int s_x0 = 0;
        int s_y0 = 0;
        int s_x1 = 0;
        int s_y1 = 0;
        if (this.interp instanceof InterpolationNearest) {
            s_x0 = (int)Math.floor(f_sx0);
            s_y0 = (int)Math.floor(f_sy0);
            s_x1 = (int)Math.ceil((double)f_sx1 + 0.5);
            s_y1 = (int)Math.ceil((double)f_sy1 + 0.5);
        } else {
            s_x0 = (int)Math.floor((double)f_sx0 - 0.5);
            s_y0 = (int)Math.floor((double)f_sy0 - 0.5);
            s_x1 = (int)Math.ceil(f_sx1);
            s_y1 = (int)Math.ceil(f_sy1);
        }
        return new Rectangle(s_x0, s_y0, s_x1 - s_x0, s_y1 - s_y0);
    }

    @Override
    protected void computeRect(PlanarImage[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag formatTag = this.getFormatTags()[1];
        RasterAccessor d = new RasterAccessor(dest, destRect, formatTag, this.getColorModel());
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        if (this.hasROI) {
            Rectangle srcRectExpanded = null;
            int x = (int)destRect.getMinX();
            int y = (int)destRect.getMinY();
            int w = (int)destRect.getWidth();
            int h = (int)destRect.getHeight();
            float[] src = new float[w * h * 2];
            this.warpRect(x, y, w, h, src);
            double minX = Double.POSITIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            int numP = src.length;
            for (int i = 0; i < numP; i += 2) {
                float xi = src[i];
                float yi = src[i + 1];
                minX = (double)xi < minX ? (double)xi : minX;
                minY = (double)yi < minY ? (double)yi : minY;
                maxX = (double)xi > maxX ? (double)xi : maxX;
                maxY = (double)yi > maxY ? (double)yi : maxY;
            }
            srcRectExpanded = new Rectangle((int)minX, (int)minY, (int)(maxX - minX) + 1, (int)(maxY - minY) + 1);
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - (double)this.interp.getLeftPadding(), srcRectExpanded.getMinY() - (double)this.interp.getTopPadding(), srcRectExpanded.getWidth() + (double)this.interp.getRightPadding() + (double)this.interp.getLeftPadding(), srcRectExpanded.getHeight() + (double)this.interp.getBottomPadding() + (double)this.interp.getTopPadding());
            if (!this.roiBounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                roiContainsTile = this.roi.contains(srcRectExpanded);
                if (!roiContainsTile) {
                    if (!this.roi.intersects(srcRectExpanded)) {
                        roiDisjointTile = true;
                    } else {
                        PlanarImage roiIMG = this.getImage();
                        roiIter = RandomIterFactory.create((RenderedImage)roiIMG, null, (boolean)true, (boolean)true);
                    }
                }
            }
        }
        if (roiDisjointTile) {
            double[] bkg = this.setBackground ? this.backgroundValues : new double[dest.getNumBands()];
            ImageUtil.fillBackground(dest, destRect, bkg);
            return;
        }
        this.computeRect(sources[0], d, roiIter, roiContainsTile);
        if (d.isDataCopy()) {
            d.clampDataArrays();
            d.copyDataToRaster();
        }
    }

    private void computeRect(PlanarImage source, RasterAccessor d, RandomIter roiIter, boolean roiContainsTile) {
        switch (d.getDataType()) {
            case 0: {
                this.computeRectByte(source, d, roiIter, roiContainsTile);
                break;
            }
            case 1: {
                this.computeRectUShort(source, d, roiIter, roiContainsTile);
                break;
            }
            case 2: {
                this.computeRectShort(source, d, roiIter, roiContainsTile);
                break;
            }
            case 3: {
                this.computeRectInt(source, d, roiIter, roiContainsTile);
                break;
            }
            case 4: {
                this.computeRectFloat(source, d, roiIter, roiContainsTile);
                break;
            }
            case 5: {
                this.computeRectDouble(source, d, roiIter, roiContainsTile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeRectByte(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        block28: {
            int bpad;
            int tpad;
            int rpad;
            int lpad;
            if (this.interp != null) {
                lpad = this.interp.getLeftPadding();
                rpad = this.interp.getRightPadding();
                tpad = this.interp.getTopPadding();
                bpad = this.interp.getBottomPadding();
            } else {
                bpad = 0;
                tpad = 0;
                rpad = 0;
                lpad = 0;
            }
            RandomIter iter = null;
            try {
                int h;
                int maxY;
                int minY;
                int maxX;
                int minX;
                if (this.extender != null) {
                    minX = src.getMinX();
                    maxX = src.getMaxX();
                    minY = src.getMinY();
                    maxY = src.getMaxY();
                    iter = this.getRandomIterator(src, lpad, rpad, tpad, bpad, this.extender);
                } else {
                    minX = src.getMinX() + lpad;
                    maxX = src.getMaxX() - rpad;
                    minY = src.getMinY() + tpad;
                    maxY = src.getMaxY() - bpad;
                    iter = this.getRandomIterator(src);
                }
                int kwidth = this.interp.getWidth();
                int kheight = this.interp.getHeight();
                int dstWidth = dst.getWidth();
                int dstHeight = dst.getHeight();
                int dstBands = dst.getNumBands();
                int lineStride = dst.getScanlineStride();
                int pixelStride = dst.getPixelStride();
                int[] bandOffsets = dst.getBandOffsets();
                byte[][] data = dst.getByteDataArrays();
                int precH = 1 << this.interp.getSubsampleBitsH();
                int precV = 1 << this.interp.getSubsampleBitsV();
                float[] warpData = new float[2 * dstWidth];
                int[][] samples = new int[kheight][kwidth];
                int lineOffset = 0;
                byte[] backgroundByte = new byte[dstBands];
                for (int i = 0; i < dstBands; ++i) {
                    backgroundByte[i] = (byte)this.backgroundValues[i];
                }
                if (this.ctable == null) {
                    for (h = 0; h < dstHeight; ++h) {
                        int pixelOffset = lineOffset;
                        lineOffset += lineStride;
                        this.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                        int count = 0;
                        for (int w = 0; w < dstWidth; ++w) {
                            int b;
                            float sx = warpData[count++];
                            float sy = warpData[count++];
                            int xint = GridCoverage2DRIA.floor(sx);
                            int yint = GridCoverage2DRIA.floor(sy);
                            int xfrac = (int)((sx - (float)xint) * (float)precH);
                            int yfrac = (int)((sy - (float)yint) * (float)precV);
                            if (xint < minX || xint >= maxX || yint < minY || yint >= maxY || !this.inROI(xint, yint, roiIter, roiContainsTile)) {
                                if (this.setBackground) {
                                    for (b = 0; b < dstBands; ++b) {
                                        data[b][pixelOffset + bandOffsets[b]] = backgroundByte[b];
                                    }
                                }
                            } else {
                                xint -= lpad;
                                yint -= tpad;
                                for (b = 0; b < dstBands; ++b) {
                                    for (int j = 0; j < kheight; ++j) {
                                        for (int i = 0; i < kwidth; ++i) {
                                            samples[j][i] = iter.getSample(xint + i, yint + j, b) & 0xFF;
                                        }
                                    }
                                    data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampByte(this.interp.interpolate(samples, xfrac, yfrac));
                                }
                            }
                            pixelOffset += pixelStride;
                        }
                    }
                    break block28;
                }
                for (h = 0; h < dstHeight; ++h) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        int b;
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = GridCoverage2DRIA.floor(sx);
                        int yint = GridCoverage2DRIA.floor(sy);
                        int xfrac = (int)((sx - (float)xint) * (float)precH);
                        int yfrac = (int)((sy - (float)yint) * (float)precV);
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY || !this.inROI(xint, yint, roiIter, roiContainsTile)) {
                            if (this.setBackground) {
                                for (b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = backgroundByte[b];
                                }
                            }
                        } else {
                            xint -= lpad;
                            yint -= tpad;
                            for (b = 0; b < dstBands; ++b) {
                                byte[] t = this.ctable[b];
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = t[iter.getSample(xint + i, yint + j, 0) & 0xFF] & 0xFF;
                                    }
                                }
                                data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampByte(this.interp.interpolate(samples, xfrac, yfrac));
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            }
            finally {
                if (iter != null) {
                    iter.done();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeRectUShort(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int bpad;
        int tpad;
        int rpad;
        int lpad;
        if (this.interp != null) {
            lpad = this.interp.getLeftPadding();
            rpad = this.interp.getRightPadding();
            tpad = this.interp.getTopPadding();
            bpad = this.interp.getBottomPadding();
        } else {
            bpad = 0;
            tpad = 0;
            rpad = 0;
            lpad = 0;
        }
        RandomIter iter = null;
        try {
            int maxY;
            int minY;
            int maxX;
            int minX;
            if (this.extender != null) {
                minX = src.getMinX();
                maxX = src.getMaxX();
                minY = src.getMinY();
                maxY = src.getMaxY();
                iter = this.getRandomIterator(src, lpad, rpad, tpad, bpad, this.extender);
            } else {
                minX = src.getMinX() + lpad;
                maxX = src.getMaxX() - rpad;
                minY = src.getMinY() + tpad;
                maxY = src.getMaxY() - bpad;
                iter = this.getRandomIterator(src);
            }
            int kwidth = this.interp.getWidth();
            int kheight = this.interp.getHeight();
            int dstWidth = dst.getWidth();
            int dstHeight = dst.getHeight();
            int dstBands = dst.getNumBands();
            int lineStride = dst.getScanlineStride();
            int pixelStride = dst.getPixelStride();
            int[] bandOffsets = dst.getBandOffsets();
            short[][] data = dst.getShortDataArrays();
            int precH = 1 << this.interp.getSubsampleBitsH();
            int precV = 1 << this.interp.getSubsampleBitsV();
            float[] warpData = new float[2 * dstWidth];
            int[][] samples = new int[kheight][kwidth];
            int lineOffset = 0;
            short[] backgroundUShort = new short[dstBands];
            for (int i = 0; i < dstBands; ++i) {
                backgroundUShort[i] = (short)this.backgroundValues[i];
            }
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = GridCoverage2DRIA.floor(sx);
                    int yint = GridCoverage2DRIA.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY || !this.inROI(xint, yint, roiIter, roiContainsTile)) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = backgroundUShort[b];
                            }
                        }
                    } else {
                        xint -= lpad;
                        yint -= tpad;
                        for (b = 0; b < dstBands; ++b) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = iter.getSample(xint + i, yint + j, b) & 0xFFFF;
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampUShort(this.interp.interpolate(samples, xfrac, yfrac));
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        finally {
            if (iter != null) {
                iter.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeRectShort(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int bpad;
        int tpad;
        int rpad;
        int lpad;
        if (this.interp != null) {
            lpad = this.interp.getLeftPadding();
            rpad = this.interp.getRightPadding();
            tpad = this.interp.getTopPadding();
            bpad = this.interp.getBottomPadding();
        } else {
            bpad = 0;
            tpad = 0;
            rpad = 0;
            lpad = 0;
        }
        RandomIter iter = null;
        try {
            int maxY;
            int minY;
            int maxX;
            int minX;
            if (this.extender != null) {
                minX = src.getMinX();
                maxX = src.getMaxX();
                minY = src.getMinY();
                maxY = src.getMaxY();
                iter = this.getRandomIterator(src, lpad, rpad, tpad, bpad, this.extender);
            } else {
                minX = src.getMinX() + lpad;
                maxX = src.getMaxX() - rpad;
                minY = src.getMinY() + tpad;
                maxY = src.getMaxY() - bpad;
                iter = this.getRandomIterator(src);
            }
            int kwidth = this.interp.getWidth();
            int kheight = this.interp.getHeight();
            int dstWidth = dst.getWidth();
            int dstHeight = dst.getHeight();
            int dstBands = dst.getNumBands();
            int lineStride = dst.getScanlineStride();
            int pixelStride = dst.getPixelStride();
            int[] bandOffsets = dst.getBandOffsets();
            short[][] data = dst.getShortDataArrays();
            int precH = 1 << this.interp.getSubsampleBitsH();
            int precV = 1 << this.interp.getSubsampleBitsV();
            float[] warpData = new float[2 * dstWidth];
            int[][] samples = new int[kheight][kwidth];
            int lineOffset = 0;
            short[] backgroundShort = new short[dstBands];
            for (int i = 0; i < dstBands; ++i) {
                backgroundShort[i] = (short)this.backgroundValues[i];
            }
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = GridCoverage2DRIA.floor(sx);
                    int yint = GridCoverage2DRIA.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY || !this.inROI(xint, yint, roiIter, roiContainsTile)) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = backgroundShort[b];
                            }
                        }
                    } else {
                        xint -= lpad;
                        yint -= tpad;
                        for (b = 0; b < dstBands; ++b) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = iter.getSample(xint + i, yint + j, b);
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampShort(this.interp.interpolate(samples, xfrac, yfrac));
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        finally {
            if (iter != null) {
                iter.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeRectInt(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int bpad;
        int tpad;
        int rpad;
        int lpad;
        if (this.interp != null) {
            lpad = this.interp.getLeftPadding();
            rpad = this.interp.getRightPadding();
            tpad = this.interp.getTopPadding();
            bpad = this.interp.getBottomPadding();
        } else {
            bpad = 0;
            tpad = 0;
            rpad = 0;
            lpad = 0;
        }
        RandomIter iter = null;
        try {
            int maxY;
            int minY;
            int maxX;
            int minX;
            if (this.extender != null) {
                minX = src.getMinX();
                maxX = src.getMaxX();
                minY = src.getMinY();
                maxY = src.getMaxY();
                iter = this.getRandomIterator(src, lpad, rpad, tpad, bpad, this.extender);
            } else {
                minX = src.getMinX() + lpad;
                maxX = src.getMaxX() - rpad;
                minY = src.getMinY() + tpad;
                maxY = src.getMaxY() - bpad;
                iter = this.getRandomIterator(src);
            }
            int kwidth = this.interp.getWidth();
            int kheight = this.interp.getHeight();
            int dstWidth = dst.getWidth();
            int dstHeight = dst.getHeight();
            int dstBands = dst.getNumBands();
            int lineStride = dst.getScanlineStride();
            int pixelStride = dst.getPixelStride();
            int[] bandOffsets = dst.getBandOffsets();
            int[][] data = dst.getIntDataArrays();
            int precH = 1 << this.interp.getSubsampleBitsH();
            int precV = 1 << this.interp.getSubsampleBitsV();
            float[] warpData = new float[2 * dstWidth];
            int[][] samples = new int[kheight][kwidth];
            int lineOffset = 0;
            int[] backgroundInt = new int[dstBands];
            for (int i = 0; i < dstBands; ++i) {
                backgroundInt[i] = (int)this.backgroundValues[i];
            }
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = GridCoverage2DRIA.floor(sx);
                    int yint = GridCoverage2DRIA.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY || !this.inROI(xint, yint, roiIter, roiContainsTile)) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = backgroundInt[b];
                            }
                        }
                    } else {
                        xint -= lpad;
                        yint -= tpad;
                        for (b = 0; b < dstBands; ++b) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = iter.getSample(xint + i, yint + j, b);
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        finally {
            if (iter != null) {
                iter.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeRectFloat(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int bpad;
        int tpad;
        int rpad;
        int lpad;
        if (this.interp != null) {
            lpad = this.interp.getLeftPadding();
            rpad = this.interp.getRightPadding();
            tpad = this.interp.getTopPadding();
            bpad = this.interp.getBottomPadding();
        } else {
            bpad = 0;
            tpad = 0;
            rpad = 0;
            lpad = 0;
        }
        RandomIter iter = null;
        try {
            int maxY;
            int minY;
            int maxX;
            int minX;
            if (this.extender != null) {
                minX = src.getMinX();
                maxX = src.getMaxX();
                minY = src.getMinY();
                maxY = src.getMaxY();
                iter = this.getRandomIterator(src, lpad, rpad, tpad, bpad, this.extender);
            } else {
                minX = src.getMinX() + lpad;
                maxX = src.getMaxX() - rpad;
                minY = src.getMinY() + tpad;
                maxY = src.getMaxY() - bpad;
                iter = this.getRandomIterator(src);
            }
            int kwidth = this.interp.getWidth();
            int kheight = this.interp.getHeight();
            int dstWidth = dst.getWidth();
            int dstHeight = dst.getHeight();
            int dstBands = dst.getNumBands();
            int lineStride = dst.getScanlineStride();
            int pixelStride = dst.getPixelStride();
            int[] bandOffsets = dst.getBandOffsets();
            float[][] data = dst.getFloatDataArrays();
            float[] warpData = new float[2 * dstWidth];
            float[][] samples = new float[kheight][kwidth];
            int lineOffset = 0;
            float[] backgroundFloat = new float[dstBands];
            for (int i = 0; i < dstBands; ++i) {
                backgroundFloat[i] = (float)this.backgroundValues[i];
            }
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = GridCoverage2DRIA.floor(sx);
                    int yint = GridCoverage2DRIA.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY || !this.inROI(xint, yint, roiIter, roiContainsTile)) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = backgroundFloat[b];
                            }
                        }
                    } else {
                        xint -= lpad;
                        yint -= tpad;
                        for (b = 0; b < dstBands; ++b) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = iter.getSampleFloat(xint + i, yint + j, b);
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        finally {
            if (iter != null) {
                iter.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeRectDouble(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int bpad;
        int tpad;
        int rpad;
        int lpad;
        if (this.interp != null) {
            lpad = this.interp.getLeftPadding();
            rpad = this.interp.getRightPadding();
            tpad = this.interp.getTopPadding();
            bpad = this.interp.getBottomPadding();
        } else {
            bpad = 0;
            tpad = 0;
            rpad = 0;
            lpad = 0;
        }
        RandomIter iter = null;
        try {
            int maxY;
            int minY;
            int maxX;
            int minX;
            if (this.extender != null) {
                minX = src.getMinX();
                maxX = src.getMaxX();
                minY = src.getMinY();
                maxY = src.getMaxY();
                iter = this.getRandomIterator(src, lpad, rpad, tpad, bpad, this.extender);
            } else {
                minX = src.getMinX() + lpad;
                maxX = src.getMaxX() - rpad;
                minY = src.getMinY() + tpad;
                maxY = src.getMaxY() - bpad;
                iter = this.getRandomIterator(src);
            }
            int kwidth = this.interp.getWidth();
            int kheight = this.interp.getHeight();
            int dstWidth = dst.getWidth();
            int dstHeight = dst.getHeight();
            int dstBands = dst.getNumBands();
            int lineStride = dst.getScanlineStride();
            int pixelStride = dst.getPixelStride();
            int[] bandOffsets = dst.getBandOffsets();
            double[][] data = dst.getDoubleDataArrays();
            float[] warpData = new float[2 * dstWidth];
            double[][] samples = new double[kheight][kwidth];
            int lineOffset = 0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = GridCoverage2DRIA.floor(sx);
                    int yint = GridCoverage2DRIA.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY || !this.inROI(xint, yint, roiIter, roiContainsTile)) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else {
                        xint -= lpad;
                        yint -= tpad;
                        for (b = 0; b < dstBands; ++b) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = iter.getSampleDouble(xint + i, yint + j, b);
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        finally {
            if (iter != null) {
                iter.done();
            }
        }
    }

    private static final int floor(float f) {
        return f >= 0.0f ? (int)f : (int)f - 1;
    }

    public float[] warpRect(int x, int y, int width, int height, float[] destRect) {
        if (destRect != null && destRect.length < width * height * 2) {
            throw new IllegalArgumentException("warpRect: bad destRect");
        }
        return this.warpSparseRect(x, y, width, height, 1, 1, destRect);
    }

    public float[] warpSparseRect(int x0, int y0, int width, int height, int periodX, int periodY, float[] destRect) {
        if (destRect == null) {
            destRect = new float[(width + periodX - 1) / periodX * ((height + periodY - 1) / periodY) * 2];
        }
        width += x0;
        height += y0;
        int index = 0;
        double[] xy = new double[2];
        for (int y = y0; y < height; y += periodY) {
            for (int x = x0; x < width; x += periodX) {
                xy[0] = x;
                xy[1] = y;
                try {
                    this.mapSrcPoint(xy);
                    destRect[index++] = (float)xy[0];
                    destRect[index++] = (float)xy[1];
                    continue;
                }
                catch (TransformException e) {
                    LOGGER.log(Level.WARNING, "Error transforming {0}", (Object)xy);
                    destRect[index++] = Float.NaN;
                    destRect[index++] = Float.NaN;
                }
            }
        }
        return destRect;
    }

    private RandomIter getRandomIterator(PlanarImage src) {
        return this.getRandomIterator(src, 0, 1, 0, 1, this.extender);
    }

    private RandomIter getRandomIterator(PlanarImage src, int leftPad, int rightPad, int topPad, int bottomPad, BorderExtender extender) {
        return ExtendedRandomIter.getRandomIterator(src, leftPad, rightPad, topPad, bottomPad, extender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanarImage getImage() {
        PlanarImage img = this.roiImage;
        if (img == null) {
            GridCoverage2DRIA gridCoverage2DRIA = this;
            synchronized (gridCoverage2DRIA) {
                img = this.roiImage;
                if (img == null) {
                    this.roiImage = img = this.roi.getAsImage();
                }
            }
        }
        return img;
    }

    private boolean inROI(int x, int y, RandomIter roiIter, boolean roiContainsTile) {
        if (this.hasROI) {
            if (roiContainsTile) {
                return true;
            }
            if (!this.roiBounds.contains(x, y)) {
                return false;
            }
            int sample = roiIter.getSample(x, y, 0);
            return sample > 0;
        }
        return true;
    }

    static class GridCoverage2DRIAPropertyGenerator
    extends PropertyGeneratorImpl {
        public GridCoverage2DRIAPropertyGenerator() {
            super(new String[]{"ROI"}, new Class[]{ROI.class}, new Class[]{GridCoverage2DRIA.class});
        }

        @Override
        public Object getProperty(String name, Object opNode) {
            this.validate(name, opNode);
            if (opNode instanceof GridCoverage2DRIA && name.equalsIgnoreCase("roi")) {
                GridCoverage2DRIA op = (GridCoverage2DRIA)opNode;
                RenderedImage src = op.src.getRenderedImage();
                Object property = op.getProperty("ROI");
                if (property == null || property.equals(Image.UndefinedProperty) || !(property instanceof ROI)) {
                    return Image.UndefinedProperty;
                }
                ROI srcROI = (ROI)property;
                if (srcROI.getBounds().isEmpty()) {
                    return Image.UndefinedProperty;
                }
                InterpolationNearest interp = (InterpolationNearest)Interpolation.getInstance(0);
                Rectangle srcBounds = null;
                GridCoverage2DRIA dst = op;
                srcBounds = dst instanceof GeometricOpImage && ((GeometricOpImage)dst).getBorderExtender() == null ? new Rectangle(src.getMinX() + interp.getLeftPadding(), src.getMinY() + interp.getTopPadding(), src.getWidth() - interp.getWidth() + 1, src.getHeight() - interp.getHeight() + 1) : new Rectangle(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight());
                if (!srcBounds.contains(srcROI.getBounds())) {
                    srcROI = srcROI.intersect(new ROIShape(srcBounds));
                }
                Rectangle dstBounds = op.getBounds();
                ImageLayout2 layout = new ImageLayout2();
                int minx = (int)srcBounds.getMinX();
                int miny = (int)srcBounds.getMinY();
                int w = (int)srcBounds.getWidth();
                int h = (int)srcBounds.getHeight();
                layout.setMinX(minx);
                layout.setMinY(miny);
                layout.setWidth(w);
                layout.setHeight(h);
                RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
                RenderedOp constantImage = ConstantDescriptor.create(new Float(w), new Float(h), new Byte[]{(byte)-1}, hints);
                GridCoverage2D input = new GridCoverageFactory(GeoTools.getDefaultHints()).create((CharSequence)name, constantImage, op.src.getEnvelope());
                GridCoverage2DRIA roiImage = null;
                roiImage = GridCoverage2DRIA.create(input, op.dst, new double[]{0.0}, null, srcROI);
                ROI dstROI = new ROI(roiImage, 1);
                if (!dstBounds.contains(dstROI.getBounds())) {
                    dstROI = dstROI.intersect(new ROIShape(dstBounds));
                }
                return dstROI;
            }
            return Image.UndefinedProperty;
        }
    }
}

