/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SelectCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.Checker;
import org.openstreetmap.josm.tools.I18n;

public class WayChecker
extends Checker {
    public WayChecker(Relation relation, Test test) {
        super(relation, test);
    }

    protected void performRoadTypeTest() {
        if (!(this.relation.hasTag("route", "bus") || this.relation.hasTag("route", "trolleybus") || this.relation.hasTag("route", "share_taxi"))) {
            return;
        }
        for (RelationMember rm : this.relation.getMembers()) {
            TestError e;
            ArrayList<Way> highlighted;
            ArrayList<Relation> primitives;
            if (!RouteUtils.isPTWay(rm) || !rm.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
            Way way = rm.getWay();
            boolean isCorrectRoadType = true;
            boolean isUnderConstruction = false;
            if (this.relation.hasTag("route", "bus") || this.relation.hasTag("route", "share_taxi")) {
                if (!this.isWaySuitableForBuses(way)) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("highway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "trolleybus")) {
                if (!this.isWaySuitableForBuses(way) || !way.hasTag("trolley_wire", "yes")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("highway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "tram")) {
                if (!way.hasTag("railway", "tram")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "subway")) {
                if (!this.relation.hasTag("railway", "subway")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "light_rail")) {
                if (!this.relation.hasTag("raiilway", "subway")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "light_rail")) {
                if (!this.relation.hasTag("railway", "light_rail")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "train")) {
                if (!this.relation.hasTag("railway", "train")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction") && way.hasKey("construction")) {
                    isUnderConstruction = true;
                }
            }
            if (!isCorrectRoadType && !isUnderConstruction) {
                primitives = new ArrayList<Relation>(1);
                primitives.add(this.relation);
                highlighted = new ArrayList<Way>(1);
                highlighted.add(way);
                e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Route type does not match the type of the road it passes on", (Object[])new Object[0]), 3721, primitives, highlighted);
                this.errors.add(e);
            }
            if (!isUnderConstruction) continue;
            primitives = new ArrayList(1);
            primitives.add(this.relation);
            highlighted = new ArrayList(1);
            highlighted.add(way);
            e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Road is under construction", (Object[])new Object[0]), 3722, primitives, highlighted);
            this.errors.add(e);
        }
    }

    protected void performDirectionTest() {
        ArrayList<RelationMember> waysToCheck = new ArrayList<RelationMember>();
        for (RelationMember rm : this.relation.getMembers()) {
            if (!RouteUtils.isPTWay(rm) || !rm.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
            waysToCheck.add(rm);
        }
        if (waysToCheck.isEmpty()) {
            return;
        }
        WayConnectionTypeCalculator connectionTypeCalculator = new WayConnectionTypeCalculator();
        List links = connectionTypeCalculator.updateLinks(waysToCheck);
        for (int i = 0; i < links.size(); ++i) {
            if ((!OsmUtils.isTrue((String)((RelationMember)waysToCheck.get(i)).getWay().get("oneway")) || !((WayConnectionType)links.get((int)i)).direction.equals((Object)WayConnectionType.Direction.BACKWARD)) && (!OsmUtils.isReversed((String)((RelationMember)waysToCheck.get(i)).getWay().get("oneway")) || !((WayConnectionType)links.get((int)i)).direction.equals((Object)WayConnectionType.Direction.FORWARD)) || ((RelationMember)waysToCheck.get(i)).getWay().hasTag("busway", "lane") || ((RelationMember)waysToCheck.get(i)).getWay().hasTag("busway:left", "lane") || ((RelationMember)waysToCheck.get(i)).getWay().hasTag("busway:right", "lane") || ((RelationMember)waysToCheck.get(i)).getWay().hasTag("oneway:bus", "no") || ((RelationMember)waysToCheck.get(i)).getWay().hasTag("busway", "opposite_lane") || ((RelationMember)waysToCheck.get(i)).getWay().hasTag("oneway:psv", "no") || ((RelationMember)waysToCheck.get(i)).getWay().hasTag("trolley_wire", "backward")) continue;
            ArrayList<Relation> primitives = new ArrayList<Relation>(1);
            primitives.add(this.relation);
            ArrayList<Way> highlighted = new ArrayList<Way>(1);
            highlighted.add(((RelationMember)waysToCheck.get(i)).getWay());
            TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Route passes a oneway road in the wrong direction", (Object[])new Object[0]), 3731, primitives, highlighted);
            this.errors.add(e);
            return;
        }
    }

    private boolean isWaySuitableForBuses(Way way) {
        if (way.hasTag("highway", "motorway") || way.hasTag("highway", "trunk") || way.hasTag("highway", "primary") || way.hasTag("highway", "secondary") || way.hasTag("highway", "tertiary") || way.hasTag("highway", "unclassified") || way.hasTag("highway", "road") || way.hasTag("highway", "residential") || way.hasTag("highway", "service") || way.hasTag("highway", "motorway_link") || way.hasTag("highway", "trunk_link") || way.hasTag("highway", "primary_link") || way.hasTag("highway", "secondary_link") || way.hasTag("highway", "tertiary_link") || way.hasTag("highway", "living_street") || way.hasTag("highway", "bus_guideway") || way.hasTag("highway", "road") || way.hasTag("cycleway", "share_busway") || way.hasTag("cycleway", "shared_lane")) {
            return true;
        }
        return way.hasTag("highway", "pedestrian") && (way.hasTag("bus", "yes") || way.hasTag("psv", "yes") || way.hasTag("bus", "designated") || way.hasTag("psv", "designated"));
    }

    protected static Command fixErrorByRemovingWay(TestError testError) {
        if (testError.getCode() != 3721 && testError.getCode() != 3731) {
            return null;
        }
        Collection primitives = testError.getPrimitives();
        Relation originalRelation = (Relation)primitives.iterator().next();
        Collection highlighted = testError.getHighlighted();
        Way wayToRemove = (Way)highlighted.iterator().next();
        Relation modifiedRelation = new Relation(originalRelation);
        ArrayList<RelationMember> modifiedRelationMembers = new ArrayList<RelationMember>(originalRelation.getMembersCount() - 1);
        for (RelationMember rm : originalRelation.getMembers()) {
            if (!RouteUtils.isPTStop(rm)) continue;
            if (rm.getRole().equals("stop_position")) {
                RelationMember newMember;
                if (rm.getType().equals((Object)OsmPrimitiveType.NODE)) {
                    newMember = new RelationMember("stop", (OsmPrimitive)rm.getNode());
                    modifiedRelationMembers.add(newMember);
                    continue;
                }
                newMember = new RelationMember("stop", (OsmPrimitive)rm.getWay());
                modifiedRelationMembers.add(newMember);
                continue;
            }
            modifiedRelationMembers.add(rm);
        }
        for (RelationMember rm : originalRelation.getMembers()) {
            Way wayToCheck;
            if (!RouteUtils.isPTWay(rm) || (wayToCheck = rm.getWay()) == wayToRemove) continue;
            if (rm.getRole().equals("forward") || rm.getRole().equals("backward")) {
                RelationMember modifiedMember = new RelationMember("", (OsmPrimitive)wayToCheck);
                modifiedRelationMembers.add(modifiedMember);
                continue;
            }
            modifiedRelationMembers.add(rm);
        }
        modifiedRelation.setMembers(modifiedRelationMembers);
        ChangeCommand changeCommand = new ChangeCommand((OsmPrimitive)originalRelation, (OsmPrimitive)modifiedRelation);
        return changeCommand;
    }

    protected static Command fixErrorByZooming(TestError testError) {
        if (testError.getCode() != 3731) {
            return null;
        }
        Collection highlighted = testError.getHighlighted();
        Way wayToHighlight = (Way)highlighted.iterator().next();
        ArrayList<Way> primitivesToHighlight = new ArrayList<Way>(1);
        primitivesToHighlight.add(wayToHighlight);
        SelectCommand command = new SelectCommand(primitivesToHighlight);
        return command;
    }
}

