/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.actions.FixTask;
import org.openstreetmap.josm.plugins.pt_assistant.actions.IncompleteMembersDownloadThread;
import org.openstreetmap.josm.plugins.pt_assistant.gui.IncompleteMembersDownloadDialog;
import org.openstreetmap.josm.plugins.pt_assistant.gui.PTAssistantLayer;
import org.openstreetmap.josm.plugins.pt_assistant.gui.ProceedDialog;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.RouteChecker;
import org.openstreetmap.josm.plugins.pt_assistant.validation.SegmentChecker;
import org.openstreetmap.josm.plugins.pt_assistant.validation.WayChecker;
import org.openstreetmap.josm.tools.I18n;

public class PTAssitantValidatorTest
extends Test {
    public static final int ERROR_CODE_SORTING = 3711;
    public static final int ERROR_CODE_ROAD_TYPE = 3721;
    public static final int ERROR_CODE_CONSTRUCTION = 3722;
    public static final int ERROR_CODE_DIRECTION = 3731;
    public static final int ERROR_CODE_END_STOP = 3141;
    public static final int ERROR_CODE_SPLIT_WAY = 3142;
    public static final int ERROR_CODE_RELAITON_MEMBER_ROLES = 3143;
    private PTAssistantLayer layer = new PTAssistantLayer();

    public PTAssitantValidatorTest() {
        super(I18n.tr((String)"Public Transport Assistant tests", (Object[])new Object[0]), I18n.tr((String)"Check if route relations are compatible with public transport version 2", (Object[])new Object[0]));
        DataSet.addSelectionListener((SelectionChangedListener)this.layer);
    }

    public void visit(Relation r) {
        boolean downloadSuccessful;
        if (!RouteUtils.isTwoDirectionRoute(r)) {
            return;
        }
        if (r.hasIncompleteMembers() && !(downloadSuccessful = this.downloadIncompleteMembers(r))) {
            return;
        }
        if (r.hasIncompleteMembers()) {
            return;
        }
        WayChecker wayChecker = new WayChecker(r, this);
        if (!r.hasIncompleteMembers()) {
            wayChecker.performDirectionTest();
            wayChecker.performRoadTypeTest();
        }
        this.errors.addAll(wayChecker.getErrors());
        if (this.errors.isEmpty()) {
            this.proceedWithSorting(r);
        } else {
            this.proceedAfterWayCheckerErrors(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadIncompleteMembers(Relation r) {
        IncompleteMembersDownloadDialog incompleteMembersDownloadDialog = new IncompleteMembersDownloadDialog(r.getId());
        int userInput = incompleteMembersDownloadDialog.getUserSelection();
        if (userInput == 0) {
            IncompleteMembersDownloadThread t = new IncompleteMembersDownloadThread();
            t.start();
            IncompleteMembersDownloadThread incompleteMembersDownloadThread = t;
            synchronized (incompleteMembersDownloadThread) {
                try {
                    t.wait();
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private void proceedAfterWayCheckerErrors(Relation r) {
        int numberOfDirectionErrors = 0;
        int numberOfRoadTypeErrors = 0;
        for (TestError e : this.errors) {
            if (e.getCode() == 3731) {
                ++numberOfDirectionErrors;
            }
            if (e.getCode() != 3721) continue;
            ++numberOfRoadTypeErrors;
        }
        ProceedDialog proceedDialog = new ProceedDialog(r.getId(), numberOfDirectionErrors, numberOfRoadTypeErrors);
        int userInput = proceedDialog.getUserSelection();
        if (userInput == 0) {
            this.fixErrorFromPlugin(this.errors);
            this.proceedWithSorting(r);
            return;
        }
        if (userInput == 1) {
            JOptionPane.showMessageDialog(null, "This is not implemented yet!");
            return;
        }
        if (userInput == 2) {
            this.proceedWithSorting(r);
        }
    }

    private void proceedWithSorting(Relation r) {
        RouteChecker routeChecker = new RouteChecker(r, this);
        routeChecker.performSortingTest();
        List<TestError> routeCheckerErrors = routeChecker.getErrors();
        if (!routeCheckerErrors.isEmpty()) {
            this.errors.addAll(routeChecker.getErrors());
            return;
        }
        if (!routeChecker.getHasGap()) {
            // empty if block
        }
        this.proceedAfterSorting(r);
    }

    private void proceedAfterSorting(Relation r) {
        SegmentChecker segmentChecker = new SegmentChecker(r, this);
        if (!segmentChecker.getErrors().isEmpty()) {
            this.errors.addAll(segmentChecker.getErrors());
        }
        segmentChecker.performFirstStopTest();
        segmentChecker.performLastStopTest();
        this.errors.addAll(segmentChecker.getErrors());
    }

    public boolean isFixable(TestError testError) {
        return testError.getCode() == 3731 || testError.getCode() == 3721 || testError.getCode() == 3722 || testError.getCode() == 3711;
    }

    public Command fixError(TestError testError) {
        ArrayList<Command> commands = new ArrayList<Command>();
        if (testError.getCode() == 3721 || testError.getCode() == 3722) {
            commands.add(WayChecker.fixErrorByRemovingWay(testError));
        }
        if (testError.getCode() == 3731) {
            commands.add(WayChecker.fixErrorByZooming(testError));
        }
        if (testError.getCode() == 3711) {
            commands.add(RouteChecker.fixSortingError(testError));
        }
        if (commands.isEmpty()) {
            return null;
        }
        if (commands.size() == 1) {
            return (Command)commands.get(0);
        }
        return new SequenceCommand(I18n.tr((String)"Fix error", (Object[])new Object[0]), commands);
    }

    private void fixErrorFromPlugin(List<TestError> testErrors) {
        FixTask fixTask = new FixTask(testErrors);
        Thread t = new Thread((Runnable)((Object)fixTask));
        t.start();
        try {
            t.join();
            this.errors.removeAll(testErrors);
        }
        catch (InterruptedException e) {
            JOptionPane.showMessageDialog(null, "Error occurred during fixing");
        }
    }

    private void performDummyTest(Relation r) {
        ArrayList<Relation> primitives = new ArrayList<Relation>(1);
        primitives.add(r);
        this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"PT: dummy test warning", (Object[])new Object[0]), 3731, primitives));
    }
}

