/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.PaintVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;

public class PTAssistantPaintVisitor
extends PaintVisitor {
    private final Graphics g;
    private final MapView mv;

    public PTAssistantPaintVisitor(Graphics g, MapView mv) {
        super(g, mv);
        this.g = g;
        this.mv = mv;
    }

    public void visit(Relation r) {
        HashMap<Long, String> stopOrderMap = new HashMap<Long, String>();
        int stopCount = 1;
        for (RelationMember rm : r.getMembers()) {
            if (RouteUtils.isPTStop(rm)) {
                String label = "";
                if (stopOrderMap.containsKey(rm.getMember().getId())) {
                    label = (String)stopOrderMap.get(rm.getMember().getId());
                    label = label + ";" + stopCount;
                } else {
                    if (r.hasKey("ref")) {
                        label = label + r.get("ref");
                    } else if (r.hasKey("name")) {
                        label = label + r.get("name");
                    }
                    label = label + ":" + stopCount;
                }
                stopOrderMap.put(rm.getMember().getId(), label);
                this.drawStop(rm.getMember(), label);
                ++stopCount;
                continue;
            }
            if (!RouteUtils.isPTWay(rm)) continue;
            if (rm.isWay()) {
                this.visit(rm.getWay());
                continue;
            }
            if (!rm.isRelation()) continue;
            this.visit(rm.getRelation());
        }
    }

    public void visit(Way w) {
        if (w == null) {
            return;
        }
        int oneway = 0;
        if (w.hasTag("junction", "roundabout") || w.hasTag("highway", "motorway")) {
            oneway = 1;
        } else if (w.hasTag("oneway", "1") || w.hasTag("oneway", "yes") || w.hasTag("oneway", "true")) {
            oneway = w.hasTag("busway", "lane") || w.hasTag("busway:left", "lane") || w.hasTag("busway:right", "lane") || w.hasTag("oneway:bus", "no") || w.hasTag("busway", "opposite_lane") || w.hasTag("oneway:psv", "no") || w.hasTag("trolley_wire", "backward") ? 2 : 1;
        } else if (w.hasTag("oneway", "-1") || w.hasTag("oneway", "reverse")) {
            oneway = w.hasTag("busway", "lane") || w.hasTag("busway:left", "lane") || w.hasTag("busway:right", "lane") || w.hasTag("oneway:bus", "no") || w.hasTag("busway", "opposite_lane") || w.hasTag("oneway:psv", "no") || w.hasTag("trolley_wire", "backward") ? -2 : -1;
        }
        this.visit(w.getNodes(), oneway);
    }

    public void visit(List<Node> nodes, int oneway) {
        Node lastN = null;
        for (Node n : nodes) {
            if (lastN == null) {
                lastN = n;
                continue;
            }
            this.drawSegment(lastN, n, new Color(208, 80, 208, 179), oneway);
            lastN = n;
        }
    }

    public void visit(Node n) {
        if (n.isDrawable() && this.isNodeVisible(n)) {
            this.drawNode(n, Color.BLUE);
        }
    }

    protected void drawSegment(Node n1, Node n2, Color color, int oneway) {
        if (n1.isDrawable() && n2.isDrawable() && this.isSegmentVisible(n1, n2)) {
            this.drawSegment(this.mv.getPoint(n1), this.mv.getPoint(n2), color, oneway);
        }
    }

    protected void drawSegment(Point p1, Point p2, Color color, int oneway) {
        double t = Math.atan2((double)p2.x - (double)p1.x, (double)p2.y - (double)p1.y);
        double cosT = 8.0 * Math.cos(t);
        double sinT = 8.0 * Math.sin(t);
        int[] xPoints = new int[]{(int)((double)p1.x + cosT), (int)((double)p2.x + cosT), (int)((double)p2.x - cosT), (int)((double)p1.x - cosT)};
        int[] yPoints = new int[]{(int)((double)p1.y - sinT), (int)((double)p2.y - sinT), (int)((double)p2.y + sinT), (int)((double)p1.y + sinT)};
        this.g.setColor(color);
        this.g.fillPolygon(xPoints, yPoints, 4);
        this.g.fillOval(p1.x - 8, p1.y - 8, 16, 16);
        this.g.fillOval(p2.x - 8, p2.y - 8, 16, 16);
        if (oneway != 0) {
            int[] yDrawTriangle;
            int[] xDrawTriangle;
            int[] yFillTriangle;
            int[] xFillTriangle;
            double middleX = (double)(p1.x + p2.x) / 2.0;
            double middleY = (double)(p1.y + p2.y) / 2.0;
            double cosTriangle = 6.0 * Math.cos(t);
            double sinTriangle = 6.0 * Math.sin(t);
            this.g.setColor(new Color(50, 50, 50));
            if (oneway > 0) {
                xFillTriangle = new int[]{(int)(middleX + cosTriangle), (int)(middleX - cosTriangle), (int)(middleX + 2.0 * sinTriangle)};
                yFillTriangle = new int[]{(int)(middleY - sinTriangle), (int)(middleY + sinTriangle), (int)(middleY + 2.0 * cosTriangle)};
                this.g.fillPolygon(xFillTriangle, yFillTriangle, 3);
                if (oneway == 2) {
                    xDrawTriangle = new int[]{(int)(middleX + cosTriangle), (int)(middleX - cosTriangle), (int)(middleX - 2.0 * sinTriangle)};
                    yDrawTriangle = new int[]{(int)(middleY - sinTriangle), (int)(middleY + sinTriangle), (int)(middleY - 2.0 * cosTriangle)};
                    this.g.fillPolygon(xDrawTriangle, yDrawTriangle, 3);
                }
            }
            if (oneway < 0) {
                xFillTriangle = new int[]{(int)(middleX + cosTriangle), (int)(middleX - cosTriangle), (int)(middleX - 2.0 * sinTriangle)};
                yFillTriangle = new int[]{(int)(middleY - sinTriangle), (int)(middleY + sinTriangle), (int)(middleY - 2.0 * cosTriangle)};
                this.g.fillPolygon(xFillTriangle, yFillTriangle, 3);
                if (oneway == -2) {
                    xDrawTriangle = new int[]{(int)(middleX + cosTriangle), (int)(middleX - cosTriangle), (int)(middleX + 2.0 * sinTriangle)};
                    yDrawTriangle = new int[]{(int)(middleY - sinTriangle), (int)(middleY + sinTriangle), (int)(middleY + 2.0 * cosTriangle)};
                    this.g.fillPolygon(xDrawTriangle, yDrawTriangle, 3);
                }
            }
        }
    }

    protected void drawNode(Node n, Color color) {
        Point p = this.mv.getPoint(n);
        this.g.setColor(color);
        this.g.drawOval(p.x - 5, p.y - 5, 10, 10);
    }

    protected void drawStop(OsmPrimitive primitive, String label) {
        Node n = new Node(primitive.getBBox().getCenter());
        Point p = this.mv.getPoint(n);
        this.g.setColor(Color.WHITE);
        Font stringFont = new Font("SansSerif", 0, 24);
        this.g.setFont(stringFont);
        this.g.drawString(label, p.x + 20, p.y - 20);
        Color fillColor = null;
        if (primitive.hasTag("bus", "yes")) {
            fillColor = Color.BLUE;
        } else if (primitive.hasTag("tram", "yes")) {
            fillColor = Color.RED;
        }
        this.g.setColor(fillColor);
        if (primitive.hasTag("public_transport", "stop_position")) {
            this.g.fillOval(p.x - 8, p.y - 8, 16, 16);
        } else {
            this.g.fillRect(p.x - 8, p.y - 8, 16, 16);
        }
    }

    protected Graphics getGraphics() {
        return this.g;
    }
}

