/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.gui;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.tools.I18n;

public class ProceedDialog
extends JPanel {
    private static final long serialVersionUID = 2986537034076698693L;
    private static ASK_TO_PROCEED askToProceed = ASK_TO_PROCEED.DO_ASK;
    private JRadioButton radioButtonFixAutomatically;
    private JRadioButton radioButtonFixManually;
    private JRadioButton radioButtonDontFix;
    private JCheckBox checkbox;
    private String[] options;
    private JPanel panel = new JPanel();
    private int selectedOption;

    public ProceedDialog(long id, int numberOfDirectionErrors, int numberOfRoadTypeErrors) {
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JLabel label1 = new JLabel(I18n.tr((String)"PT_Assistant plugin found that this relation (id={0}) has errors:", (Object[])new Object[]{id}));
        this.panel.add(label1);
        label1.setAlignmentX(0.0f);
        if (numberOfDirectionErrors != 0) {
            JLabel label2 = new JLabel("     " + I18n.trn((String)"{0} direction error", (String)"{0} direction errors", (long)numberOfDirectionErrors, (Object[])new Object[]{numberOfDirectionErrors}));
            this.panel.add(label2);
            label2.setAlignmentX(0.0f);
        }
        if (numberOfRoadTypeErrors != 0) {
            JLabel label3 = new JLabel("     " + I18n.trn((String)"{0} road type error", (String)"{0} road type errors", (long)numberOfRoadTypeErrors, (Object[])new Object[]{numberOfRoadTypeErrors}));
            this.panel.add(label3);
            label3.setAlignmentX(0.0f);
        }
        JLabel label4 = new JLabel(I18n.tr((String)"How do you want to proceed?", (Object[])new Object[0]));
        this.panel.add(label4);
        label4.setAlignmentX(0.0f);
        this.radioButtonFixAutomatically = new JRadioButton("Fix all errors automatically and proceed", true);
        this.radioButtonFixManually = new JRadioButton("I will fix the erros manually and click the button to proceed");
        this.radioButtonDontFix = new JRadioButton("Do not fix anything and proceed with further tests");
        ButtonGroup fixOptionButtonGroup = new ButtonGroup();
        fixOptionButtonGroup.add(this.radioButtonFixAutomatically);
        fixOptionButtonGroup.add(this.radioButtonFixManually);
        fixOptionButtonGroup.add(this.radioButtonDontFix);
        this.panel.add(this.radioButtonFixAutomatically);
        this.panel.add(this.radioButtonFixManually);
        this.panel.add(this.radioButtonDontFix);
        this.radioButtonFixAutomatically.setAlignmentX(0.0f);
        this.radioButtonFixManually.setAlignmentX(0.0f);
        this.radioButtonDontFix.setAlignmentX(0.0f);
        this.checkbox = new JCheckBox(I18n.tr((String)"Remember my choice and do not ask me again in this session", (Object[])new Object[0]));
        this.panel.add(this.checkbox);
        this.checkbox.setAlignmentX(0.0f);
        this.options = new String[2];
        this.options[0] = "OK";
        this.options[1] = "Cancel & stop testing";
        this.selectedOption = Integer.MIN_VALUE;
    }

    public int getUserSelection() {
        if (askToProceed == ASK_TO_PROCEED.DONT_ASK_AND_FIX_AUTOMATICALLY) {
            return 0;
        }
        if (askToProceed == ASK_TO_PROCEED.DONT_ASK_AND_FIX_MANUALLY) {
            return 1;
        }
        if (askToProceed == ASK_TO_PROCEED.DONT_ASK_AND_DONT_FIX) {
            return 2;
        }
        this.selectedOption = JOptionPane.showOptionDialog(this, this.panel, I18n.tr((String)"PT_Assistant Proceed Request", (Object[])new Object[0]), -1, 3, null, this.options, 0);
        if (this.selectedOption == 0) {
            if (this.radioButtonFixAutomatically.isSelected()) {
                if (this.checkbox.isSelected()) {
                    askToProceed = ASK_TO_PROCEED.DONT_ASK_AND_FIX_AUTOMATICALLY;
                }
                return 0;
            }
            if (this.radioButtonFixManually.isSelected()) {
                if (this.checkbox.isSelected()) {
                    askToProceed = ASK_TO_PROCEED.DONT_ASK_AND_FIX_MANUALLY;
                }
                return 1;
            }
            if (this.radioButtonDontFix.isSelected()) {
                if (this.checkbox.isSelected()) {
                    askToProceed = ASK_TO_PROCEED.DONT_ASK_AND_DONT_FIX;
                }
                return 2;
            }
        }
        return -1;
    }

    private void showDialog() {
        if (!SwingUtilities.isEventDispatchThread()) {
            this.selectedOption = JOptionPane.showOptionDialog(this, this.panel, I18n.tr((String)"PT_Assistant Proceed Request", (Object[])new Object[0]), -1, 3, null, this.options, 0);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProceedDialog.this.showDialog();
                }
            });
        }
    }

    private static enum ASK_TO_PROCEED {
        DO_ASK,
        DONT_ASK_AND_FIX_AUTOMATICALLY,
        DONT_ASK_AND_FIX_MANUALLY,
        DONT_ASK_AND_DONT_FIX;

    }
}

