/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.PaintVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;

public class PTAssistantPaintVisitor
extends PaintVisitor {
    private final Graphics g;
    private final MapView mv;

    public PTAssistantPaintVisitor(Graphics g, MapView mv) {
        super(g, mv);
        this.g = g;
        this.mv = mv;
    }

    public void visit(Relation r) {
        int stopCount = 1;
        for (RelationMember rm : r.getMembers()) {
            if (RouteUtils.isPTStop(rm)) {
                String label = "";
                if (r.hasKey("ref")) {
                    label = label + r.get("ref");
                } else if (r.hasKey("name")) {
                    label = label + r.get("name");
                }
                label = label + "." + stopCount;
                this.drawStop(rm.getMember(), label);
                ++stopCount;
                continue;
            }
            if (!RouteUtils.isPTWay(rm)) continue;
            if (rm.isWay()) {
                this.visit(rm.getWay());
                continue;
            }
            if (!rm.isRelation()) continue;
            this.visit(rm.getRelation());
        }
    }

    public void visit(List<Node> nodes) {
        Node lastN = null;
        for (Node n : nodes) {
            if (lastN == null) {
                lastN = n;
                continue;
            }
            this.drawSegment(lastN, n, new Color(208, 80, 208, 179));
            lastN = n;
        }
    }

    public void visit(Node n) {
        if (n.isDrawable() && this.isNodeVisible(n)) {
            this.drawNode(n, Color.BLUE);
        }
    }

    protected void drawSegment(Point p1, Point p2, Color color) {
        double t = Math.atan2((double)p2.x - (double)p1.x, (double)p2.y - (double)p1.y);
        double cosT = 8.0 * Math.cos(t);
        double sinT = 8.0 * Math.sin(t);
        int[] xPoints = new int[]{(int)((double)p1.x + cosT), (int)((double)p2.x + cosT), (int)((double)p2.x - cosT), (int)((double)p1.x - cosT)};
        int[] yPoints = new int[]{(int)((double)p1.y - sinT), (int)((double)p2.y - sinT), (int)((double)p2.y + sinT), (int)((double)p1.y + sinT)};
        this.g.setColor(color);
        this.g.fillPolygon(xPoints, yPoints, 4);
        this.g.fillOval(p1.x - 8, p1.y - 8, 16, 16);
        this.g.fillOval(p2.x - 8, p2.y - 8, 16, 16);
    }

    protected void drawNode(Node n, Color color) {
        Point p = this.mv.getPoint(n);
        this.g.setColor(color);
        this.g.drawOval(p.x - 5, p.y - 5, 10, 10);
    }

    protected void drawStop(OsmPrimitive primitive, String label) {
        Node n = new Node(primitive.getBBox().getCenter());
        Point p = this.mv.getPoint(n);
        this.g.setColor(Color.WHITE);
        Font stringFont = new Font("SansSerif", 0, 24);
        this.g.setFont(stringFont);
        this.g.drawString(label, p.x + 20, p.y - 20);
        Color fillColor = null;
        if (primitive.hasTag("bus", "yes")) {
            fillColor = Color.BLUE;
        } else if (primitive.hasTag("tram", "yes")) {
            fillColor = Color.RED;
        }
        this.g.setColor(fillColor);
        if (primitive.hasTag("public_transport", "stop_position")) {
            this.g.fillOval(p.x - 8, p.y - 8, 16, 16);
        } else {
            this.g.fillRect(p.x - 8, p.y - 8, 16, 16);
        }
    }

    protected Graphics getGraphics() {
        return this.g;
    }
}

