/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.PaintVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;

public class PTAssistantPaintVisitor
extends PaintVisitor {
    private final Graphics g;
    private final MapView mv;

    public PTAssistantPaintVisitor(Graphics g, MapView mv) {
        super(g, mv);
        this.g = g;
        this.mv = mv;
    }

    public void visit(Relation r) {
        int stopCount = 1;
        for (RelationMember rm : r.getMembers()) {
            if (RouteUtils.isPTStop(rm)) {
                this.drawStop(rm.getMember(), Color.BLUE, Color.BLACK, new Integer(stopCount).toString());
                ++stopCount;
                continue;
            }
            if (!RouteUtils.isPTWay(rm)) continue;
            if (rm.isWay()) {
                this.visit(rm.getWay());
                continue;
            }
            if (!rm.isRelation()) continue;
            this.visit(rm.getRelation());
        }
    }

    public void visit(List<Node> nodes) {
        Node lastN = null;
        for (Node n : nodes) {
            if (lastN == null) {
                lastN = n;
                continue;
            }
            this.drawSegment(lastN, n, Color.BLUE);
            lastN = n;
        }
    }

    public void visit(Node n) {
        if (n.isDrawable() && this.isNodeVisible(n)) {
            this.drawNode(n, Color.BLUE);
        }
    }

    protected void drawSegment(Point p1, Point p2, Color color) {
        double t = Math.atan2((double)p2.x - (double)p1.x, (double)p2.y - (double)p1.y);
        double cosT = 5.0 * Math.cos(t);
        double sinT = 5.0 * Math.sin(t);
        this.g.setColor(color);
        this.g.drawLine((int)((double)p1.x + cosT), (int)((double)p1.y - sinT), (int)((double)p2.x + cosT), (int)((double)p2.y - sinT));
        this.g.drawLine((int)((double)p1.x - cosT), (int)((double)p1.y + sinT), (int)((double)p2.x - cosT), (int)((double)p2.y + sinT));
    }

    protected void drawNode(Node n, Color color) {
        Point p = this.mv.getPoint(n);
        this.g.setColor(color);
        this.g.drawOval(p.x - 5, p.y - 5, 10, 10);
    }

    protected void drawStop(OsmPrimitive primitive, Color fillColor, Color outlineColor, String label) {
        Node n = new Node(primitive.getBBox().getCenter());
        Point p = this.mv.getPoint(n);
        this.g.setColor(fillColor);
        this.g.fillOval(p.x - 5, p.y - 5, 10, 10);
        this.g.setColor(outlineColor);
        this.g.drawOval(p.x - 5, p.y - 5, 10, 10);
        this.g.setColor(Color.WHITE);
        this.g.drawString(label, p.x - 20, p.y - 20);
    }
}

