/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.gui;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerPositionStrategy;
import org.openstreetmap.josm.plugins.pt_assistant.gui.PTAssistantPaintVisitor;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.tools.ImageProvider;

public class PTAssistantValidatorLayer
extends Layer
implements SelectionChangedListener {
    private List<OsmPrimitive> primitives = new ArrayList<OsmPrimitive>();

    public PTAssistantValidatorLayer() {
        super("pt_assistant layer");
    }

    public void addPrimitive(OsmPrimitive primitive) {
        this.primitives.add(primitive);
    }

    public void clear() {
        this.primitives.clear();
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        PTAssistantPaintVisitor paintVisitor = new PTAssistantPaintVisitor(g, mv);
        for (OsmPrimitive primitive : this.primitives) {
            paintVisitor.visit(primitive);
        }
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"osmdata_small");
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(null, (Layer)this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public String getToolTipText() {
        return "pt_assistant layer";
    }

    public boolean isMergable(Layer arg0) {
        return false;
    }

    public void mergeFrom(Layer arg0) {
    }

    public void visitBoundingBox(BoundingXYVisitor arg0) {
    }

    public LayerPositionStrategy getDefaultLayerPosition() {
        return LayerPositionStrategy.IN_FRONT;
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.primitives.clear();
        for (OsmPrimitive osmPrimitive : newSelection) {
            Relation relation;
            if (!osmPrimitive.getType().equals((Object)OsmPrimitiveType.RELATION) || !RouteUtils.isTwoDirectionRoute(relation = (Relation)osmPrimitive)) continue;
            this.primitives.add((OsmPrimitive)relation);
        }
        if (!Main.getLayerManager().containsLayer((Layer)this)) {
            Main.getLayerManager().addLayer((Layer)this);
        }
    }
}

