/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.traffico;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.traffico.TrafficoGlyph;
import org.openstreetmap.josm.plugins.mapillary.traffico.TrafficoSignElement;

public final class TrafficoSign {
    private static final String SIGN_DEFINITION_PATH = "/data/fonts/traffico/signs/%s.json";
    private static final Map<String, Map<String, TrafficoSign>> signs = new TreeMap<String, Map<String, TrafficoSign>>();
    private final String country;
    private final String name;
    private final TrafficoSignElement[] elements;

    private TrafficoSign(TrafficoSignElement[] elements, String country, String name) {
        this.country = country;
        this.name = name;
        this.elements = elements == null ? new TrafficoSignElement[0] : (TrafficoSignElement[])elements.clone();
    }

    public String getCountry() {
        return this.country;
    }

    public String getName() {
        return this.name;
    }

    public int getNumElements() {
        return this.elements.length;
    }

    public TrafficoSignElement getElement(int index) {
        return this.elements[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrafficoSign getSign(String country, String signName) {
        Map<String, Map<String, TrafficoSign>> map = signs;
        synchronized (map) {
            if (!signs.containsKey(country)) {
                TrafficoSign.buildSignsFromJsonDefinition(country);
            }
            if (signs.containsKey(country) && signs.get(country).containsKey(signName)) {
                return signs.get(country).get(signName);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSign(TrafficoSign sign) {
        Map<String, Map<String, TrafficoSign>> map = signs;
        synchronized (map) {
            if (!signs.containsKey(sign.getCountry())) {
                signs.put(sign.getCountry(), new TreeMap());
            }
            if (signs.get(sign.getCountry()).containsKey(sign.getName())) {
                Main.warn((String)"The sign {0}--{1} was found multiple times in the traffico sign-definitions.", (Object[])new Object[]{sign.getName(), sign.getCountry()});
            } else {
                signs.get(sign.getCountry()).put(sign.getName(), sign);
            }
        }
    }

    private static void buildSignsFromJsonDefinition(String country) {
        Main.info((String)"Reading signs for country ''{0}''.", (Object[])new Object[]{country});
        try (InputStream countryStream = TrafficoSign.class.getResourceAsStream(String.format(SIGN_DEFINITION_PATH, country));){
            if (countryStream == null) {
                return;
            }
            JsonObject countrySigns = Json.createReader((InputStream)countryStream).readObject();
            Set countrySignNames = countrySigns.keySet();
            Main.info((String)(countrySignNames.size() + " different signs are supported for ''{0}'' by the Mapillary-plugin ."), (Object[])new Object[]{country});
            ArrayList<TrafficoSignElement> signLayers = new ArrayList<TrafficoSignElement>();
            for (String name : countrySignNames) {
                signLayers.clear();
                JsonArray elements = countrySigns.getJsonObject(name).getJsonArray("elements");
                for (int i = 0; i < elements.size(); ++i) {
                    Color c;
                    Character glyph = TrafficoGlyph.getGlyph(elements.getJsonObject(i).getString("type"));
                    if (glyph == null) continue;
                    switch (elements.getJsonObject(i).getString("color").toLowerCase()) {
                        case "black": {
                            c = Color.BLACK;
                            break;
                        }
                        case "red": {
                            c = new Color(0xC1121C);
                            break;
                        }
                        case "blue": {
                            c = new Color(1394825);
                            break;
                        }
                        case "white": {
                            c = Color.WHITE;
                            break;
                        }
                        case "green": {
                            c = new Color(34644);
                            break;
                        }
                        case "yellow": {
                            c = new Color(16699187);
                            break;
                        }
                        default: {
                            c = Color.MAGENTA;
                        }
                    }
                    signLayers.add(new TrafficoSignElement(glyph.charValue(), c));
                }
                TrafficoSign.addSign(new TrafficoSign(signLayers.toArray(new TrafficoSignElement[signLayers.size()]), country, name));
            }
        }
        catch (IOException e) {
            Main.error((Throwable)e);
        }
    }
}

