/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;
import org.openstreetmap.josm.plugins.mapillary.cache.CacheUtils;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryFilterDialog;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryMainDialog;
import org.openstreetmap.josm.plugins.mapillary.history.MapillaryRecord;
import org.openstreetmap.josm.plugins.mapillary.history.commands.CommandDelete;
import org.openstreetmap.josm.plugins.mapillary.io.download.MapillaryDownloader;
import org.openstreetmap.josm.plugins.mapillary.mode.AbstractMode;
import org.openstreetmap.josm.plugins.mapillary.mode.JoinMode;
import org.openstreetmap.josm.plugins.mapillary.mode.SelectMode;
import org.openstreetmap.josm.plugins.mapillary.utils.MapViewGeometryUtil;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.tools.I18n;

public final class MapillaryLayer
extends AbstractModifiableLayer
implements DataSetListener,
MainLayerManager.ActiveLayerChangeListener {
    public static final int SEQUENCE_MAX_JUMP_DISTANCE = Main.pref.getInteger("mapillary.sequence-max-jump-distance", 100);
    public boolean tempSemiautomatic;
    private static MapillaryLayer instance;
    private MapillaryImage blue;
    private MapillaryImage red;
    private final MapillaryData data;
    public AbstractMode mode;
    private final int highlightPointRadius = Main.pref.getInteger("mappaint.highlight.radius", 7);
    private final int highlightStep = Main.pref.getInteger("mappaint.highlight.step", 4);
    private volatile TexturePaint hatched;

    private MapillaryLayer() {
        super(I18n.tr((String)"Mapillary Images", (Object[])new Object[0]));
        this.data = new MapillaryData();
    }

    private void init() {
        if (Main.main != null && Main.map.mapView != null) {
            this.setMode(new SelectMode());
            Main.getLayerManager().addLayer((Layer)this);
            Main.getLayerManager().addActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
            if (Main.getLayerManager().getEditLayer() != null) {
                Main.getLayerManager().getEditLayer().data.addDataSetListener((DataSetListener)this);
            }
            if (MapillaryDownloader.getMode() == MapillaryDownloader.MODES.Automatic) {
                MapillaryDownloader.automaticDownload();
            }
            if (MapillaryDownloader.getMode() == MapillaryDownloader.MODES.Semiautomatic) {
                this.mode.zoomChanged();
            }
        }
        if (MapillaryPlugin.getExportMenu() != null) {
            MapillaryPlugin.setMenuEnabled(MapillaryPlugin.getExportMenu(), true);
            if (!MapillaryMainDialog.getInstance().isShowing()) {
                MapillaryMainDialog.getInstance().getButton().doClick();
            }
        }
        this.createHatchTexture();
        if (Main.main != null) {
            MapillaryMainDialog.getInstance().getInputMap(2).put(KeyStroke.getKeyStroke("DELETE"), "MapillaryDel");
            MapillaryMainDialog.getInstance().getActionMap().put("MapillaryDel", new DeleteImageAction());
        }
        if (Main.main != null) {
            MapillaryData.dataUpdated();
        }
    }

    public void setMode(AbstractMode mode) {
        if (this.mode != null) {
            Main.map.mapView.removeMouseListener((MouseListener)this.mode);
            Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this.mode);
            NavigatableComponent.removeZoomChangeListener((NavigatableComponent.ZoomChangeListener)this.mode);
        }
        this.mode = mode;
        if (mode != null) {
            Main.map.mapView.setNewCursor(mode.cursor, (Object)this);
            Main.map.mapView.addMouseListener((MouseListener)mode);
            Main.map.mapView.addMouseMotionListener((MouseMotionListener)mode);
            NavigatableComponent.addZoomChangeListener((NavigatableComponent.ZoomChangeListener)mode);
            MapillaryUtils.updateHelpText();
        }
    }

    public static void clearInstance() {
        instance = null;
    }

    public static synchronized MapillaryLayer getInstance() {
        if (instance == null) {
            instance = new MapillaryLayer();
            instance.init();
        }
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public MapillaryData getData() {
        return this.data;
    }

    public MapillaryImage getBlue() {
        return this.blue;
    }

    public MapillaryImage getRed() {
        return this.red;
    }

    public void destroy() {
        this.setMode(null);
        MapillaryRecord.getInstance().reset();
        AbstractMode.resetThread();
        MapillaryDownloader.stopAll();
        MapillaryMainDialog.getInstance().setImage(null);
        MapillaryMainDialog.getInstance().updateImage();
        MapillaryPlugin.setMenuEnabled(MapillaryPlugin.getExportMenu(), false);
        MapillaryPlugin.setMenuEnabled(MapillaryPlugin.getZoomMenu(), false);
        Main.map.mapView.removeMouseListener((MouseListener)this.mode);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this.mode);
        Main.getLayerManager().removeActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        if (Main.getLayerManager().getEditLayer() != null) {
            Main.getLayerManager().getEditLayer().data.removeDataSetListener((DataSetListener)this);
        }
        MapillaryLayer.clearInstance();
        super.destroy();
    }

    public boolean isModified() {
        for (MapillaryAbstractImage image : this.data.getImages()) {
            if (!image.isModified()) continue;
            return true;
        }
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        for (MapillaryAbstractImage img : this.data.getImages()) {
            img.setVisible(visible);
        }
        if (Main.map != null) {
            MapillaryFilterDialog.getInstance().refresh();
        }
    }

    private static Color getBackgroundColor() {
        return Main.pref.getColor(I18n.marktr((String)"background"), Color.BLACK);
    }

    private static Color getOutsideColor() {
        return Main.pref.getColor(I18n.marktr((String)"outside downloaded area"), Color.YELLOW);
    }

    private void createHatchTexture() {
        BufferedImage bi = new BufferedImage(15, 15, 2);
        Graphics2D big = bi.createGraphics();
        big.setColor(MapillaryLayer.getBackgroundColor());
        AlphaComposite comp = AlphaComposite.getInstance(3, 0.3f);
        big.setComposite(comp);
        big.fillRect(0, 0, 15, 15);
        big.setColor(MapillaryLayer.getOutsideColor());
        big.drawLine(0, 15, 15, 0);
        Rectangle r = new Rectangle(0, 0, 15, 15);
        this.hatched = new TexturePaint(bi, r);
    }

    public synchronized void paint(Graphics2D g, MapView mv, Bounds box) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (Main.getLayerManager().getActiveLayer() == this) {
            g.setPaint(this.hatched);
            g.fill(MapViewGeometryUtil.getNonDownloadedArea(mv, this.data.getBounds()));
        }
        MapillaryMainDialog.getInstance().blueButton.setEnabled(false);
        MapillaryMainDialog.getInstance().redButton.setEnabled(false);
        this.blue = null;
        this.red = null;
        if (this.data.getSelectedImage() != null) {
            Point p;
            MapillaryImage[] closestImages = this.getClosestImagesFromDifferentSequences();
            Point selected = mv.getPoint(this.data.getSelectedImage().getMovingLatLon());
            if (closestImages[0] != null) {
                this.blue = closestImages[0];
                g.setColor(Color.BLUE);
                p = mv.getPoint(closestImages[0].getMovingLatLon());
                g.draw(new Line2D.Double(p.getX(), p.getY(), selected.getX(), selected.getY()));
                MapillaryMainDialog.getInstance().blueButton.setEnabled(true);
            }
            if (closestImages[1] != null) {
                this.red = closestImages[1];
                g.setColor(Color.RED);
                p = mv.getPoint(closestImages[1].getMovingLatLon());
                g.draw(new Line2D.Double(p.getX(), p.getY(), selected.getX(), selected.getY()));
                MapillaryMainDialog.getInstance().redButton.setEnabled(true);
            }
        }
        MapillaryAbstractImage selectedImage = MapillaryLayer.getInstance().getData().getSelectedImage();
        String selectedImageKey = null;
        if (selectedImage != null && selectedImage.getSequence() != null) {
            selectedImageKey = selectedImage.getSequence().getKey();
        }
        g.setStroke(new BasicStroke(this == Main.getLayerManager().getActiveLayer() ? 3.0f : 2.0f));
        for (MapillarySequence seq : this.getData().getSequences()) {
            if (selectedImageKey != null && selectedImageKey.equals(seq.getKey())) {
                g.setColor(Color.MAGENTA.brighter());
            } else {
                g.setColor(Color.WHITE);
            }
            g.draw(MapViewGeometryUtil.getSequencePath(mv, seq));
        }
        for (MapillaryAbstractImage imageAbs : this.data.getImages()) {
            if (!imageAbs.isVisible() || !Main.map.mapView.contains(Main.map.mapView.getPoint(imageAbs.getMovingLatLon()))) continue;
            Point p = mv.getPoint(imageAbs.getMovingLatLon());
            ImageIcon icon = MapillaryPlugin.MAP_ICON;
            if (this.getData().getMultiSelectedImages().contains(imageAbs)) {
                icon = MapillaryPlugin.MAP_ICON_SELECTED;
            } else if (imageAbs instanceof MapillaryImportedImage) {
                icon = MapillaryPlugin.MAP_ICON_IMPORTED;
            }
            this.draw(g, imageAbs, icon, p);
            if (!(imageAbs instanceof MapillaryImage) || ((MapillaryImage)imageAbs).getSigns().isEmpty()) continue;
            g.drawImage(MapillaryPlugin.MAP_SIGN.getImage(), p.x - MapillaryPlugin.MAP_SIGN.getIconWidth() / 2, p.y - MapillaryPlugin.MAP_SIGN.getIconHeight() / 2, (ImageObserver)Main.map.mapView);
        }
        if (this.mode instanceof JoinMode) {
            this.mode.paint(g, mv, box);
        }
    }

    private void drawPointHighlight(Graphics2D g, Point p, int size) {
        Color oldColor = g.getColor();
        Color highlightColor = PaintColors.HIGHLIGHT.get();
        Color highlightColorTransparent = new Color(highlightColor.getRed(), highlightColor.getGreen(), highlightColor.getBlue(), 100);
        g.setColor(highlightColorTransparent);
        for (int s = size + this.highlightPointRadius; s >= size; s -= this.highlightStep) {
            int r = (int)Math.floor((double)s / 2.0);
            g.fillRoundRect(p.x - r, p.y - r, s, s, r, r);
        }
        g.setColor(oldColor);
    }

    private void draw(Graphics2D g, MapillaryAbstractImage image, ImageIcon icon, Point p) {
        Image imagetemp = icon.getImage();
        BufferedImage bi = (BufferedImage)imagetemp;
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        double rotationRequired = Math.toRadians(image.getMovingCa());
        double locationX = (double)width / 2.0;
        double locationY = (double)height / 2.0;
        AffineTransform tx = AffineTransform.getRotateInstance(rotationRequired, locationX, locationY);
        AffineTransformOp op = new AffineTransformOp(tx, 2);
        g.drawImage((Image)op.filter(bi, null), p.x - width / 2, p.y - height / 2, (ImageObserver)Main.map.mapView);
        if (this.data.getHighlightedImage() == image) {
            this.drawPointHighlight(g, p, 16);
        }
    }

    public Icon getIcon() {
        return MapillaryPlugin.ICON16;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
        throw new UnsupportedOperationException("This layer does not support merging yet");
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), new LayerListPopup.InfoAction((Layer)this)};
    }

    private MapillaryImage[] getClosestImagesFromDifferentSequences() {
        if (!(this.data.getSelectedImage() instanceof MapillaryImage)) {
            return new MapillaryImage[]{null, null};
        }
        MapillaryImage selected = (MapillaryImage)this.data.getSelectedImage();
        MapillaryImage[] ret = new MapillaryImage[2];
        double[] distances = new double[]{SEQUENCE_MAX_JUMP_DISTANCE, SEQUENCE_MAX_JUMP_DISTANCE};
        LatLon selectedCoords = this.data.getSelectedImage().getMovingLatLon();
        for (MapillaryAbstractImage imagePrev : this.data.getImages()) {
            MapillaryImage image;
            if (!(imagePrev instanceof MapillaryImage) || !imagePrev.isVisible() || !((image = (MapillaryImage)imagePrev).getMovingLatLon().greatCircleDistance(selectedCoords) < (double)SEQUENCE_MAX_JUMP_DISTANCE) || selected.getSequence() == image.getSequence()) continue;
            if (ret[0] == null && ret[1] == null || image.getMovingLatLon().greatCircleDistance(selectedCoords) < distances[0] && (ret[1] == null || image.getSequence() != ret[1].getSequence())) {
                ret[0] = image;
                distances[0] = image.getMovingLatLon().greatCircleDistance(selectedCoords);
                continue;
            }
            if (ret[1] != null && !(image.getMovingLatLon().greatCircleDistance(selectedCoords) < distances[1]) || image.getSequence() == ret[0].getSequence()) continue;
            ret[1] = image;
            distances[1] = image.getMovingLatLon().greatCircleDistance(selectedCoords);
        }
        if (ret[0] != null) {
            CacheUtils.downloadPicture(ret[0]);
        }
        if (ret[1] != null) {
            CacheUtils.downloadPicture(ret[1]);
        }
        return ret;
    }

    public Object getInfoComponent() {
        return new StringBuilder(35).append(I18n.tr((String)"Mapillary layer", (Object[])new Object[0])).append('\n').append(I18n.tr((String)"Total images:", (Object[])new Object[0])).append(' ').append(this.data.size()).append('\n').toString();
    }

    public String getToolTipText() {
        return "" + this.data.size() + ' ' + I18n.tr((String)"images", (Object[])new Object[0]);
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        if (Main.getLayerManager().getActiveLayer() == this) {
            MapillaryUtils.updateHelpText();
        }
        MapillaryPlugin.setMenuEnabled(MapillaryPlugin.getJoinMenu(), Main.getLayerManager().getActiveLayer() == this);
        if (Main.getLayerManager().getEditLayer() != e.getPreviousEditLayer()) {
            if (Main.getLayerManager().getEditLayer() != null) {
                Main.getLayerManager().getEditLayer().data.addDataSetListener((DataSetListener)this);
            }
            if (e.getPreviousEditLayer() != null) {
                e.getPreviousEditLayer().data.removeDataSetListener((DataSetListener)this);
            }
        }
    }

    public void dataChanged(DataChangedEvent event) {
        Main.worker.submit(new DelayedDownload());
    }

    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    public void primitivesRemoved(PrimitivesRemovedEvent event) {
    }

    public void tagsChanged(TagsChangedEvent event) {
    }

    public void nodeMoved(NodeMovedEvent event) {
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    private class DeleteImageAction
    extends AbstractAction {
        private static final long serialVersionUID = -982809854631863962L;

        private DeleteImageAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (instance != null) {
                MapillaryRecord.getInstance().addCommand(new CommandDelete(MapillaryLayer.this.getData().getMultiSelectedImages()));
            }
        }
    }

    private static class DelayedDownload
    extends Thread {
        private DelayedDownload() {
        }

        @Override
        public void run() {
            try {
                DelayedDownload.sleep(1500L);
            }
            catch (InterruptedException e) {
                Main.error((Throwable)e);
            }
            MapillaryDownloader.automaticDownload();
        }
    }
}

