/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.conflict.ConflictAddCommand;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.AdvancedEditorPanel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.BasicEditorPanel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.JosmSelectionPanel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.NavigationControler;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditorManager;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditorModel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssuesView;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TurnRestrictionEditor
extends JDialog
implements NavigationControler {
    public static final String TURN_RESTRICION_PROP = RelationEditor.class.getName() + ".turnRestriction";
    public static final String TURN_RESTRICION_SNAPSHOT_PROP = RelationEditor.class.getName() + ".turnRestrictionSnapshot";
    protected Relation turnRestriction;
    protected Relation turnRestrictionSnapshot;
    private OsmDataLayer layer;
    private JosmSelectionPanel pnlJosmSelection;
    private BasicEditorPanel pnlBasicEditor;
    private TurnRestrictionEditorModel editorModel;
    private JTabbedPane tpEditors;
    private PreferenceChangeHandler preferenceChangeHandler;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);

    protected JPanel buildOkCancelButtonPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(1));
        JButton b = new JButton(new OKAction());
        pnl.add(b);
        b.setName("btnOK");
        b = new JButton(new CancelAction());
        pnl.add(b);
        b.setName("btnCancel");
        b = new JButton((Action)new ContextSensitiveHelpAction(HelpUtil.ht((String)"/Plugin/TurnRestrictions#TurnRestrictionEditor")));
        pnl.add(b);
        b.setName("btnHelp");
        return pnl;
    }

    protected JPanel buildJOSMSelectionPanel() {
        this.pnlJosmSelection = new JosmSelectionPanel(this.layer, this.editorModel.getJosmSelectionListModel());
        return this.pnlJosmSelection;
    }

    protected JPanel buildEditorPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.tpEditors = new JTabbedPane();
        this.pnlBasicEditor = new BasicEditorPanel(this.editorModel);
        JScrollPane pane = new JScrollPane((Component)((Object)this.pnlBasicEditor));
        pane.setHorizontalScrollBarPolicy(31);
        pane.setVerticalScrollBarPolicy(20);
        this.tpEditors.add(pane);
        this.tpEditors.setTitleAt(0, I18n.tr((String)"Basic", (Object[])new Object[0]));
        this.tpEditors.setToolTipTextAt(0, I18n.tr((String)"Edit basic attributes of a turn restriction", (Object[])new Object[0]));
        this.tpEditors.add(new AdvancedEditorPanel(this.editorModel));
        this.tpEditors.setTitleAt(1, I18n.tr((String)"Advanced", (Object[])new Object[0]));
        this.tpEditors.setToolTipTextAt(1, I18n.tr((String)"Edit the raw tags and members of this turn restriction", (Object[])new Object[0]));
        this.tpEditors.add((Component)((Object)new IssuesView(this.editorModel.getIssuesModel())));
        this.tpEditors.setTitleAt(2, I18n.tr((String)"Errors/Warnings", (Object[])new Object[0]));
        this.tpEditors.setToolTipTextAt(2, I18n.tr((String)"Show errors and warnings related to this turn restriction", (Object[])new Object[0]));
        pnl.add((Component)this.tpEditors, "Center");
        return pnl;
    }

    protected JPanel buildContentPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        final JSplitPane sp = new JSplitPane(1);
        pnl.add((Component)sp, "Center");
        sp.setLeftComponent(this.buildEditorPanel());
        sp.setRightComponent(this.buildJOSMSelectionPanel());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                sp.setDividerLocation(0.7);
            }
        });
        return pnl;
    }

    protected JToolBar buildToolBar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        tb.add(new ApplyAction());
        tb.addSeparator();
        DeleteAction actDelete = new DeleteAction();
        tb.add(actDelete);
        this.addPropertyChangeListener(actDelete);
        tb.addSeparator();
        SelectAction actSelect = new SelectAction();
        tb.add(actSelect);
        this.addPropertyChangeListener(actSelect);
        ZoomToAction actZoomTo = new ZoomToAction();
        tb.add(actZoomTo);
        this.addPropertyChangeListener(actZoomTo);
        return tb;
    }

    protected void build() {
        this.editorModel = new TurnRestrictionEditorModel(this.getLayer(), this);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)this.buildToolBar(), "North");
        c.add((Component)this.buildContentPanel(), "Center");
        c.add((Component)this.buildOkCancelButtonPanel(), "South");
        this.editorModel.getIssuesModel().addObserver(new IssuesModelObserver());
        this.setSize(600, 600);
    }

    public TurnRestrictionEditor(Component owner, OsmDataLayer layer) {
        this(owner, layer, null);
    }

    public TurnRestrictionEditor(Component owner, OsmDataLayer layer, Relation turnRestriction) throws IllegalArgumentException {
        super(JOptionPane.getFrameForComponent(owner), false);
        CheckParameterUtil.ensureParameterNotNull((Object)layer, (String)"layer");
        this.layer = layer;
        this.build();
        this.setTurnRestriction(turnRestriction);
    }

    protected Relation getTurnRestriction() {
        return this.turnRestriction;
    }

    protected void setTurnRestriction(Relation turnRestriction) {
        if (turnRestriction == null) {
            this.editorModel.populate(new Relation());
        } else if (turnRestriction.getDataSet() == null || turnRestriction.getDataSet() == this.getLayer().data) {
            this.editorModel.populate(turnRestriction);
        } else {
            throw new IllegalArgumentException(MessageFormat.format("turnRestriction must belong to layer ''{0}''", this.getLayer().getName()));
        }
        this.setTurnRestrictionSnapshot(turnRestriction == null ? null : new Relation(turnRestriction));
        this.turnRestriction = turnRestriction;
        this.support.firePropertyChange(TURN_RESTRICION_PROP, null, this.turnRestriction);
        this.updateTitle();
    }

    protected void updateTitle() {
        if (this.getTurnRestriction() == null || this.getTurnRestriction().getDataSet() == null) {
            this.setTitle(I18n.tr((String)"Create a new turn restriction in layer ''{0}''", (Object[])new Object[]{this.layer.getName()}));
        } else if (this.getTurnRestriction().isNew()) {
            this.setTitle(I18n.tr((String)"Edit a new turn restriction in layer ''{0}''", (Object[])new Object[]{this.layer.getName()}));
        } else {
            this.setTitle(I18n.tr((String)"Edit turn restriction ''{0}'' in layer ''{1}''", (Object[])new Object[]{Long.toString(this.turnRestriction.getId()), this.layer.getName()}));
        }
    }

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    protected Relation getTurnRestrictionSnapshot() {
        return this.turnRestrictionSnapshot;
    }

    protected void setTurnRestrictionSnapshot(Relation snapshot) {
        this.turnRestrictionSnapshot = snapshot;
        this.support.firePropertyChange(TURN_RESTRICION_SNAPSHOT_PROP, null, this.turnRestrictionSnapshot);
    }

    protected boolean isDirtyTurnRestriction() {
        return !this.turnRestriction.hasEqualSemanticAttributes((OsmPrimitive)this.turnRestrictionSnapshot);
    }

    public TurnRestrictionEditorModel getModel() {
        return this.editorModel;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && !this.isVisible()) {
            this.pnlJosmSelection.wireListeners();
            this.editorModel.registerAsEventListener();
            this.preferenceChangeHandler = new PreferenceChangeHandler();
            Main.pref.addPreferenceChangeListener((Preferences.PreferenceChangedListener)this.preferenceChangeHandler);
            this.pnlBasicEditor.initIconSetFromPreferences(Main.pref);
        } else if (!visible && this.isVisible()) {
            this.pnlJosmSelection.unwireListeners();
            this.editorModel.unregisterAsEventListener();
            Main.pref.removePreferenceChangeListener((Preferences.PreferenceChangedListener)this.preferenceChangeHandler);
        }
        super.setVisible(visible);
        if (!visible) {
            this.dispose();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void gotoBasicEditor() {
        this.tpEditors.setSelectedIndex(0);
    }

    @Override
    public void gotoAdvancedEditor() {
        this.tpEditors.setSelectedIndex(1);
    }

    @Override
    public void gotoBasicEditor(NavigationControler.BasicEditorFokusTargets focusTarget) {
        this.tpEditors.setSelectedIndex(0);
        this.pnlBasicEditor.requestFocusFor(focusTarget);
    }

    class PreferenceChangeHandler
    implements Preferences.PreferenceChangedListener {
        PreferenceChangeHandler() {
        }

        public void refreshIconSet() {
            TurnRestrictionEditor.this.pnlBasicEditor.initIconSetFromPreferences(Main.pref);
        }

        public void preferenceChanged(Preferences.PreferenceChangeEvent evt) {
            if (evt.getKey().equals("turnrestrictions.road-signs")) {
                this.refreshIconSet();
            } else if (evt.getKey().equals("turnrestrictions.show-vias-in-basic-editor")) {
                TurnRestrictionEditor.this.pnlBasicEditor.initViasVisibilityFromPreferences(Main.pref);
            }
        }
    }

    class IssuesModelObserver
    implements Observer {
        IssuesModelObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            int numWarnings = TurnRestrictionEditor.this.editorModel.getIssuesModel().getNumWarnings();
            int numErrors = TurnRestrictionEditor.this.editorModel.getIssuesModel().getNumErrors();
            String warningText = null;
            if (numWarnings > 0) {
                warningText = I18n.trn((String)"{0} warning", (String)"{0} warnings", (long)numWarnings, (Object[])new Object[]{numWarnings});
            }
            String errorText = null;
            if (numErrors > 0) {
                errorText = I18n.trn((String)"{0} error", (String)"{0} errors", (long)numErrors, (Object[])new Object[]{numErrors});
            }
            String title = "";
            if (errorText != null) {
                title = title + errorText;
            }
            if (warningText != null) {
                if (title.length() > 0) {
                    title = title + "/";
                }
                title = title + warningText;
            }
            if (title.length() == 0) {
                title = I18n.tr((String)"no issues", (Object[])new Object[0]);
            }
            TurnRestrictionEditor.this.tpEditors.setTitleAt(2, title);
            TurnRestrictionEditor.this.tpEditors.setEnabledAt(2, numWarnings + numErrors > 0);
        }
    }

    class ZoomToAction
    extends AbstractAction
    implements PropertyChangeListener {
        public ZoomToAction() {
            this.putValue("Name", I18n.tr((String)"Zoom to", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Activate the layer this turn restriction belongs to and zoom to it", (Object[])new Object[0]));
            new ImageProvider("dialogs/autoscale", "data").getResource().attachImageIcon((AbstractAction)this);
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            Relation tr = TurnRestrictionEditor.this.getTurnRestriction();
            this.setEnabled(tr != null && tr.getDataSet() != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Relation tr;
            if (Main.getLayerManager().getActiveLayer() != TurnRestrictionEditor.this.getLayer()) {
                Main.getLayerManager().setActiveLayer((Layer)TurnRestrictionEditor.this.getLayer());
            }
            if ((tr = TurnRestrictionEditor.this.getTurnRestriction()) == null || tr.getDataSet() == null) {
                return;
            }
            TurnRestrictionEditor.this.getLayer().data.setSelected(new PrimitiveId[]{tr});
            AutoScaleAction.zoomToSelection();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(TURN_RESTRICION_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    class SelectAction
    extends AbstractAction
    implements PropertyChangeListener {
        public SelectAction() {
            this.putValue("Name", I18n.tr((String)"Select", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Select this turn restriction", (Object[])new Object[0]));
            new ImageProvider("dialogs", "select").getResource().attachImageIcon((AbstractAction)this);
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            Relation tr = TurnRestrictionEditor.this.getTurnRestriction();
            this.setEnabled(tr != null && tr.getDataSet() != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Relation tr = TurnRestrictionEditor.this.getTurnRestriction();
            if (tr == null || tr.getDataSet() == null) {
                return;
            }
            TurnRestrictionEditor.this.getLayer().data.setSelected(new PrimitiveId[]{tr});
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(TURN_RESTRICION_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    class DeleteAction
    extends AbstractAction
    implements PropertyChangeListener {
        public DeleteAction() {
            this.putValue("Name", I18n.tr((String)"Delete", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Delete this turn restriction", (Object[])new Object[0]));
            new ImageProvider("dialogs", "delete").getResource().attachImageIcon((AbstractAction)this);
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            Relation tr = TurnRestrictionEditor.this.getTurnRestriction();
            this.setEnabled(tr != null && tr.getDataSet() != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Relation tr = TurnRestrictionEditor.this.getTurnRestriction();
            if (tr == null || tr.getDataSet() == null) {
                return;
            }
            org.openstreetmap.josm.actions.mapmode.DeleteAction.deleteRelation((OsmDataLayer)TurnRestrictionEditor.this.getLayer(), (Relation)tr);
            TurnRestrictionEditor.this.setVisible(false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(TURN_RESTRICION_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr((String)"Cancel the updates and close the dialog", (Object[])new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon((AbstractAction)this);
            this.putValue("Name", I18n.tr((String)"Cancel", (Object[])new Object[0]));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ESCAPE"));
            TurnRestrictionEditor.this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke("ESCAPE"), 2);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TurnRestrictionEditor.this.setVisible(false);
        }
    }

    class OKAction
    extends SavingAction {
        public OKAction() {
            this.putValue("ShortDescription", I18n.tr((String)"Apply the updates and close the dialog", (Object[])new Object[0]));
            new ImageProvider("ok").getResource().attachImageIcon((AbstractAction)this);
            this.putValue("Name", I18n.tr((String)"OK", (Object[])new Object[0]));
            this.setEnabled(true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            if (!this.confirmSaveDespiteOfErrorsAndWarnings()) {
                TurnRestrictionEditor.this.tpEditors.setSelectedIndex(2);
                return;
            }
            if (TurnRestrictionEditor.this.getTurnRestriction() == null || TurnRestrictionEditor.this.getTurnRestriction().getDataSet() == null) {
                if (!this.applyNewTurnRestriction()) return;
                TurnRestrictionEditor.this.setVisible(false);
                return;
            }
            Relation toUpdate = new Relation(TurnRestrictionEditor.this.getTurnRestriction());
            TurnRestrictionEditor.this.editorModel.apply(toUpdate);
            if (TurnRestrictionEditorModel.hasSameMembersAndTags(toUpdate, TurnRestrictionEditor.this.getTurnRestriction())) {
                TurnRestrictionEditor.this.setVisible(false);
                return;
            }
            if (TurnRestrictionEditor.this.isDirtyTurnRestriction()) {
                if (!this.confirmClosingBecauseOfDirtyState()) return;
                if (TurnRestrictionEditor.this.getLayer().getConflicts().hasConflictForMy((OsmPrimitive)TurnRestrictionEditor.this.getTurnRestriction())) {
                    this.warnDoubleConflict();
                    return;
                }
                this.applyExistingConflictingTurnRestriction();
            } else {
                this.applyExistingNonConflictingTurnRestriction();
            }
            TurnRestrictionEditor.this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }
    }

    class ApplyAction
    extends SavingAction {
        public ApplyAction() {
            this.putValue("ShortDescription", I18n.tr((String)"Apply the current updates", (Object[])new Object[0]));
            new ImageProvider("save").getResource().attachImageIcon((AbstractAction)this);
            this.putValue("Name", I18n.tr((String)"Apply", (Object[])new Object[0]));
            this.setEnabled(true);
        }

        public void run() {
            if (!this.confirmSaveDespiteOfErrorsAndWarnings()) {
                TurnRestrictionEditor.this.tpEditors.setSelectedIndex(2);
                return;
            }
            if (TurnRestrictionEditor.this.getTurnRestriction() == null || TurnRestrictionEditor.this.getTurnRestriction().getDataSet() == null) {
                this.applyNewTurnRestriction();
                return;
            }
            Relation toUpdate = new Relation(TurnRestrictionEditor.this.getTurnRestriction());
            TurnRestrictionEditor.this.editorModel.apply(toUpdate);
            if (TurnRestrictionEditorModel.hasSameMembersAndTags(toUpdate, TurnRestrictionEditor.this.getTurnRestriction())) {
                return;
            }
            if (TurnRestrictionEditor.this.isDirtyTurnRestriction()) {
                if (this.confirmClosingBecauseOfDirtyState()) {
                    if (TurnRestrictionEditor.this.getLayer().getConflicts().hasConflictForMy((OsmPrimitive)TurnRestrictionEditor.this.getTurnRestriction())) {
                        this.warnDoubleConflict();
                        return;
                    }
                    this.applyExistingConflictingTurnRestriction();
                    TurnRestrictionEditor.this.setVisible(false);
                }
            } else {
                this.applyExistingNonConflictingTurnRestriction();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }
    }

    abstract class SavingAction
    extends AbstractAction {
        SavingAction() {
        }

        protected boolean confirmSaveDespiteOfErrorsAndWarnings() {
            int numWarnings;
            int numErrors = TurnRestrictionEditor.this.editorModel.getIssuesModel().getNumErrors();
            if (numErrors + (numWarnings = TurnRestrictionEditor.this.editorModel.getIssuesModel().getNumWarnings()) == 0) {
                return true;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            sb.append(I18n.trn((String)"There is still an unresolved error or warning identified for this turn restriction. You are recommended to resolve this issue first.", (String)"There are still {0} errors and/or warnings identified for this turn restriction. You are recommended to resolve these issues first.", (long)(numErrors + numWarnings), (Object[])new Object[]{numErrors + numWarnings}));
            sb.append("<br>");
            sb.append(I18n.tr((String)"Do you want to save anyway?", (Object[])new Object[0]));
            HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Yes, save anyway", (Object[])new Object[0]), (Icon)ImageProvider.get((String)"ok"), I18n.tr((String)"Save the turn restriction despite of errors and/or warnings", (Object[])new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"No, resolve issues first", (Object[])new Object[0]), (Icon)ImageProvider.get((String)"cancel"), I18n.tr((String)"Cancel saving and start resolving pending issues first", (Object[])new Object[0]), null)};
            int ret = HelpAwareOptionPane.showOptionDialog((Component)JOptionPane.getFrameForComponent(TurnRestrictionEditor.this), (Object)sb.toString(), (String)I18n.tr((String)"Pending errors and warnings", (Object[])new Object[0]), (int)2, null, (HelpAwareOptionPane.ButtonSpec[])options, (HelpAwareOptionPane.ButtonSpec)options[1], (String)HelpUtil.ht((String)"/Plugin/TurnRestrictions#PendingErrorsAndWarnings"));
            return ret == 0;
        }

        protected List<RelationMember> getDeletedRelationMembers(Relation r) {
            ArrayList<RelationMember> ret = new ArrayList<RelationMember>();
            for (RelationMember rm : r.getMembers()) {
                if (!rm.getMember().isDeleted() && rm.getMember().isVisible()) continue;
                ret.add(rm);
            }
            return ret;
        }

        protected void removeDeletedMembers(Relation tr) {
            List members = tr.getMembers();
            Iterator it = members.iterator();
            while (it.hasNext()) {
                RelationMember rm = (RelationMember)it.next();
                if (!rm.getMember().isDeleted() && rm.getMember().isVisible()) continue;
                it.remove();
            }
            tr.setMembers(members);
        }

        protected boolean confirmSaveTurnRestrictionWithDeletePrimitives(List<RelationMember> deletedMembers) {
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            sb.append(I18n.trn((String)"This turn restriction refers to an object which was deleted outside of this turn restriction editor:", (String)"This turn restriction refers to {0} objects which were deleted outside of this turn restriction editor:", (long)deletedMembers.size(), (Object[])new Object[]{deletedMembers.size()}));
            sb.append("<ul>");
            for (RelationMember rm : deletedMembers) {
                sb.append("<li>");
                if (!rm.getRole().equals("")) {
                    sb.append(rm.getRole()).append(": ");
                }
                sb.append(rm.getMember().getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()));
                sb.append("</li>");
            }
            sb.append(I18n.tr((String)"Updates to this turn restriction can''t be saved unless deleted members are removed.<br>How to you want to proceed?", (Object[])new Object[0]));
            HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Remove deleted members and save", (Object[])new Object[0]), (Icon)ImageProvider.get((String)"ok"), I18n.tr((String)"Remove deleted members and save", (Object[])new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Cancel and return to editor", (Object[])new Object[0]), (Icon)ImageProvider.get((String)"cancel"), I18n.tr((String)"Cancel and return to editor", (Object[])new Object[0]), null)};
            int ret = HelpAwareOptionPane.showOptionDialog((Component)TurnRestrictionEditor.this, (Object)sb.toString(), (String)I18n.tr((String)"Deleted members in turn restriction", (Object[])new Object[0]), (int)2, null, (HelpAwareOptionPane.ButtonSpec[])options, (HelpAwareOptionPane.ButtonSpec)options[1], null);
            return ret == 0;
        }

        protected boolean applyNewTurnRestriction() {
            Relation newTurnRestriction = new Relation();
            TurnRestrictionEditor.this.editorModel.apply(newTurnRestriction);
            if (newTurnRestriction.getMembersCount() == 0 && !newTurnRestriction.hasKeys()) {
                return true;
            }
            List<RelationMember> deletedMembers = this.getDeletedRelationMembers(newTurnRestriction);
            if (!deletedMembers.isEmpty()) {
                if (!this.confirmSaveTurnRestrictionWithDeletePrimitives(deletedMembers)) {
                    return false;
                }
                this.removeDeletedMembers(newTurnRestriction);
            }
            Main.main.undoRedo.add((Command)new AddCommand(TurnRestrictionEditor.this.getLayer(), (OsmPrimitive)newTurnRestriction));
            TurnRestrictionEditor.this.setTurnRestriction(newTurnRestriction);
            TurnRestrictionEditorManager.getInstance().updateContext(TurnRestrictionEditor.this.getLayer(), TurnRestrictionEditor.this.getTurnRestriction(), TurnRestrictionEditor.this);
            return true;
        }

        protected void applyExistingConflictingTurnRestriction() {
            Relation toUpdate = new Relation(TurnRestrictionEditor.this.getTurnRestriction());
            TurnRestrictionEditor.this.editorModel.apply(toUpdate);
            Conflict conflict = new Conflict((OsmPrimitive)TurnRestrictionEditor.this.getTurnRestriction(), (OsmPrimitive)toUpdate);
            Main.main.undoRedo.add((Command)new ConflictAddCommand(TurnRestrictionEditor.this.getLayer(), conflict));
        }

        protected void applyExistingNonConflictingTurnRestriction() {
            if (TurnRestrictionEditor.this.getTurnRestriction().getDataSet() == null) {
                TurnRestrictionEditor.this.editorModel.apply(TurnRestrictionEditor.this.getTurnRestriction());
                Main.main.undoRedo.add((Command)new AddCommand((OsmPrimitive)TurnRestrictionEditor.this.getTurnRestriction()));
            } else {
                Relation toUpdate = new Relation(TurnRestrictionEditor.this.getTurnRestriction());
                TurnRestrictionEditor.this.editorModel.apply(toUpdate);
                Main.main.undoRedo.add((Command)new ChangeCommand((OsmPrimitive)TurnRestrictionEditor.this.getTurnRestriction(), (OsmPrimitive)toUpdate));
            }
            TurnRestrictionEditor.this.setTurnRestriction(TurnRestrictionEditor.this.getTurnRestriction());
        }

        protected boolean confirmClosingBecauseOfDirtyState() {
            HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Yes, create a conflict and close", (Object[])new Object[0]), (Icon)ImageProvider.get((String)"ok"), I18n.tr((String)"Create a conflict and close this turn restriction editor", (Object[])new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"No, continue editing", (Object[])new Object[0]), (Icon)ImageProvider.get((String)"cancel"), I18n.tr((String)"Return to the turn restriction editor and resume editing", (Object[])new Object[0]), null)};
            int ret = HelpAwareOptionPane.showOptionDialog((Component)Main.parent, (Object)I18n.tr((String)"<html>This turn restriction has been changed outside of the editor.<br>You cannot apply your changes and continue editing.<br><br>Do you want to create a conflict and close the editor?</html>", (Object[])new Object[0]), (String)I18n.tr((String)"Conflict in data", (Object[])new Object[0]), (int)2, null, (HelpAwareOptionPane.ButtonSpec[])options, (HelpAwareOptionPane.ButtonSpec)options[0], null);
            return ret == 0;
        }

        protected void warnDoubleConflict() {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"<html>Layer ''{0}'' already has a conflict for object<br>''{1}''.<br>Please resolve this conflict first, then try again.</html>", (Object[])new Object[]{TurnRestrictionEditor.this.getLayer().getName(), TurnRestrictionEditor.this.getTurnRestriction().getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), I18n.tr((String)"Already participating in a conflict", (Object[])new Object[0]), 2);
        }
    }
}

