/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.tools.I18n;

public class PlatformsFirstTest
extends Test {
    public static final int ERROR_CODE = 3701;

    public PlatformsFirstTest() {
        super(I18n.tr((String)"Platforms first", (Object[])new Object[0]), I18n.tr((String)"Checks if platforms are listed before ways in the route relation.", (Object[])new Object[0]));
    }

    public void visit(Relation r) {
        if (RouteUtils.isTwoDirectionRoute(r)) {
            List members = r.getMembers();
            RelationMember prevMember = null;
            for (RelationMember currMember : members) {
                if (prevMember != null && currMember.hasRole(new String[]{"platform"}) && prevMember.getType().equals((Object)OsmPrimitiveType.WAY) && prevMember.hasRole(new String[]{""})) {
                    this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"PT: route relation(s) contain(s) way(s) before platform(s) in the members list", (Object[])new Object[0]), 3701, (OsmPrimitive)r));
                    return;
                }
                prevMember = currMember;
            }
        }
    }
}

