/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.openstreetmap.josm.plugins.pt_assistant.actions.ThreadCompleteListener;

public abstract class NotifyingThread
extends Thread {
    private final Set<ThreadCompleteListener> listeners = new CopyOnWriteArraySet<ThreadCompleteListener>();

    public final void addListener(ThreadCompleteListener listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(ThreadCompleteListener listener) {
        this.listeners.remove(listener);
    }

    private final void notifyListeners() {
        for (ThreadCompleteListener listener : this.listeners) {
            listener.notifyOfThreadComplete(this);
        }
    }

    @Override
    public final void run() {
        try {
            this.doRun();
        }
        finally {
            this.notifyListeners();
        }
    }

    public abstract void doRun();
}

